	{ Ce schema decrit la presentation utilisee pour un Rapport.

	  V. Quint	Juin 1995 }

{ Variables utilisees : PAGE, ENGLISH, DRAFT, PRINTMAXPAGE, COUVERTURE,
			REFBIBCLE, RECTOVERSO, US_PAPER }
{ Variables utilisees pour V4 : PAGEV4, COLV4 }

#define LARGEUR_ENTETE * 87 %
#define RETRAIT_GROUPE 1
#define Paragraph_Skip 0.3

PRESENTATION Rapport;

VIEWS

   Texte_integral, Table_des_matieres
#ifdef PAGE
   , Vue_infos
#else
   , Vue_biblio
#endif
   ;

#ifdef PAGE
PRINT

   Texte_integral, Table_des_matieres;
#endif

COUNTERS

#ifdef PAGE
   CptPageAnnexe:  Rank of Page(Texte_integral) Init Num\351ro_prem_page;
   CptPageCorps:  Rank of Page(Texte_integral) Init Num\351ro_prem_page;
   CptPageTableMat: Set 0 on Rapport Add 1 on Page(Table_des_matieres);
#else
   CptAuteur: Rank of Auteur;
#endif
   CptAffiliation: Rank of Affiliation;
   CptFigure: Set 0 on Rapport Add 1 on Figure;
   CptNote: Rank of Note;
#ifndef REFBIBCLE
   CptBiblio: Rank of Citation_biblio;
#endif
   CptFormule: Set 0 on Rapport  Add 1 on Formule_num\351rot\351e;
   CptAnnexe: Rank of Annexe;
   CptSect1: Rank of Section 1 Init Num\351ro_prem_section;
   CptSect2: Rank of Section 2;
   CptSect3: Rank of Section 3;
   CptSect4: Rank of Section 4;

#ifdef PAGE
VAR

   VarPageAnnexe: Value (CptAnnexe, Uppercase) Text '-'
                   Value (CptPageAnnexe, Arabic);
#ifdef PRINTMAXPAGE
   VarPageCorps:  Value (CptPageCorps, Arabic) Text '/'
		  Value (MaxRangeVal CptPageCorps, Arabic);
#else
   VarPageCorps:  Value (CptPageCorps, Arabic);
#endif
   VarPageTableMat:Value (CptPageTableMat, LRoman);
#endif

BOXES

#ifdef COUVERTURE
   VirguleBlanc:
	Content: text ', ';
   Et:
	Content: text ' et ';
   NumPagesTotal:
	BEGIN
	Content: (text ' - ' Value (MaxRangeVal CptPageCorps, Arabic)
		  text ' pages');
	IN Vue_infos
	   Visibility: 0;
	END;
#endif

#ifdef DRAFT
   BoiteDateDraft:
	BEGIN
	HorizPos: Right = Enclosing . Right;
#ifdef ENGLISH
	Content: (Text 'DRAFT - ' DATE);
#else
	Content: (Text 'Version provisoire du ' FDATE);
#endif
	IN Table_des_matieres
	   Visibility: 0;
	END;

   BoiteNomFichier:
	BEGIN
	HorizPos: Right = Enclosing . Right;
	VertPos: Top = Previous . Bottom + 0.3;
	Content: (DirName Text '/' DocName);
	IN Table_des_matieres
	   Visibility: 0;
	END;
#endif DRAFT

   BoiteTitreCourant:
	BEGIN
#ifdef ENGLISH
	Content: Text 'Title head: ';
#else
	Content: Text 'Titre haut de page : ';
#endif
	Style: Bold;
	Font : Creator =;
	Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
	Visibility: Creator =;
	END;

   BoiteAuteursCourants:
	BEGIN
#ifdef ENGLISH
	Content: Text 'Author head: ';
#else
	Content: Text 'Auteurs haut de page : ';
#endif
	Style: Bold;
	Font : Creator =;
	Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
	Visibility: Creator =;
	END;

   BoiteReference:
	BEGIN
#ifdef ENGLISH
	Content: Text 'Reference: ';
#else
	Content: Text 'R\351f\351rence : ';
#endif
	Style: Bold;
	Font : Creator =;
	Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
#ifdef PAGE
	Visibility: 0;
	IN Vue_infos
	   Visibility: Creator =;
#else
	Visibility: Creator =;
#endif
	END;

   BoiteStatut:
	BEGIN
#ifdef ENGLISH
	Content: Text 'Status: ';
#else
	Content: Text 'Statut : ';
#endif
	Style: Bold;
	Font : Creator =;
	Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
#ifdef PAGE
	Visibility: 0;
	IN Vue_infos
	   Visibility: Creator =;
#else
	Visibility: Creator =;
#endif
	END;

   BoiteDate:
	BEGIN
#ifdef ENGLISH
	Content: Text 'Date: ';
#else
	Content: Text 'Date : ';
#endif
	Style: Bold;
	Font : Creator =;
	Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
#ifdef PAGE
	Visibility: 0;
	IN Vue_infos
	   Visibility: Creator =;
#else
	Visibility: Creator =;
#endif
	END;

#ifndef PAGE

   BoiteTitre:
	BEGIN
#ifdef ENGLISH
	Content: Text 'Title: ';
#else
	Content: Text 'Titre : ';
#endif
	Style: Bold;
	Font : Enclosing =;
	Size : Enclosing =;
	Foreground: Creator =;
	Background: Creator =;
	IN Table_des_matieres
	   Visibility: 0;
	END;

   BoiteAuteur:
	BEGIN
#ifdef ENGLISH
	Content: (Text 'Author ' Value(CptAuteur, Arabic) Text': ');
#else
	Content: (Text 'Auteur ' Value(CptAuteur, Arabic) Text' : ');
#endif
	Style: Bold;
	Font : Creator =;
	Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

   BoiteAffiliation:
	BEGIN
	Content: Text 'Affiliation ';
	Style: Bold;
	Font : Creator =;
	Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

   BoiteDeuxPoints:
	BEGIN
	Content: Text ': ';
	Style: Bold;
	Font : Creator =;
	Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

#endif	PAGE

   NumeroAffiliation:
	BEGIN
	Content: (Text '(' Value (CptAffiliation, Lowercase) Text ')');
#ifndef PAGE
	Style: Bold;
#endif
	END;

   Espace:
	Content: Text ' ';

   BoiteResume:
	BEGIN
	HorizPos: Left = Next . Left;
	VertPos: Top = Previous . Bottom + 1 cm;
	Content: Text 'R\351sum\351 :';
	Style: Bold;
	Font : Creator =;
	Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

   BoiteMotsCles:
	BEGIN
	Content: Text 'Mots cl\351s : ';
	Style: Bold;
	Font : Creator =;
	Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

   BoiteAbstract:
	BEGIN
	HorizPos: Left = Next . Left;
	VertPos: Top = Previous . Bottom + 0.3;
	Content: Text 'Abstract:';
	Style: Bold;
	Font : Creator =;
	Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

#ifdef COUVERTURE
   BoiteCopieTitre:
	BEGIN
	Copy(Titre);
	Style: Roman;
	Size : Enclosing + 7;
	Width: Enclosed . Width;
	HorizPos: VMiddle = Enclosing . VMiddle;
	Adjust: VMiddle;
	IN Table_des_matieres
	   Visibility: 0;
	END;
#else
   BoiteTitle:
	BEGIN
	Content: Text 'Title: ';
	Style: Bold;
	Font : Creator =;
	Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;
#endif COUVERTURE

   BoiteKeywords:
	BEGIN
	Content: Text 'Keywords: ';
	Style: Bold;
	Font : Creator =;
	Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

   NumeroNote:
	BEGIN
	VertPos: Top = Previous . Bottom + 0.35;
	Width: 1.8;
	Content: (Text '(' Value (CptNote, Arabic) Text ')');
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

   BoiteFigure:
	BEGIN
	HorizPos: Left = Previous . Right;
	VertPos: nil;
	Content: (text 'Figure');
	Style: Creator =;
	Font : Creator =;
	Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

   NumeroFigure:
	BEGIN
	HorizPos: Left = Previous . Right;
	VertPos: nil;
	Content: (text '\240' Value(CptFigure, Arabic));
	Style: Creator =;
	Font : Creator =;
	Size : Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

   DeuxPoints:
	BEGIN
#ifdef ENGLISH
	Content: (text ': ');
#else
	Content: (text '\240: ');
#endif
	Font : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

   NumeroFormule:
	BEGIN
	HorizPos: Right = Enclosing . Right;
	VertPos: HRef = Next Formule_num\351rot\351e . HRef;
	Content: (text '(' Value (CptFormule, Arabic) text ')');
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

#ifdef REFBIBCLE
   CrochetOuvr:
        Content: text '[';

   CrochetFerm:
        Content: text ']';
#else

   NumeroBiblio:
	BEGIN
	VertPos: Top = Previous . Bottom + 0.6;
	Content: (text '['  Value (CptBiblio, Arabic) text ']');
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;
#endif

   BoiteBiblio:
	BEGIN
	Size : Enclosing + 5;
	VertPos: Top = Enclosing . Top;
#ifdef ENGLISH
	Content: text 'Bibliography';
#else
	Content: text 'Bibliographie';
#endif
	IN Table_des_matieres
	   BEGIN
	   VertPos: Top = Enclosing . Top + 0.3;
	   Size : Enclosing =;
	   Style: Bold;
	   END;
	END;

   NumeroSect1:
	BEGIN
	Size : Creator =;
	Font : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	VertPos: HRef = Next . HRef;
	Content: (Value (CptSect1, Arabic));
	END;

   NumeroSect2:
	BEGIN
	Size : Creator =;
	Font : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
{	VertPos: HRef = Next . HRef; BUG IRENE }
	VertPos: Top = Enclosing . Top;
	Content: (Value (CptSect1, Arabic) text '.' Value (CptSect2, Arabic));
	END;

   NumeroSect3:
	BEGIN
	Size: Creator =;
	Font : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
{	VertPos: HRef = Next . HRef; BUG IRENE }
	VertPos: Top = Enclosing . Top;
	Content: (Value (CptSect1, Arabic) text '.' Value (CptSect2, Arabic)
		  text '.' Value (CptSect3, Arabic));
	END;

   NumeroSect4:
	BEGIN
	Size: Creator =;
	Font : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
{	VertPos: HRef = Next . HRef; BUG IRENE }
	VertPos: Top = Enclosing . Top;
	Content: (Value (CptSect1, Arabic) text '.' Value (CptSect2, Arabic)
		  text '.' Value (CptSect3, Arabic)
		  text '.' Value (CptSect4, Arabic));
	END;

   NumeroSect1Annexe:
	BEGIN
	Size : Creator =;
	Font : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	VertPos: HRef = Next . HRef;
	Content: (Value (CptAnnexe, Uppercase) Text '.'
		  Value (CptSect1, Arabic));
	END;

   NumeroSect2Annexe:
	BEGIN
	Size : Creator =;
	Font : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	VertPos: HRef = Next . HRef;
	Content: (Value (CptAnnexe, Uppercase) Text '.'
		  Value (CptSect1, Arabic) text '.'
		  Value (CptSect2, Arabic));
	END;

   NumeroSect3Annexe:
	BEGIN
	Size: Creator =;
	Font : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	VertPos: HRef = Next . HRef;
	Content: (Value (CptAnnexe, Uppercase) Text '.'
		  Value (CptSect1, Arabic) text '.'
		  Value (CptSect2, Arabic) text '.'
		  Value (CptSect3, Arabic));
	END;

   NumeroSect4Annexe:
	BEGIN
	Size: Creator =;
	Font : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	VertPos: HRef = Next . HRef;
	Content: (Value (CptAnnexe, Uppercase) Text '.'
		  Value (CptSect1, Arabic) text '.'
		  Value (CptSect2, Arabic) text '.'
		  Value (CptSect3, Arabic) text '.'
		  Value (CptSect4, Arabic));
	END;

   NumeroAnnexe:
	BEGIN
	Size : Creator =;
	Style: Creator =;
	VertPos: HRef = Next . HRef;
	HorizPos: Left = Enclosing . Left;
#ifdef ENGLISH
	Content: (Text 'Appendix ' Value (CptAnnexe, Uppercase) Text ' ');
#else
	Content: (Text 'Annexe ' Value (CptAnnexe, Uppercase) Text ' ');
#endif
	IN Table_des_matieres
	   BEGIN
	   Visibility: 5;
	   Size : Enclosing =;
	   END;
#ifdef PAGE
	IN Vue_infos
	   Style: bold;
#endif
	END;

#ifdef PAGE
   NumPageSect:
	BEGIN
	Visibility: 0;
	IN Table_des_matieres
	   BEGIN
	   Visibility: 5;
	   VertPos: Bottom = Previous . Bottom;
	   HorizPos: Right = Enclosing . Right;
	   Content: (Value (PageNumber(Texte_integral), Arabic));
	   END;
	END;

#ifdef PAGEV4
   MargeHautPage:  { CP }
	BEGIN
	Height: 1.5 cm;
	Width: 2;
	Content: Graphics ' ';
	END;

   MargeHautPremPage: { CP }
	BEGIN
	Height: 3.1 cm;
	Width: 2;
	Content: Graphics ' ';
	END;
#endif
		

#ifdef RECTOVERSO
   NumPagePaireCorps:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Content: VarPageCorps;
#ifdef PAGEV4
	VertPos: Top =  Previous . Bottom ; { CP }
	HorizPos: Left =  Enclosing . Left; { CP }
#else
	VertPos: Top = Previous PAGE_BREAK . Bottom + 0.3 cm;
	HorizPos: Left = Previous PAGE_BREAK . Left;
#endif
	Height:   1.6 cm;
	Size : 11 pt;
	Font: times;
	Style: Roman;
	END;
#endif

   NumPageImpaireCorps:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Content: VarPageCorps;
#ifdef PAGEV4
	VertPos: Top =  Previous . Bottom ; { CP }
	HorizPos: Left =  Enclosing . Left; { CP }
#else
	VertPos: Top = Previous PAGE_BREAK . Bottom + 0.3 cm;
	HorizPos: Right = Previous PAGE_BREAK . Right;
#endif
	Height:   1.6 cm;
	Size : 11 pt;
	Font: times;
	Style: Roman;
	END;

   HautGaucheTitreArt:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Copy (Titre_courant);
	Justify: No;
#ifdef RECTOVERSO
#ifdef PAGEV4
	HorizPos: Left = Enclosing . Left + 1.2 cm; { CP }
#else
	HorizPos: Left = Previous PAGE_BREAK . Left + 1.2 cm;
#endif
#else
	HorizPos: Left = Previous PAGE_BREAK . Left;
#endif
#ifdef PAGEV4
	VertPos: Top =  Previous . Top ; { CP }
#else
	VertPos: Top = Previous PAGE_BREAK . Bottom + 0.3 cm;
#endif
	Height:   1.6 cm;
	Size : 11 pt;
	Font: times;
	Style: Italics;
	END;

#ifdef PAGEV4
   HautDePage: { CP }
        BEGIN
        Background : White;
        Foreground : Black;
        Fillpattern : nopattern;
	Width: Enclosing . Width; { CP }
        VertPos: Top = Previous . Bottom;
        HorizPos: Left = Enclosing . Left;
	IF One(CptPageCorps) CreateFirst (MargeHautPremPage);
	IF NOT One(CptPageCorps) CreateFirst (MargeHautPage);
#ifdef RECTOVERSO
        IF Even(CptPageCorps) CreateFirst (NumPagePaireCorps);
        IF Even(CptPageCorps) CreateFirst (HautGaucheTitreArt);
        IF NOT One(CptPageCorps) AND Odd(CptPageCorps) 
			CreateFirst (NumPageImpaireCorps);
#else
        IF NOT One(CptPageCorps) CreateFirst (NumPageImpaireCorps);
#endif
       END;
#endif

   BasPage:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Height: 0.5 cm;
#ifdef PAGEV4
        VertPos: Top = Previous . Bottom; { CP }
        HorizPos: VMiddle = Enclosing . VMiddle; { CP }
#else
	VertPos: Bottom = Next PAGE_BREAK . Top;
	HorizPos: VMiddle = Next PAGE_BREAK . VMiddle;
#endif
	Content: (Text ' ');
	Size : 8 pt;
	Font: times;
	Style: Roman;
	END;

   EspaceBasPage:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Height: 1.4 cm;
	Width: 1 pt;
#ifdef PAGEV4
        VertPos: Top = Previous . Bottom; { CP }
        HorizPos: Left = Enclosing . Left; { CP }
#else
	VertPos: Bottom = Next PAGE_BREAK . Top;
	HorizPos: Left = Next PAGE_BREAK . Left;
#endif
	Content: (Graphics ' ');
	IN Table_des_matieres
	   Visibility: 5;
	END;

#ifdef PAGEV4
   BasDePage: { CP }
        BEGIN
        VertPos: Top = Previous . Bottom;
        HorizPos: Left = Enclosing . Left;
        Width: Previous . Width;
        Content : Note;
        CreateFirst (EspaceBasPage);
        CreateFirst (BasPage);
       END;
#endif PAGEV4

#ifdef PAGEV4
   Filet: { CP : filet de separation de page }
        BEGIN
        Height: 1 pt;
        Width: Enclosing . Width;
        VertPos: Top = Previous . Bottom;
        HorizPos: Left = Enclosing . Left;
        Content: Graphics 'h';
        END;
#endif

   FiletNote:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Height: 0.5 cm;
	Width: 3 cm;
	VertPos: Top = Enclosing .Top;
	HorizPos: Left = Enclosing .Left;
	Size : 8 pt;
	Content: Graphics 'h';
	END;

#ifndef PAGEV4
   { BoiteNotes supprimee dans V4 : Les regles sont associees 
     a l element Notes } { CP }
   BoiteNotes:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	CreateFirst(FiletNote);
	Content: Note;
	VertPos: Bottom =  Next PAGE_BREAK . Top - 1.3 cm;
	HorizPos: Left = Next PAGE_BREAK . Left;
	Height: Enclosed . Height;
	Width: Next PAGE_BREAK . Width;
	END;
#endif

#ifdef PAGEV4
   PageCorps:
	BEGIN
#ifdef US_PAPER
	Width: 15,6 cm;
	Height: 22.8 cm;
#else
	Width: 15 cm;
	Height: 24.5 cm;
#endif
        VertPos: Top = Previous . Bottom;
        HorizPos: Left = Enclosing . Left;
        CreateBefore (HautDePage); { CP }
        CreateAfter (BasDePage); { CP }
        CreateAfter (Filet); { CP }
	END;
#else
   PageCorps:
	BEGIN
#ifdef US_PAPER
	Width: 14.6 cm;
	Height: 23.3 cm;
	HorizPos: Left = Enclosing . Left + 3.2 cm;
#else
	Width: 14 cm;
	Height: 25 cm;
	HorizPos: Left = Enclosing . Left + 3.5 cm;
#endif
	VertPos: Top = Enclosing . Top + 2 cm;
#ifdef RECTOVERSO
	IF Even(CptPageCorps) CreateAfter (NumPagePaireCorps);
	IF Even(CptPageCorps) CreateAfter (HautGaucheTitreArt);
	IF Odd(CptPageCorps) AND Not One(CptPageCorps)
	   CreateAfter (NumPageImpaireCorps);
#else
	IF Not One(CptPageCorps) CreateAfter (HautGaucheTitreArt);
	IF Not One(CptPageCorps) CreateAfter (NumPageImpaireCorps);
#endif
	IF Not One(CptPageCorps) CreateBefore (BoiteNotes);
	IF Not One(CptPageCorps) CreateBefore (EspaceBasPage);
	IF Not One(CptPageCorps) CreateBefore (BasPage);
	END;
#endif

#ifdef COUVERTURE
#ifdef RECTOVERSO
   NumPagePaireAnnexe:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Content: VarPageAnnexe;
#ifdef PAGEV4
	VertPos: Top = Previous . Bottom; { CP }
	HorizPos: Left = Enclosing . Left; { CP }
#else
	VertPos: Top = Previous PAGE_BREAK . Bottom + 0.3 cm;
	HorizPos: Left = Previous PAGE_BREAK . Left;
#endif
	Height:   1.6 cm;
	Size : 11 pt;
	Font: times;
	Style: Roman;
	END;
#endif RECTOVERSO

   NumPageImpaireAnnex:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Content: VarPageAnnexe;
#ifdef PAGEV4
	VertPos: Top =  Previous . Bottom; { CP }
	HorizPos: Right = Enclosing . Right; { CP }
#else
	VertPos: Top = Previous PAGE_BREAK . Bottom + 0.3 cm;
	HorizPos: Right = Previous PAGE_BREAK . Right;
#endif
	Height:   1.6 cm;
	Size : 11 pt;
	Font: times;
	Style: Roman;
	END;

   HautTitreAnnexe:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Copy (Titre_courant_annexe);
	Justify: No;
#ifdef RECTOVERSO
#ifdef PAGEV4
	HorizPos: Right = Enclosing  . Right - 1.2 cm; { CP }
#else
	HorizPos: Right = Previous PAGE_BREAK . Right - 1.2 cm;
#endif
#else
#ifdef PAGEV4
	HorizPos: Left = Enclosing . Left; { CP }
#else
	HorizPos: Left = Previous PAGE_BREAK . Left;
#endif
#endif
#ifdef PAGEV4
	VertPos: Top =  Previous . Bottom; { CP }
#else
	VertPos: Top = Previous PAGE_BREAK . Bottom + 0.3 cm;
#endif
	Height:   1.6 cm;
	Size : 11 pt;
	Font: times;
	Style: Italics;
	END;

#ifdef PAGEV4
   HautDePageAnnexe: { CP }
        BEGIN
        Background : White;
        Foreground : Black;
        Fillpattern : nopattern;
        VertPos: Top = Previous . Bottom;
        HorizPos: Left = Previous . Left;
	CreateFirst (MargeHautPage);
#ifdef RECTOVERSO
        IF Even(CptPageAnnexe) CreateFirst (NumPagePaireAnnexe);
        IF Even(CptPageAnnexe) CreateFirst (HautGaucheTitreArt);
        IF Odd(CptPageAnnexe) CreateFirst (NumPageImpaireAnnex);
        IF Odd(CptPageAnnexe)  AND Not One(CptPageAnnexe)
            CreateFirst (HautTitreAnnexe);
#else
	CreateFirst (NumPageImpaireAnnex);
	IF Not One(CptPageAnnexe) CreateFirst (HautTitreAnnexe);
#endif
        END;
#endif PAGEV4

#ifdef PAGEV4
   PageAnnexe:
	BEGIN
#ifdef US_PAPER
	Width: 15,6 cm;
	Height: 22.8 cm;
#else
	Width: 15 cm;
	Height: 24.5 cm;
#endif
        VertPos: Top = Previous . Bottom;
        HorizPos: Left = Enclosing . Left;
        CreateBefore (HautDePageAnnexe); { CP }
        CreateAfter (BasDePage); { CP }
        CreateAfter (Filet); { CP }
	END;

#else PAGEV4
   PageAnnexe:
	BEGIN
#ifdef US_PAPER
	Width: 14.6 cm;
	Height: 23.3 cm;
	HorizPos: Left = Enclosing . Left + 3.2 cm;
#else
	Width: 14 cm;
	Height: 25 cm;
	HorizPos: Left = Enclosing . Left + 3.5 cm;
#endif
	VertPos: Top = Enclosing . Top + 2 cm;
#ifdef RECTOVERSO
	IF Even(CptPageAnnexe) CreateAfter (NumPagePaireAnnexe);
	IF Even(CptPageAnnexe) CreateAfter (HautGaucheTitreArt);
	IF Odd(CptPageAnnexe) CreateAfter (NumPageImpaireAnnex);
	IF Odd(CptPageAnnexe) AND Not One(CptPageAnnexe)
	   CreateAfter (HautTitreAnnexe);
#else
	CreateAfter (NumPageImpaireAnnex);
	IF Not One(CptPageAnnexe) CreateAfter (HautTitreAnnexe);
#endif
	CreateBefore (BoiteNotes);
	CreateBefore (BasPage);
	CreateBefore (EspaceBasPage);
	END;
#endif PAGEV4
#endif COUVERTURE

#ifndef PAGEV4
   EspaceHautPage:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Height: 1 cm;
	Width: 1 pt;
	VertPos: Top = Previous PAGE_BREAK . Bottom;
	HorizPos: Left = Next PAGE_BREAK . Left;
	Content: (Graphics ' ');
	IN Table_des_matieres
	   Visibility: 5;
	END;
#endif PAGEV4

#ifdef PAGEV4
   HautPageTableMat: { CP }
        BEGIN
        Background : White;
        Foreground : Black;
        Fillpattern : nopattern;
        VertPos: Top = Previous . Bottom;
        HorizPos: Left = Previous . Left;
	CreateFirst (MargeHautPremPage);
        END;
#endif PAGEV4

   NumPageTableMat:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Content: VarPageTableMat;
#ifdef PAGEV4
	VertPos: Top = Enclosing . Top + 1 cm ; { CP }
	HorizPos: VMiddle = Enclosing . VMiddle; { CP }
#else PAGEV4
	VertPos: Bottom = Next PAGE_BREAK . Top;
	HorizPos: VMiddle = Next PAGE_BREAK . VMiddle;
#endif PAGEV4
	Height:   0.6 cm;
	Size : 11 pt;
	Font: times;
	Style: Roman;
	IN Table_des_matieres
	   Visibility: 5;
	END;

#ifdef PAGEV4
   BasPageTableMat: { CP }
        BEGIN
        VertPos: Top = Previous . Bottom;
        HorizPos: Left = Previous . Left;
        Width: Previous . Width;
        CreateFirst (NumPageTableMat);
        CreateFirst (EspaceBasPage);
        END;
#endif PAGEV4

#ifdef PAGEV4
   PageTableMat:
	BEGIN
#ifdef US_PAPER
	Width: 15,6 cm;
	Height: 21.8 cm;
#else
	Width: 15 cm;
	Height: 23.5 cm;
#endif
        VertPos: Top = Previous . Bottom ; { CP }
        HorizPos: Left = Enclosing . Left ; { CP } 
        CreateBefore (HautPageTableMat); { CP }
        CreateAfter (BasPageTableMat); { CP }
        CreateAfter (Filet); { CP }
	END;

#else PAGEV4
   PageTableMat:
	BEGIN
#ifdef US_PAPER
	Width: 14.6 cm;
	Height: 23.3 cm;
	HorizPos: Left = Enclosing . Left + 3.2 cm;
#else
	Width: 14 cm;
	Height: 25 cm;
	HorizPos: Left = Enclosing . Left + 3.5 cm;
#endif
	VertPos: Top = Enclosing . Top + 2 cm;
	CreateAfter(EspaceHautPage);
	IF not One(CptPageTableMat) CreateBefore (NumPageTableMat);
	IF Not One(CptPageTableMat) CreateBefore (EspaceBasPage);
	END;
#endif PAGEV4
#endif PAGE

RULES

   Rapport:
	BEGIN
	Style: Roman;
	VertPos: Top = Enclosing . Top;
	Visibility: 10;
	Indent: 0;
	Adjust: Left;
	LineSpacing: 1.1;
	Foreground: Black;
	BackGround: White;
	Hyphenate: No;
#ifdef DRAFT
	CreateFirst(BoiteDateDraft);
	CreateFirst(BoiteNomFichier);
#endif
#ifndef PAGE
	Width: Enclosing . Width - 2;
	HorizPos: Left = Enclosing . Left + 1;
	Justify: No;
	Size : 11 pt;
	Font: helvetica;
#else
#ifdef PAGEV4
	Width: 15 cm; { CP }
	HorizPos: Left = Enclosing . Left + 3 cm; { CP }
#else PAGEV4
	HorizPos: VMiddle = Enclosing . VMiddle;
#endif PAGEV4
	Justify: Yes;
	Size : 11 pt;
	Font: times;
	Page(PageCorps);
	IN Table_des_matieres
	   Page(PageTableMat);
	IN Vue_infos
	   BEGIN
	   Width: Enclosing . Width - 2;
	   HorizPos: Left = Enclosing . Left + 1;
	   Justify: No;
	   Hyphenate: No;
	   END;
#endif
	END;

   Entete:
	BEGIN
	Width: Enclosing . Width;
#ifndef PAGE
	IN Vue_biblio
	   Visibility: 0;
#endif
	IN Table_des_matieres
	   Visibility: 0;
	END;

   Titre_courant :
	BEGIN
	CreateFirst(BoiteTitreCourant);
	HorizPos: Left = Enclosing . Left;
	VertPos : Top = Previous . Bottom + 0.3;
	Width: Enclosing . Width;
	Indent: -3;
	Line;
	Justify: No;
	Hyphenate: No;
#ifdef PAGE
	Visibility: 0;
	IN Vue_infos
	   Visibility: Enclosing =;
#endif
	IN Table_des_matieres
	   Visibility: 0;
	END;

   Auteurs_courants :
	BEGIN
	CreateFirst(BoiteAuteursCourants);
	Width: Enclosing . Width;
	HorizPos: Left = Enclosing . Left;
	VertPos : Top = Previous . Bottom + 0.2;
	Indent: -3;
	Line;
	Justify: No;
	Hyphenate: No;
#ifdef PAGE
	Visibility: 0;
	IN Vue_infos
	   Visibility: Enclosing =;
#endif
	IN Table_des_matieres
	   Visibility: 0;
	END;
   
   R\351f\351rence :
	BEGIN
#ifdef COUVERTURE
	CreateLast(NumPagesTotal);
	Width: Enclosing . Width * 75 %;
	VertPos: Top = Statut . Bottom + 0.5 cm;
	HorizPos: VMiddle = Enclosing . VMiddle;
	Adjust: VMiddle;
#else
#ifdef PAGE
	Width: Enclosing . Width LARGEUR_ENTETE;
	HorizPos: Right = Enclosing . Right;
#else
	Width: Enclosing . Width;
	HorizPos: Left = Enclosing . Left;
	Indent: -3;
#endif
	VertPos : Top = Previous . Bottom + 0.2;
#endif COUVERTURE
	CreateFirst(BoiteReference);
	Line;
	Justify: No;
	Hyphenate: No;
	IN Table_des_matieres
	   Visibility: 0;
#ifdef PAGE
	IN Vue_infos
	   BEGIN
	   Width: Enclosing . Width;
	   HorizPos: Left = Enclosing . Left;
	   Indent: -3;
#ifdef COUVERTURE
	   VertPos : Top = Previous . Bottom + 0.3;
	   Adjust: Left;
#endif
	   END;
#endif
	END;

   Statut :
	BEGIN
#ifdef COUVERTURE
	Width: Enclosing . Width * 75 %;
	VertPos: Top = Auteurs . Bottom + 0.5 cm;
	HorizPos: VMiddle = Enclosing . VMiddle;
	Adjust: VMiddle;
#else
#ifdef PAGE
	Width: Enclosing . Width LARGEUR_ENTETE;
	HorizPos: Right = Enclosing . Right;
#else
	Width: Enclosing . Width;
	HorizPos: Left = Enclosing . Left;
	Indent: -3;
#endif
	VertPos : Top = Previous . Bottom + 0.3;
#endif COUVERTURE
	CreateFirst(BoiteStatut);
	Line;
	Justify: No;
	Hyphenate: No;
	IN Table_des_matieres
	   Visibility: 0;
#ifdef PAGE
	IN Vue_infos
	   BEGIN
	   Width: Enclosing . Width;
	   HorizPos: Left = Enclosing . Left;
	   Indent: -3;
#ifdef COUVERTURE
	   VertPos : Top = Previous . Bottom + 0.3;
	   Adjust: Left;
#endif
	   END;
#endif
	END;

   Date_de_mise_a_jour :
	BEGIN
#ifdef COUVERTURE
	Visibility: 0;
#else
#ifdef PAGE
	Width: Enclosing . Width LARGEUR_ENTETE;
	HorizPos: Right = Enclosing . Right;
#else
	Width: Enclosing . Width;
	HorizPos: Left = Enclosing . Left;
	Indent: -3;
#endif
	VertPos : Top = Previous . Bottom + 0.3;
	Line;
	Justify: No;
	Hyphenate: No;
#endif COUVERTURE
	CreateFirst(BoiteDate);
	IN Table_des_matieres
	   Visibility: 0;
#ifdef PAGE
	IN Vue_infos
	   BEGIN
	   Width: Enclosing . Width;
	   HorizPos: Left = Enclosing . Left;
	   Indent: -3;
#ifdef COUVERTURE
	   Visibility: Enclosing =;
	   VertPos : Top = Previous . Bottom + 0.3;
	   Line;
	   Justify: No;
	   Hyphenate: No;
	   Adjust: Left;
#endif
	   END;
#endif
	END;

   Titre:
	BEGIN
	Style: Roman;
	Size : Enclosing + 7;
#ifdef COUVERTURE
	Width: Enclosing . Width * 75 %;
	VertPos: Top = Enclosing . Top + 3.5 cm;
	HorizPos: VMiddle = Enclosing . VMiddle;
	Adjust: VMiddle;
#else
#ifdef PAGE
	Width: Enclosing . Width LARGEUR_ENTETE;
	VertPos: Top = Enclosing . Top + 3.5;
	HorizPos: Right = Enclosing . Right;
#else
	Width: Enclosing . Width;
	VertPos: Top = Previous . Bottom + 0.3;
	CreateFirst(BoiteTitre);
	Indent: -2;
#endif
#endif	COUVERTURE
	Line;
	Justify: No;
	IN Table_des_matieres
	   BEGIN
	   Visibility: 8;
	   Size : Enclosing + 3;
	   HorizPos: VMiddle = Enclosing . VMiddle;
	   Line;
	   Adjust: VMiddle;
	   END;
#ifdef PAGE
	IN Vue_infos
	   Visibility: 0;
#endif
	END;

   Auteurs:
	BEGIN
	Style: Italics;
#ifdef COUVERTURE
	Width: Enclosing . Width * 75%;
	VertPos: Top = Previous . Bottom + 1.2 cm;
	HorizPos: VMiddle = Enclosing . VMiddle;
	Line;
	Adjust: VMiddle;
#else
#ifdef PAGE
	Width: Enclosing . Width LARGEUR_ENTETE;
	VertPos: Top = Previous . Bottom + 1.5;
	HorizPos: Right = Enclosing . Right;
#else
	Width: Enclosing . Width;
	VertPos: Top = Previous . Bottom + 0.5;
#endif
#endif COUVERTURE
	IN Table_des_matieres
	   Visibility: 0;
#ifdef PAGE
	IN Vue_infos
	   Visibility: 0;
#endif
	END;

   Auteur:
	BEGIN
#ifdef COUVERTURE
	if not first and not last createbefore(VirguleBlanc);
	if last and not first createbefore (Et);
#else
	Width: Enclosing . Width;
	VertPos: Top = Previous . Bottom + 0.3;
	Line;
#ifndef PAGE
	CreateFirst(BoiteAuteur);
#endif
#endif COUVERTURE
	Justify: No;
	END;

   Affiliations:
	BEGIN
#ifdef COUVERTURE
	Width: Enclosing . Width;
	VertPos: Top = Mots_cl\351s . Bottom + 4 cm;
	HorizPos: Left = Enclosing . Left;
#else
#ifdef PAGE
	Width: Enclosing . Width LARGEUR_ENTETE;
	VertPos: Top = Previous . Bottom + 1;
	HorizPos: Right = Enclosing . Right;
#else
	Width: Enclosing . Width;
	VertPos: Top = Previous . Bottom + 0.3;
#endif
#endif COUVERTURE
	IN Table_des_matieres
	   Visibility: 0;
#ifdef PAGE
	IN Vue_infos
	   Visibility: 0;
#endif
	END;

   Affiliation:
	BEGIN
#ifndef PAGE
	CreateFirst(BoiteAffiliation);
#endif
	IF Referred
	   BEGIN
	   CreateFirst(NumeroAffiliation);
	   CreateFirst(Espace);
	   END;
#ifndef PAGE
	CreateFirst(BoiteDeuxPoints);
#endif
	Width: Enclosing . Width;
	VertPos: Top = Previous . Bottom + 0.3;
	PageBreak: No;
	Line;
	Justify: No;
	END;

   R\351sum\351:
	BEGIN
#ifdef COUVERTURE
	CreateFirst(BoiteResume);
	Width: Enclosing . Width;
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = R\351f\351rence . Bottom + 2.3 cm;
#else
	CreateBefore(BoiteResume);
	Width: Enclosing . Width LARGEUR_ENTETE;
	HorizPos: Right = Enclosing . Right;
	VertPos: Top = Previous . Bottom + 0.3;
#endif
	Indent: 0;
	Hyphenate: Yes;
	IN Table_des_matieres
	   Visibility: 0;
#ifdef PAGE
	IN Vue_infos
	   Visibility: 0;
#endif
	END;

   Mots_cl\351s :
	BEGIN
	CreateFirst(BoiteMotsCles);
#ifdef COUVERTURE
	Width: Enclosing . Width;
	HorizPos: Left = Enclosing . Left;
#else
	Width : Enclosing . Width LARGEUR_ENTETE;
	HorizPos: Right = Enclosing . Right;
#endif
	VertPos : Top = Previous . Bottom + 0.3;
	Indent: -3;
	Line;
	Justify: No;
	IN Table_des_matieres
	   Visibility: 0;
#ifdef PAGE
	IN Vue_infos
	   Visibility: 0;
#endif
	END;

   Corps:
	BEGIN
	Width: Enclosing . Width;
	Indent : 1;
	Hyphenate: Yes;
#ifdef COUVERTURE
	Page(PageCorps);
	CreateFirst(BoiteCopieTitre);
	VertPos : Top = Previous . Bottom;
#else
	VertPos : Top = Previous . Bottom + 1.5;
#ifndef PAGE
	IN Vue_biblio
	   Visibility: 0;
#endif
#endif	COUVERTURE
#ifdef PAGE
	IN Vue_infos
	   Visibility: 0;
#endif
	END;

   Pr\351ambule :
	BEGIN
	Width : Enclosing . Width;
	if within Corps
#ifdef COUVERTURE
	   VertPos : Top = BoiteCopieTitre . Bottom + 1.5 cm;
#else
	   VertPos : Top = Previous . Bottom;
#endif
	if within Annexe
	   VertPos : Top = Previous Titre_annexe . Bottom + 1.5;
	IN Table_des_matieres
	   Visibility: 0;
#ifdef PAGE
	IN Vue_infos
	   Visibility: 0;
#endif
	END;

   Partie_finale:
	BEGIN
	Width : Enclosing . Width;
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Previous . Bottom + 30 pt;
	IN Table_des_matieres
	   VertPos: Top = Previous . Bottom;
#ifdef PAGE
	IN Vue_infos
	   VertPos: Top = Previous . Bottom;
#endif
	END;

   Sections_finales:
	BEGIN
	Width: Enclosing . Width;
	Indent: 1;
	VertPos: Top = Previous . Bottom + 30 pt;
	IN Table_des_matieres
	   BEGIN
	   VertPos: Top = Previous . Bottom + 0.2;
	   HorizPos: Left = Enclosing . Left;
	   END;
#ifndef PAGE
	IN Vue_biblio
	   Visibility: 0;
#else
	IN Vue_infos
	   Visibility: 0;
#endif
	END;

   Bibliographie:
	BEGIN
	CreateFirst(BoiteBiblio);
#ifdef PAGE
	CreateAfter(NumPageSect);
#endif
	Width: Enclosing . Width;
	VertPos: Top = Previous . Bottom + 30 pt;
	HorizPos: Left = Enclosing . Left;
	Indent: 0;
	IN Table_des_matieres
	   BEGIN
	   VertPos: Top = Previous . Bottom + 0.3;
#ifdef PAGE
	   Adjust: LeftWithDots;
	   Width: Right = Enclosing . Right - 28 pt;
	   Line;
#else
	   Adjust: Left;
	   Width:Enclosing . Width;
#endif
	   Size : Enclosing =;
	   Style: Bold;
	   END;
#ifdef PAGE
	IN Vue_infos
	   Visibility: 0;
#endif
	END;

   Citation_biblio:
	BEGIN
#ifdef REFBIBCLE
	Width: Enclosing . Width;
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Previous . Bottom + 0.6;
#else
	CreateBefore (NumeroBiblio);
	Width: Enclosing . Width - 2;
	HorizPos: Left = Enclosing . Left + 2;
	VertPos: HRef = Previous . HRef;
#endif
	PageBreak: No;
	IN Table_des_matieres
	   Visibility: 0;
	END;

   Annexes:
	BEGIN
	Width: Enclosing . Width;
	VertPos: Top = Previous . Bottom + 30 pt;
	Indent: 1;
	IN Table_des_matieres
	   BEGIN
	   Visibility: 8;
	   VertPos: Top = Previous . Bottom;
	   END;
#ifndef PAGE
	IN Vue_biblio
	   Visibility: 0;
#endif
	END;

   Unit\351 :
	BEGIN
	HorizPos : Left = Previous . Right;
	VertPos : HRef = Previous . HRef;
	END;

   Ref_affiliation :
	BEGIN
        Copy (NumeroAffiliation);
	Size : Enclosing - 3;
	HorizRef: * . Bottom + 0.3;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	END;

   Heading:
	BEGIN
	Width: Enclosing . Width;
#ifdef COUVERTURE
	VertPos: Top = Affiliations . Bottom;
	Page(PageCorps);
#else
	VertPos : Top = Previous . Bottom + 0.6 cm;
#endif
#ifdef PAGE
	IN Vue_infos
	   Visibility: 0;
#endif
	END;

   Title:
	BEGIN
#ifdef COUVERTURE
	Size : Enclosing + 7;
	Width: Enclosing . Width * 75 %;
	VertPos: Top = Enclosing . Top + 3.5 cm;
	HorizPos: VMiddle = Enclosing . VMiddle;
	Adjust: VMiddle;
#else
        Width: Enclosing . Width LARGEUR_ENTETE;
        CreateFirst(BoiteTitle);
#ifdef PAGE
	VertPos: Top = Enclosing . Top;
#else
	VertPos: Top = Previous . Bottom + 1;
#endif
	HorizPos: Right = Enclosing . Right;
#endif	COUVERTURE
	Line;
	Indent: 0;
	Justify: No;
	Hyphenate: No;
	IN Table_des_matieres
	   Visibility: 0;
	END;

   Abstract:
	BEGIN
#ifdef COUVERTURE
	CreateFirst(BoiteAbstract);
	Width: Enclosing . Width;
	HorizPos: Left = Enclosing . Left;
#else
	CreateBefore(BoiteAbstract);
	Width: Enclosing . Width LARGEUR_ENTETE;
	HorizPos: Right = Enclosing . Right;
#endif
        VertPos: Top = Previous . Bottom + 0.3;
	Indent: 0;
	Hyphenate: Yes;
	IN Table_des_matieres
	   Visibility: 0;
	END;

   Keywords :
	BEGIN
	CreateFirst(BoiteKeywords);
#ifdef COUVERTURE
	Width: Enclosing . Width;
	HorizPos: Left = Enclosing . Left;
#else
	Width : Enclosing . Width LARGEUR_ENTETE;
	HorizPos: Right = Enclosing . Right;
#endif
	VertPos : Top = Previous . Bottom + 0.3;
	Indent: -3;
	Line;
	Justify: No;
	IN Table_des_matieres
	   Visibility: 0;
	END;

   Annexe:
	BEGIN
	Width: Enclosing . Width;
	VertPos: Top = Previous . Bottom + 30 pt;
#ifdef COUVERTURE
	Page(PageAnnexe);
#endif
	IN Table_des_matieres
	   BEGIN
	   Visibility: 8;
	   VertPos: Top = Previous . Bottom;
	   END;
#ifdef PAGE
	IN Vue_infos
	   VertPos: Top = Previous . Bottom;
#endif
	END;

   Titre_annexe:
	BEGIN
	CreateBefore(NumeroAnnexe);
	HorizPos: Left = Previous NumeroAnnexe . Right + 0.6;
	Width: Right = Enclosing . Right;
#ifdef PAGE
	VertPos: Top = Previous AnyElem . Bottom;
#else
	VertPos: Top = Enclosing . Top;
#endif
	Size : Enclosing + 5;
	Style: Roman;
	PageBreak: No;
	Adjust: Left;
	Justify: No;
	Hyphenate: No;
	Indent: 0;
	Line;
	IN Table_des_matieres
	   BEGIN
	   Width: Enclosing . Width - 6;
	   VertPos: Top = Enclosing . Top + 0.3;
	   Size : Enclosing =;
	   Style: Bold;
	   END;
#ifdef PAGE
	IN Vue_infos
	   BEGIN
	   Size : Enclosing =;
	   VertPos: Top = Enclosing . Top + 0.3;
	   END;
#endif
	END;

   Titre_courant_annexe:
	BEGIN
	CreateFirst(BoiteTitreCourant);
	Width: Enclosing . Width;
	HorizPos: Left = Enclosing . Left;
	VertPos : Top = Previous . Bottom;
	Indent: -3;
	Line;
	Justify: No;
	Hyphenate: No;
#ifdef PAGE
	Visibility: 0;
	IN Vue_infos
	   BEGIN
	   Visibility: Enclosing =;
	   Width: Enclosing . Width - 3;
	   HorizPos: Left = Enclosing . Left + 3;
	   END;
#endif
	IN Table_des_matieres
	   Visibility: 0;
	END;

   Suite_sections:
	BEGIN
	Width: Enclosing . Width;
	HorizPos: Left = Enclosing . Left;
	Indent: 1;
	If NOT within Section
	   VertPos: Top = Previous . Bottom + 30 pt;
	If within 1 Section
	   VertPos: Top = Previous . Bottom + 24 pt;
	If within 2 Section
	   VertPos: Top = Previous . Bottom + 18 pt;
	If within 3 Section
	   VertPos: Top = Previous . Bottom + 12 pt;
	If within >3 Section
	   VertPos: Top = Previous . Bottom + 6 pt;
	IN Table_des_matieres
	   BEGIN
	   VertPos: Top = Previous . Bottom + 0.2;
	   END;
#ifdef PAGE
	IN Vue_infos
	   Visibility: 0;
#endif
	END;

   Section:
	BEGIN
	Width: Enclosing . Width;
	NoBreak1: 4.5;
	If within 0 Section
	   VertPos: Top = Previous Section . Bottom + 30 pt;
	If within 1 Section
	   VertPos: Top = Previous Section . Bottom + 24 pt;
	If within 2 Section
	   VertPos: Top = Previous Section . Bottom + 18 pt;
	If within 3 Section
	   VertPos: Top = Previous Section . Bottom + 12 pt;
	If within >3 Section
	   VertPos: Top = Previous Section . Bottom + 6 pt;
	IN Table_des_matieres
	   BEGIN
	   Visibility: 8;
	   VertPos: Top = Previous . Bottom;
	   IF within Section
	      BEGIN
	      Width: Enclosing . Width - 20 pt;
	      HorizPos: Left = Enclosing . Left + 20 pt;
	      END;
	   END;
	END;

   Titre_section:
	BEGIN
#ifdef PAGE
	CreateAfter(NumPageSect);
#endif
	Line;
	Justify: No;
	Indent: 0;
	if within Sections_finales
	   BEGIN
	   HorizPos: Left = Enclosing . Left;
	   Width: Enclosing . Width;
	   VertPos: Top = Enclosing . Top;
	   Size : Enclosing + 5;
	   Style: Roman;
	   END;
	if within 1 Section and not within Sections_finales and not within Annexe
	   BEGIN
	   CreateBefore(NumeroSect1);
	   HorizPos: Left = Previous NumeroSect1 . Right + 0.6;
	   Width: Right = Enclosing . Right;
	   VertPos: Top = Enclosing . Top;
	   Size : Enclosing + 5;
	   Style: Roman;
	   END;
	if within 1 Section and not within Sections_finales and within Annexe
	   BEGIN
	   CreateBefore(NumeroSect1Annexe);
	   HorizPos: Left = Previous NumeroSect1Annexe . Right + 0.6;
	   Width: Right = Enclosing . Right;
	   VertPos: Top = Enclosing . Top;
	   Size : Enclosing + 5;
	   Style: Roman;
	   END;
	if within 2 Section and not within Annexe
	   BEGIN
	   CreateBefore(NumeroSect2);
	   HorizPos: Left = Previous NumeroSect2 . Right + 0.6;
	   Width: Right = Enclosing . Right;
{	   VertPos: Top = Enclosing . Top; BUG IRENE }
	   VertPos: Href = Previous NumeroSect2 . HRef;
	   Size : Enclosing + 3;
	   Style: Roman;
	   END;
	if within 2 Section and within Annexe
	   BEGIN
	   CreateBefore(NumeroSect2Annexe);
	   HorizPos: Left = Previous NumeroSect2Annexe . Right + 0.6;
	   Width: Right = Enclosing . Right;
{	   VertPos: Top = Enclosing . Top; BUG IRENE }
	   VertPos: Href = Previous NumeroSect2Annexe . HRef;
	   Size : Enclosing + 3;
	   Style: Roman;
	   END;
	if within 3 Section and not within Annexe
	   BEGIN
	   CreateBefore(NumeroSect3);	
	   HorizPos: Left = Previous NumeroSect3 . Right + 0.6;
	   Width: Right = Enclosing . Right;
{	   VertPos: Top = Enclosing . Top; BUG IRENE }
	   VertPos: Href = Previous NumeroSect3 . HRef;
	   Size : Enclosing + 1;
	   Style: Roman;
	   END;
	if within 3 Section and within Annexe
	   BEGIN
	   CreateBefore(NumeroSect3Annexe);	
	   HorizPos: Left = Previous NumeroSect3Annexe . Right + 0.6;
	   Width: Right = Enclosing . Right;
{	   VertPos: Top = Enclosing . Top; BUG IRENE }
	   VertPos: Href = Previous NumeroSect3Annexe . HRef;
	   Size : Enclosing + 1;
	   Style: Roman;
	   END;
	if within 4 Section and not within Annexe
	   BEGIN
	   CreateBefore(NumeroSect4);	
	   HorizPos: Left = Previous NumeroSect4 . Right + 0.6;
	   Width: Right = Enclosing . Right;
{	   VertPos: Top = Enclosing . Top; BUG IRENE }
	   VertPos: Href = Previous NumeroSect4 . HRef;
	   Size : Enclosing =;
	   Style: Roman;
	   END;
	if within 4 Section and within Annexe
	   BEGIN
	   CreateBefore(NumeroSect4Annexe);	
	   HorizPos: Left = Previous NumeroSect4Annexe . Right + 0.6;
	   Width: Right = Enclosing . Right;
{	   VertPos: Top = Enclosing . Top; BUG IRENE }
	   VertPos: Href = Previous NumeroSect4Annexe . HRef;
	   Size : Enclosing =;
	   Style: Roman;
	   END;
	otherwise
	   BEGIN
	   HorizPos: Left = Enclosing . Left;
	   Width: Enclosing . Width;
	   VertPos: Top = Enclosing . Top;
	   Size : Enclosing =;
	   Style : Italics;
	   END;
	IN Table_des_matieres
	   BEGIN
	   Line;
#ifdef PAGE
	   Adjust: LeftWithDots;
	   Width: Right = Enclosing . Right - 28 pt;
#else
	   Adjust: Left;
	   Width: Right = Enclosing . Right;
#endif
	   Size : Enclosing =;
	   if within 1 Section
	      BEGIN
	      VertPos: Top = Enclosing . Top + 0.3;
	      Style: Bold;
	      END;
	   otherwise
	      BEGIN
{	      VertPos: Top = Enclosing . Top + 0.2;BUG IRENE }
	      VertPos: Top = Enclosing . Top ;
	      Style: Roman;
	      END;
	   END;
	END;

   Suite_paragraphes:
	BEGIN
	Width: Enclosing . Width;
	VertPos: Top = Previous . Bottom + 0.4;
	Hyphenate: Yes;
	IN Table_des_matieres
	   Visibility: 0;
	END;

   Groupe_titr\351:
	BEGIN
	Width : Enclosing . Width;
	VertPos: Top = Previous . Bottom + 0.5;
	END;

   Titre_groupe:
	BEGIN
	Width : Enclosing . Width;
	Line;
	Hyphenate: No;
	Indent: 0;
	Style: Bold;
	END;

   Groupe:
	BEGIN
	VertPos: Top = Previous . Bottom + Paragraph_Skip;
	Width: Enclosing . Width - RETRAIT_GROUPE;
	HorizPos: Left = Enclosing . Left + RETRAIT_GROUPE;
	Indent: 0;
	END;

{***Paragraphe:
	BEGIN
	Width: Enclosing . Width;
	NoBreak1: 2;
	NoBreak2: 2;
	VertPos: Top = Previous . Bottom + Paragraph_Skip;
	END;***}

   Image:
	BEGIN
	VertPos: Top = Previous . Bottom + Paragraph_Skip;
	HorizPos: VMiddle = Enclosing . VMiddle;
	PageBreak: No;
	Gather: Yes;
	END;

   Formule_num\351rot\351e:
	BEGIN
	CreateBefore (NumeroFormule);
	Width: Enclosing . Width - 2;
	HorizPos: VMiddle = Enclosing . VMiddle;
	VertPos: Top = Previous NOT NumeroFormule . Bottom + Paragraph_Skip;
	PageBreak: No;
	Gather: Yes;
	END;

   Autre_nature:
	BEGIN
	VertPos: Top = Previous . Bottom + Paragraph_Skip;
	HorizPos: VMiddle = Enclosing . VMiddle;
	PageBreak: No;
	Gather: Yes;
	END;

   Figure:
	BEGIN
	Width: Enclosing . Width;
	VertPos: Top = Previous . Bottom + 1.5;
	Indent: 0;
	PageBreak: No;
	LineSpacing: 1.1;
	Gather: Yes;
	END;

   Illustration:
	BEGIN
	Width: Enclosing . Width;
	VertPos: Top = Enclosing . Top;
	END;

   Image\240:
	BEGIN
	VertPos: Top = Enclosing . Top;
	HorizPos: VMiddle = Enclosing . VMiddle;
	END;

   Autre_figure:
	BEGIN
	VertPos: Top = Enclosing . Top;
	HorizPos: VMiddle = Enclosing . VMiddle;
	END;
   
   L\351gende_figure:
	BEGIN
	Style: Italics;
	Width: Enclosing . Width;
	VertPos: Top = Illustration . Bottom + 0.5;
	CreateFirst(BoiteFigure);
	CreateFirst(NumeroFigure);
	CreateFirst(DeuxPoints);
	Line;
	Adjust: VMiddle;
	Justify: No;
	END;

#ifndef PAGE
   Notes:
	BEGIN
	Width: Enclosing . Width - 2;
	HorizPos: Left = Enclosing . Left + 1;
	Font: helvetica;
	Size : Enclosing - 1;
	Hyphenate : No;
	END;
#endif

#ifdef PAGEV4
   Notes: { CP }
        BEGIN
        CreateFirst REPEATED (FiletNote);
        VertPos: Top = Enclosing . Top;
        HorizPos: Left = Enclosing . Left;
        Height: Enclosed . Height;
        Width: Enclosing . Width;
        Size : 11 pt;
        END;
#endif PAGEV4

   Note:
	BEGIN
	CreateBefore (NumeroNote);
#ifdef PAGE
	Font: times;
	Size : Enclosing - 2;
	Hyphenate: Yes;
#endif
	Indent: 0;
	Width: Enclosing . Width - 1.8;
	VertPos: HRef = Previous NumeroNote . HRef;
	HorizPos: Left = NumeroNote . Right;
	END;

   Indice :
	BEGIN
	PageBreak: No;
	LineBreak: No;
	HorizPos : Left = Previous . Right;
	VertPos : HRef = Previous . HRef;
	HorizRef : Enclosed . HRef - 0.3;
	Size : Enclosing - 2 min 6;
	END;

   Exposant :
	BEGIN
	PageBreak: No;
	LineBreak: No;
	HorizPos : Left = Previous . Right;
	VertPos : HRef = Previous . HRef;
	HorizRef : Enclosed . HRef + 0.4;
	Size : Enclosing - 2 min 6;
	END;

   Ref_note:
	BEGIN
	Copy (NumeroNote);
	Size : Enclosing - 3;
	HorizRef: * . Bottom + 0.3;
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	IN Table_des_matieres
	   Visibility: 0;
	END;

   Ref_biblio:
	BEGIN
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
#ifdef REFBIBCLE
	CreateBefore(CrochetOuvr);
	Copy(Ident(RefBib));
	CreateAfter(CrochetFerm);
#else
	Copy (NumeroBiblio);
#endif
	END;

   Ref_figure:
	BEGIN
	Copy (NumeroFigure);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	LineBreak: No;    { Ref_figure n est plus secable }
	IN Table_des_matieres
	   Visibility: 0;
	END;

   Ref_formule:
	BEGIN
	Copy (NumeroFormule);
	HorizPos: Left = Previous . Right;
	END;

   Ref_section:
	BEGIN
        IF target within 0 Section and not target within Annexe
	   and not within Sections_finales
           Copy (NumeroSect1);
        IF target within 0 Section and target within Annexe
           Copy (NumeroSect1Annexe);
        IF target within 1 Section and not target within Annexe
	   and not within Sections_finales
           Copy (NumeroSect2);
        IF target within 1 Section and target within Annexe
           Copy (NumeroSect2Annexe);
        IF target within 2 Section and not target within Annexe
	   and not within Sections_finales
           Copy (NumeroSect3);
        IF target within 2 Section and target within Annexe
           Copy (NumeroSect3Annexe);
        IF target within >2 Section and not target within Annexe
	   and not within Sections_finales
           Copy (NumeroSect4);
        IF target within >2 Section and target within Annexe
           Copy (NumeroSect4Annexe);
	IF target within Sections_finales
	   Copy (Titre_section);
	HorizPos: Left = Previous . Right;
	VertPos: HRef = Previous . HRef;
	END;

   Ref_annexe:
	BEGIN
	Copy (NumeroAnnexe);
	HorizPos: Left = Previous . Right;
	END;

   Ref_groupe_titr\351:
	BEGIN
	Copy (Titre_groupe);
	HorizPos : Left = Previous . Right;
	VertPos : HRef = Previous . HRef;
	END;

   Autre :
	BEGIN
	HorizPos : Left = Previous . Right;
	VertPos : HRef = Previous . HRef;
	END;

   GRAPHICS_UNIT:
	BEGIN
	Height: 1 cm;
	Width:  1.5 cm;
	VertPos: Top = Enclosing . Top;
	HorizPos: VMiddle = Enclosing . VMiddle;
	END;

   PAGE_BREAK:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	HorizOverflow : Yes;
	IN Table_des_matieres
	   Visibility: 5;
	END;

ATTRIBUTES

   Importance = D\351finition:
	Style: Italics;
   Importance = Important:
	Style: Bold;
#ifndef PAGE
   Type_auteur = Auteur_principal:
	Style: Bold;
#endif

END
