// -*- C++ -*-
/* ======================================================================= *\
    File   : keybind.h, $Id: keybind.h,v 1.13 1996/07/31 00:47:28 larsbj Exp $
    Author : chb, 2.Nov.1995
    Docu   : To add a new function:
             - add a new enum constant immediately before LFUN_LASTACTION
             - add an appropriate line to lyx_func_table
             - add a branch to the switch in WorkAreaKeyPress
    Purpose: definitions for LyX keysequences
\* ======================================================================= */

#ifndef _KEYBIND_H_
#define _KEYBIND_H_

#include "config.h"
#include "kbmap.h"
#include "forms.h"
/* --- external variables ------------------------------------------------ */

extern kb_keymap *toplevel_keymap;

/* --- LyX Edit Actions -------------------------------------------------- */

enum kb_action {
   LFUN_NOACTION = 0,
   LFUN_PREFIX,
   LFUN_PREFIXARG, /* not used now */
   LFUN_CENTER,
   LFUN_MENUNEW,
   LFUN_MENUOPEN,
   LFUN_MENUWRITE,
   LFUN_MENUWRITEAS,
   LFUN_MENUPRINT,
   LFUN_RUNLATEX,
   LFUN_TOCUPDATE, // 10
   LFUN_PREVIEW,
   LFUN_PREVIEWPS,
   LFUN_CLOSEBUFFER,
   LFUN_QUIT,
   LFUN_AUTOSAVE,
   LFUN_MENULOADAUTO,
   LFUN_UNDO,
   LFUN_REDO,
   LFUN_MENUSEARCH,
   LFUN_PASTE,
   LFUN_CUT,
   LFUN_COPY, // 20
   LFUN_GOTOERROR,
   LFUN_GOTONOTE,
   LFUN_OPENSTUFF,
   LFUN_HYPHENATION,
   LFUN_HFILL,
   LFUN_DEPTH,
   LFUN_FREE,
   LFUN_TEX,
   LFUN_FORMULA,
   LFUN_FOOTMELT, // 30
   LFUN_MARGINMELT,
   LFUN_PREVBUFFER,
   LFUN_EMPH,
   LFUN_BOLD,
   LFUN_ROMAN,
   LFUN_NOUN,
   LFUN_RIGHT,
   LFUN_LEFT,
   LFUN_UP,
   LFUN_DOWN,
   LFUN_PRIOR, // 40
   LFUN_NEXT,
   LFUN_HOME,
   LFUN_END,
   LFUN_TAB,
   LFUN_WORDRIGHT,
   LFUN_WORDLEFT,
   LFUN_BEGINNINGBUF,
   LFUN_ENDBUF,
   LFUN_RIGHTSEL,
   LFUN_LEFTSEL, // 50
   LFUN_UPSEL,
   LFUN_DOWNSEL,
   LFUN_PRIORSEL,
   LFUN_NEXTSEL,
   LFUN_HOMESEL,
   LFUN_ENDSEL,
   LFUN_WORDRIGHTSEL,
   LFUN_WORDLEFTSEL,
   LFUN_BEGINNINGBUFSEL,
   LFUN_ENDBUFSEL, // 60
   LFUN_PROTECTEDNEWLINE,
   LFUN_PROTECTEDSPACE,
   LFUN_SETMARK,
   LFUN_DELETE,
   LFUN_BACKSPACE,
   LFUN_NEWLINE,
   LFUN_QUOTE,
   LFUN_CIRCUMFLEX,
   LFUN_GRAVE,
   LFUN_ACUTE, // 70 
   LFUN_TILDE,
   LFUN_CEDILLA,
   LFUN_MACRON,
   LFUN_UNDERBAR,
   LFUN_UNDERDOT,
   LFUN_CIRCLE,
   LFUN_TIE,
   LFUN_BREVE,
   LFUN_CARON,
   LFUN_SPECIAL_CARON, // 80
   LFUN_HUNG_UMLAUT,
   LFUN_UMLAUT,
   LFUN_DOT,
   LFUN_VECTOR,        //  Alejandro 040696
   LFUN_SELFINSERT,
   LFUN_GETBUFNAME,
   LFUN_GETXY,
   LFUN_SETXY,
   LFUN_CHARATCURSOR,
   LFUN_LINEATCURSOR,
   LFUN_GETLAYOUT, // 90
   LFUN_GETFONT,
   LFUN_GETLATEX,
   LFUN_GETNAME,
   LFUN_NOTIFY,
   LFUN_INSERT_INSET_LATEX,
   LFUN_INSERT_INSET_LATEX_DEL,
   LFUN_INSERT_INSET_FORMULA_LATEX,
   LFUN_INSERT_INSET_FORMULA_LATEX_DEL,
   LFUN_INSERT_NOTE,
   LFUN_KMAP_OFF, // 100
   LFUN_KMAP_PRIM,
   LFUN_KMAP_SEC,
   LFUN_KMAP_TOGGLE,
   LFUN_INSERT_MATH,
   LFUN_INSERT_MATRIX,
   LFUN_GREEK,
   LFUN_MATH_LIMITS,  
   LFUN_GREEK_TOGGLE,
   LFUN_MATH_DELIM,    //  Alejandro 180696
   LFUN_MATH_DISPLAY,  // was INSERT_EQUATION  Alejandro 180696
   LFUN_MATH_MODE,     //  Alejandro 040696
   LFUN_MATH_NUMBER,   //  Alejandro 040696
   LFUN_MATH_NONUMBER,   //  Alejandro 180696
   LFUN_FIGURE,
   LFUN_TABLE,
   LFUN_MELT,  // 110
   LFUN_DELETE_WORD_FORWARD,
   LFUN_DELETE_WORD_BACKWARD,
   LFUN_DELETE_LINE_FORWARD,
   LFUN_MARK_OFF,
   LFUN_MARK_ON,
   LFUN_LAYOUT,
   LFUN_LAYOUT_CHARACTER,
   LFUN_LAYOUT_PARAGRAPH,
   LFUN_LAYOUT_DOCUMENT,
   LFUN_LAYOUT_QUOTES,
   LFUN_LAYOUT_PREAMBLE,
   LFUN_DROP_LAYOUTS_CHOICE,
   LFUN_CODE,
   LFUN_SANS,
   LFUN_DEFAULT,
   LFUN_UNDERLINE, // 120
   LFUN_FONT_SIZE,
   LFUN_FONT_STATE,
   LFUN_UPCASE_WORD,
   LFUN_LOWCASE_WORD,
   LFUN_CAPITALIZE_WORD,
   LFUN_INSERT_LABEL,
   LFUN_INSERT_REF,
   LFUN_PUSH_TOOLBAR, // 128
   LFUN_ADD_TO_TOOLBAR,
   LFUN_DEPTH_MIN,                      // RVDK_PATCH_5
   LFUN_DEPTH_PLUS,                     // RVDK_PATCH_5
   LFUN_MENU_OPEN_BY_NAME,              // RVDK_PATCH_5
   LFUN_SPELLCHECK,                     // RVDK_PATCH_5
   LFUN_CANCEL,                         // RVDK_PATCH_5
   LFUN_META_FAKE,                      // RVDK_PATCH_5
   LFUN_EXEC_COMMAND,
   LFUN_LASTACTION  /* this marks the end of the table */
};

/* --- prototypes -------------------------------------------------------- */

// Returns kb_action. Include arguments in func_name ONLY if you
// want to create new pseudo actions.
int LookupLyxFunc(const char *func_name); 

// Returns a pseudo-action given an action and its argument
int get_pseudo_action(kb_action action, const char *arg);

// Retrieves the real action and its argument, or -1
int retrieve_action_arg(int i, char** arg);

// Search for an existent pseudoaction, returns -1 if it doesn't exist.
int search_action_arg(kb_action action, const char *arg);
					  
char *DispatchFunction(int action,
		       const char *argument,
		       FL_OBJECT *ob=NULL);

int WorkAreaKeyPress(FL_OBJECT *ob, Window win, int w, int h,
		     XEvent *ev, void *d);

inline
bool IsPseudoAction(int a) {
	return (a >= (int)LFUN_LASTACTION);
}

#endif /* _KEYBIND_H_ */

/* === End of File: keybind.h ============================================ */
