// Part of the Lyx Project
// 1996

#include "config.h"

#include <ctype.h>

#include "definitions.h"
#include "symgen.h"
#include "lyxlex.h"

extern FILE *myfile;
extern char token_end_character;
extern char* stringtoken;

	
/*
 * Very simple pseudo-lexical analizer to simplify def files parsing.
 * A real lexical analizer should return basic information about the
 * token (is a number, a word).
 * lyx7p4-d6 Nov 15, 95 Alejandro Aguilar Sierra
 */ 
char *next_token(FILE *file)
{
	char c;
	static char buf[200];
	int i;
   
	while (!feof(file)) { 
		c = getc(file);
		if (c=='#')
			do c = getc(file); while (c!='\n');
		if (c==',')
			continue;              /* Skip ','s */
		if (c > ' ' && !feof(file))  {
			i = 0;
			do {
				buf[i++] = c;
				c = getc(file);
			} while (c > ' ' && c != ',' && !feof(file));
			buf[i] = '\0';
			return &buf[0];
		}
	}
   
	return NULL;
}


/* Same as above but stops on end of line */
/* lyx7p4-d6 Nov 15, 95 Alejandro Aguilar Sierra */
char *next_token_line(FILE *file)
{
	char c;
	static char buf[200];
	int i;
   
	while (!feof(file)) { 
		c = getc(file);
		if (c=='#')
			return NULL;
      
		if (c=='\n')
			return NULL;
      
		if (c==',')
			continue;              /* Skip ','s */

		if (c > ' ' && !feof(file))  {
			i = 0;
			do {
				buf[i++] = c;
				c = getc(file);
			} while (c > ' ' && c != ',' && !feof(file));
			buf[i] = '\0';
			ungetc(c, file);    /* This character could be a '\n' */
			return &buf[0];
	 
		}
	}
   
	return NULL;
}


void readline(FILE *file, char* s)
{
   int i=0;
   do  {
      s[i] = fgetc(file);
      i++;
   } while (!feof(file) && s[i-1]!='\n');
   s[i] = '\0';
}


// the 6 next are included form file.C
char* NextToken()
{
   char* token = NULL;
   char c = 0;
   int i = 0;
   
   if (!feof(myfile)) {
      token = new char[100];
      do {
	 c = fgetc(myfile);
	 token[i]=c;
	 i++;
      } while (!feof(myfile) && !isspace(c) && c!='\n');
      
      token[i-1]='\0';	       /* just the end of a command  */
   }
   token_end_character = c;
   return token;
}


char* NextLongToken()
{
     char* token = NULL;
   char c;
   int i = 0;
   
   if (!feof(myfile)) {
      token = new char[100];
      do {
	 c = fgetc(myfile);
	 token[i]=c;
	 i++;
      } while (!feof(myfile) && c!='\n');
      token[i-1]='\0';
   }
   return token;
}


int NextQStringToken(char *input, char *buf)
{
   char qc;
   int i = 0;

   *buf = '\0';
   while(input[i] && input[i]<=' ') i++;
   qc = input[i++];
   if(!qc) return 0;
   while(input[i])
   {
      if(input[i]==qc)
      {
         *buf='\0';
         return i+1;
      }
      *buf++ = input[i++];
   }
   //!!!should complain about missing quote
   *buf = '\0';
   return i;
}


int FindStringToken(LyXLexClass *lex, char* command, const char* string[])
{
	int i = 0;

	if (lex->next()) {
		stringtoken = lex->GetString();
		
		if (lyx_debug_level & DEBUG_LEX_PARSER)
			fprintf(stderr,"NextStringToken: stringtoken: `%s'\n",
				stringtoken);
		
		if (StringEqual(stringtoken, "default"))
			i = LYX_LAYOUT_DEFAULT;
		else {
			for (i=0; string[i][0] && !StringEqual(string[i], stringtoken);i++);
			if (!string[i][0]) {
				fprintf(stderr,
					"LYX_ERROR: unknown argument %s for %s\n", stringtoken, command);
				i = LYX_LAYOUT_DEFAULT;
			}
		}
	}
	else
		fprintf(stderr,
			"LYX_ERROR: file ended while scanning string token \n");
	
	return i;
}


int NextStringToken(char* command, const char* string[])
{
   char c;
   int i = 0;
   
   if (!feof(myfile)) {
      i = 0;
      do {
         c = fgetc(myfile);
         stringtoken[i]=c;
         i++;
      } while (!feof(myfile) && c!=' ' && c!='\n');
      stringtoken[i-1]='\0';
      
      if (StringEqual(stringtoken, "default"))
         i = LYX_LAYOUT_DEFAULT;
      else {
         for (i=0; string[i][0] && !StringEqual(string[i], stringtoken);i++);
         if (!string[i][0]) {
            fprintf(stderr, "LYX_ERROR: unknown argument %s for %s\n", stringtoken, command);
            i = LYX_LAYOUT_DEFAULT;
         }
      }
   }
   else
      fprintf(stderr, "LYX_ERROR: file ended while scanning string token \n");
   
   return i;
}


int NextIntToken()
{
   char c;
   int number = 0;
   
   if (!feof(myfile)) {
      fscanf(myfile, "%d", &number);
      if (!feof(myfile))
      	c=fgetc(myfile);
   }
   return number;
}


float NextFloatToken()
{
   char c;
   float number = 0;
   
   if (!feof(myfile)) {
      fscanf(myfile, "%f", &number);
      if (!feof(myfile))
      	c=fgetc(myfile);
   }
   
   return number;
}


// below comes the beginning of my parser. Lgb.
// all of these would be alot nicer if iostreams where used. Lgb

// CharacterStream methods
int CharacterStream::next(){
        int nextChar=EOF;
	// int xNextChar; // unused
        // CharacterStream is asked for a character.
        // Avoid sending ` ' after each other.

        //nextChar = progFile.get();
	if (progFile)
	nextChar = getc(progFile);
	
        if(nextChar=='\n')
                nextChar = ' ';
        
        if (nextChar != EOF) {
                if(nextChar == commentChar){
                        // This is start of comment
                        // read new line.
                        newLine(); nextChar = next();

                }
        
                // here skip all blanks
                //int ch = progFile.peek();
		int ch = getc(progFile);
		ungetc(ch,progFile);
		
                if (ch == commentChar) nextChar= next();
                while (isspace(nextChar) && (isspace(ch) || ch == '\n'))
                { // skip whitespace
                        //nextChar = progFile.get();
			nextChar = getc(progFile);
                        if (nextChar== '\n') nextChar=' ';
                        //ch = progFile.peek();
			ch = getc(progFile);
			ungetc(ch,progFile);
                }
                
        } else {
                nextChar = EOF;
        }

        return currentChar = nextChar;
}

void CharacterStream::newLine(){
        int c;

	do {
		//c = progFile.get();
		c = getc(progFile);
	} while(c != '\n' && c != EOF);

        lineNumber++;
}

//void CharacterStream::writeLine(ofstream Outfile){
void CharacterStream::writeLine(FILE */*outFile*/){
}

// SymbolGenerator methods
void SymbolGenerator::stepSymbol(void)
{
        while(isspace(charStream->Current()))
                charStream->stepChar();

#ifdef DEBUG
        if(isgraph(charStream->Current()))
                cout << "This character is graph: "
                     << (char)charStream->Current()
                             << endl;
#endif
        
        if (isgraph(charStream->Current())){
                thisSymbol = nextString();
        } else {
                thisSymbol = nextOperation();
        }
}

bool SymbolGenerator::currentIs(char* /*tx*/)
{
        return true;
}

int SymbolGenerator::lineNumber()
{
        return charStream->lineNumber;
}

char* SymbolGenerator::currentLine()
{
        return charStream->currentLine();
}

bool SymbolGenerator::currentIsInteger()
{
        return true;
}

int SymbolGenerator::currentAsInteger()
{
        return 1;
}

bool SymbolGenerator::currentIsName()
{
        return true;
}

bool SymbolGenerator::currentIsKeyword()
{
        return true;
}

bool SymbolGenerator::currentIsVariableName()
{
        return true;
}

void SymbolGenerator::errorInLine(char* /*tx*/)
{
}

bool SymbolGenerator::currentIsFloat()
{
        return true;
}

float SymbolGenerator::currentAsFloat()
{
        return (float)1;
}

void SymbolGenerator::reportError(char* /*tx*/)
{
}

char* SymbolGenerator::nextString()
{
        int i=0;
        char buf[256];
        while(i<255 && isgraph(charStream->Current())){
                buf[i++] = (char)charStream->Current();
                charStream->stepChar();
        }
        buf[i]='\0';
        return StringCopy(buf);
}

char* SymbolGenerator::nextConstant()
{
        return "Constant";
}

char* SymbolGenerator::nextOperation()
{
        // this actually means that we have reached
        // end of file
        if(charStream->Current() == EOF)
                return "xXx_endoffile_xXx";
        else
                return "this I do not know what is";
}

