/* C code produced by gperf version 2.5 (GNU C++ version) */
/* Command-line: gperf -a -p -o -t -G -D g  */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "math_defs.h"
#include "math_parser.h"

//struct latexkeys { char* name; short token; int id; };

#define TOTAL_KEYWORDS 267
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 18
#define MIN_HASH_VALUE 8
#define MAX_HASH_VALUE 485
/* maximum key range = 478, duplicates = 39 */

static unsigned int
hash (register const char *str, register int len)
{
  static unsigned short asso_values[] =
    {
     486, 486, 486, 486, 486, 486, 486, 486, 486, 486,
     486, 486, 486, 486, 486, 486, 486, 486, 486, 486,
     486, 486, 486, 486, 486, 486, 486, 486, 486, 486,
     486, 486, 486, 486, 486, 486, 486, 486, 486, 486,
     486, 486, 486, 486, 486, 486, 486, 486, 486, 486,
     486, 486, 486, 486, 486, 486, 486, 486, 486, 486,
     486, 486, 486, 486, 486, 486, 486, 486,  20, 486,
     486,  15, 486,   0, 486, 486, 255, 486, 486,  45,
     145, 486,   0,  95, 140,  95,  15, 486,  10, 486,
     486, 486, 486, 486, 486, 486, 486,  50, 200, 140,
     120,  35, 135, 172, 230, 250,   0, 205,  10, 180,
     105,  91,  55, 157, 125,   0,  25, 185, 215,  75,
       5,  15,   0, 486, 486, 486, 486, 486,
    };
  return len + asso_values[str[len - 1]] + asso_values[str[0]];
}

static struct latexkeys wordlist[] =
{
      {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, 
      {"setminus",  LM_TK_SYM, LM_setminus},
      {"ldots",  LM_TK_DOTS, LM_ldots},
      {"limits",  LM_TK_LIMIT, 1},
      {"stackrel",  LM_TK_STACK},
      {"ll",  LM_TK_SYM, LM_ll},
      {"label",  LM_TK_LABEL},
      {"lceil",  LM_TK_SYM, LM_lceil},
      {"sqrt",  LM_TK_SQRT,},
      {"times",  LM_TK_SYM, LM_times},
      {"subset",  LM_TK_SYM, LM_subset},
      {"supset",  LM_TK_SYM, LM_supset},
      {"spadesuit",  LM_TK_SYM, LM_spadesuit},
      {"Re",  LM_TK_SYM, LM_Re},
      {"left",  LM_TK_LEFT,},
      {"smile",  LM_TK_SYM, LM_smile},
      {"exists",  LM_TK_SYM, LM_exists},
      {"Vert",  LM_TK_SYM, LM_Vert},
      {"scriptstyle",  LM_TK_STY, LM_TC_SCRIPT},
      {"ell",  LM_TK_SYM, LM_ell},
      {"langle",  LM_TK_SYM, LM_langle},
      {"scriptscriptstyle",  LM_TK_STY, LM_TC_SCRIPTSCRIPT},
      {"zeta",  LM_TK_SYM, LM_zeta},
      {"sigma",  LM_TK_SYM, LM_sigma},
      {"arccos",  LM_TK_FUNC},
      {"sup",  LM_TK_FUNCLIM},
      {"sharp",  LM_TK_SYM, LM_sharp},
      {"sqcup",  LM_TK_SYM, LM_sqcup},
      {"sqcap",  LM_TK_SYM, LM_sqcap},
      {"approx",  LM_TK_SYM, LM_approx},
      {"triangleleft",  LM_TK_SYM, LM_triangleleft},
      {"triangleright",  LM_TK_SYM, LM_triangleright},
      {"tilde",  LM_TK_ACCENT, LM_tilde},
      {"lambda",  LM_TK_SYM, LM_lambda},
      {"emptyset",  LM_TK_SYM, LM_emptyset},
      {"triangle",  LM_TK_SYM, LM_triangle},
      {"textstyle",  LM_TK_STY, LM_TC_TEXT},
      {"Gamma",  LM_TK_SYM, LM_Gamma},
      {"limsup",  LM_TK_FUNCLIM},
      {"partial",  LM_TK_SYM, LM_partial},
      {"parallel",  LM_TK_SYM, LM_parallel},
      {"Delta",  LM_TK_SYM, LM_Delta},
      {"leftharpoonup",  LM_TK_SYM, LM_leftharpoonup},
      {"theta",  LM_TK_SYM, LM_theta},
      {"searrow",  LM_TK_SYM, LM_searrow},
      {"swarrow",  LM_TK_SYM, LM_swarrow},
      {"top",  LM_TK_SYM, LM_top},
      {"Rightarrow",  LM_TK_SYM, LM_Rightarrow},
      {"eta",  LM_TK_SYM, LM_eta},
      {"acute",  LM_TK_ACCENT, LM_acute},
      {"angle",  LM_TK_SYM, LM_angle},
      {"exp",  LM_TK_FUNC},
      {"leftarrow",  LM_TK_SYM, LM_leftarrow},
      {"prime",  LM_TK_SYM, LM_prime},
      {"oplus",  LM_TK_SYM, LM_oplus},
      {"ominus",  LM_TK_SYM, LM_ominus},
      {"otimes",  LM_TK_SYM, LM_otimes},
      {"longleftarrow",  LM_TK_SYM, LM_longleftarrow},
      {"leftrightarrow",  LM_TK_SYM, LM_leftrightarrow},
      {"longrightarrow",  LM_TK_SYM, LM_longrightarrow},
      {"Omega",  LM_TK_SYM, LM_Omega},
      {"longleftrightarrow",  LM_TK_SYM, LM_longleftrightarrow},
      {"Downarrow",  LM_TK_SYM, LM_Downarrow},
      {"alpha",  LM_TK_SYM, LM_alpha},
      {"widehat",  LM_TK_WIDE, LM_widehat},
      {"sin",  LM_TK_FUNC},
      {"asymp",  LM_TK_SYM, LM_asymp},
      {"longmapsto",  LM_TK_SYM, LM_longmapsto},
      {"nolimits",  LM_TK_LIMIT, 0},
      {"perp",  LM_TK_SYM, LM_perp},
      {"wedge",  LM_TK_SYM, LM_wedge},
      {"ln",  LM_TK_FUNC},
      {"widetilde",  LM_TK_WIDE, LM_widetilde},
      {"odot",  LM_TK_SYM, LM_odot},
      {"oint",  LM_TK_BIGSYM, LM_oint},
      {"natural",  LM_TK_SYM, LM_natural},
      {"surd",  LM_TK_SYM, LM_surd},
      {"ddots",  LM_TK_DOTS, LM_ddots},
      {"star",  LM_TK_SYM, LM_star},
      {"leftharpoondown",  LM_TK_SYM, LM_leftharpoondown},
      {"wp",  LM_TK_SYM, LM_wp},
      {"tan",  LM_TK_FUNC},
      {"overline",  LM_TK_WIDE, LM_overline},
      {"overbrace",  LM_TK_WIDE, LM_overbrace},
      {"rceil",  LM_TK_SYM, LM_rceil},
      {"lfloor",  LM_TK_SYM, LM_lfloor},
      {"rightleftharpoons",  LM_TK_SYM, LM_rightleftharpoons},
      {"cos",  LM_TK_FUNC},
      {"sec",  LM_TK_FUNC},
      {"succ",  LM_TK_SYM, LM_succ},
      {"cdots",  LM_TK_DOTS, LM_cdots},
      {"omega",  LM_TK_SYM, LM_omega},
      {"epsilon",  LM_TK_SYM, LM_epsilon},
      {"det",  LM_TK_FUNCLIM},
      {"dot",  LM_TK_ACCENT, LM_dot},
      {"ddot",  LM_TK_ACCENT, LM_ddot},
      {"Sigma",  LM_TK_SYM, LM_Sigma},
      {"forall",  LM_TK_SYM, LM_forall},
      {"liminf",  LM_TK_FUNCLIM},
      {"propto",  LM_TK_SYM, LM_propto},
      {"right",  LM_TK_RIGHT,},
      {"diamondsuit",  LM_TK_SYM, LM_diamondsuit},
      {"end",  LM_TK_END,},
      {"nabla",  LM_TK_SYM, LM_nabla},
      {"arcsin",  LM_TK_FUNC},
      {"arctan",  LM_TK_FUNC},
      {"simeq",  LM_TK_SYM, LM_simeq},
      {"succeq",  LM_TK_SYM, LM_succeq},
      {"flat",  LM_TK_SYM, LM_flat},
      {"subseteq",  LM_TK_SYM, LM_subseteq},
      {"supseteq",  LM_TK_SYM, LM_supseteq},
      {"rangle",  LM_TK_SYM, LM_rangle},
      {"displaystyle",  LM_TK_STY, LM_TC_DISPLAY},
      {"sqsubseteq",  LM_TK_SYM, LM_sqsubseteq},
      {"sqsupseteq",  LM_TK_SYM, LM_sqsupseteq},
      {"cot",  LM_TK_FUNC},
      {"cdot",  LM_TK_SYM, LM_cdot},
      {"leq",  LM_TK_SYM, LM_leq},
      {"clubsuit",  LM_TK_SYM, LM_clubsuit},
      {"delta",  LM_TK_SYM, LM_delta},
      {"Uparrow",  LM_TK_SYM, LM_Uparrow},
      {"overleftarrow",  LM_TK_WIDE, LM_overleftarrow},
      {"pmod",  LM_TK_PMOD},
      {"prod",  LM_TK_BIGSYM, LM_prod},
      {"overrightarrow",  LM_TK_WIDE, LM_overightarrow},
      {"Updownarrow",  LM_TK_SYM, LM_Updownarrow},
      {"Im",  LM_TK_SYM, LM_Im},
      {"sim",  LM_TK_SYM, LM_sim},
      {"sum",  LM_TK_BIGSYM, LM_sum},
      {"lg",  LM_TK_FUNC},
      {"log",  LM_TK_FUNC},
      {"models",  LM_TK_SYM, LM_models},
      {"nearrow",  LM_TK_SYM, LM_nearrow},
      {"nwarrow",  LM_TK_SYM, LM_nwarrow},
      {"max",  LM_TK_FUNCLIM},
      {"uplus",  LM_TK_SYM, LM_uplus},
      {"lim",  LM_TK_FUNCLIM},
      {"rightharpoonup",  LM_TK_SYM, LM_rightharpoonup},
      {"Theta",  LM_TK_SYM, LM_Theta},
      {"mathcal",  LM_TK_FONT, LM_TC_CAL},
      {"cap",  LM_TK_SYM, LM_cap},
      {"cup",  LM_TK_SYM, LM_cup},
      {"prec",  LM_TK_SYM, LM_prec},
      {"mathnormal",  LM_TK_FONT, LM_TC_NORMAL},
      {"wr",  LM_TK_SYM, LM_wr},
      {"downarrow",  LM_TK_SYM, LM_downarrow},
      {"Upsilon",  LM_TK_SYM, LM_Upsilon},
      {"bigoplus",  LM_TK_BIGSYM, LM_oplus},
      {"biguplus",  LM_TK_BIGSYM, LM_biguplus},
      {"bigotimes",  LM_TK_BIGSYM, LM_otimes},
      {"rightarrow",  LM_TK_SYM, LM_rightarrow},
      {"mathit",  LM_TK_FONT, LM_TC_IT},
      {"textrm",  LM_TK_FONT, LM_TC_TEXTRM},
      {"mathtt",  LM_TK_FONT, LM_TC_TT},
      {"grave",  LM_TK_ACCENT, LM_grave},
      {"tau",  LM_TK_SYM, LM_tau},
      {"notin",  LM_TK_SYM, LM_notin},
      {"preceq",  LM_TK_SYM, LM_preceq},
      {"rho",  LM_TK_SYM, LM_rho},
      {"vdots",  LM_TK_DOTS, LM_vdots},
      {"arg",  LM_TK_FUNC},
      {"amalg",  LM_TK_SYM, LM_amalg},
      {"gamma",  LM_TK_SYM, LM_gamma},
      {"bot",  LM_TK_SYM, LM_bot},
      {"underline",  LM_TK_WIDE, LM_underline},
      {"underbrace",  LM_TK_WIDE, LM_underbrace},
      {"bullet",  LM_TK_SYM, LM_bullet},
      {"bigodot",  LM_TK_BIGSYM, LM_bigodot},
      {"sinh",  LM_TK_FUNC},
      {"jmath",  LM_TK_SYM, LM_jmath},
      {"mp",  LM_TK_SYM, LM_mp},
      {"pm",  LM_TK_SYM, LM_pm},
      {"nonumber",  LM_TK_NONUM,},
      {"breve",  LM_TK_ACCENT, LM_breve},
      {"bigvee",  LM_TK_BIGSYM, LM_vee},
      {"bowtie",  LM_TK_SYM, LM_bowtie},
      {"bigwedge",  LM_TK_BIGSYM, LM_wedge},
      {"frown",  LM_TK_SYM, LM_frown},
      {"rightharpoondown",  LM_TK_SYM, LM_rightharpoondown},
      {"diamond",  LM_TK_SYM, LM_diamond},
      {"dagger",  LM_TK_SYM, LM_dagger},
      {"ddagger",  LM_TK_SYM, LM_ddagger},
      {"vee",  LM_TK_SYM, LM_vee},
      {"beta",  LM_TK_SYM, LM_beta},
      {"equiv",  LM_TK_SYM, LM_equiv},
      {"rfloor",  LM_TK_SYM, LM_rfloor},
      {"xi",  LM_TK_SYM, LM_xi},
      {"hat",  LM_TK_ACCENT, LM_hat},
      {"tanh",  LM_TK_FUNC},
      {"kappa",  LM_TK_SYM, LM_kappa},
      {"bigcap",  LM_TK_BIGSYM, LM_cap},
      {"bigcup",  LM_TK_BIGSYM, LM_cup},
      {"Xi",  LM_TK_SYM, LM_Xi},
      {"bigsqcup",  LM_TK_BIGSYM, LM_bigsqcup},
      {"heartsuit",  LM_TK_SYM, LM_heartsuit},
      {"neq",  LM_TK_SYM, LM_neq},
      {"coprod",  LM_TK_BIGSYM, LM_coprod},
      {"uparrow",  LM_TK_SYM, LM_uparrow},
      {"bigtriangleup",  LM_TK_SYM, LM_bigtriangleup},
      {"infty",  LM_TK_SYM, LM_infty},
      {"updownarrow",  LM_TK_SYM, LM_updownarrow},
      {"Pr",  LM_TK_FUNCLIM},
      {"varsigma",  LM_TK_SYM, LM_varsigma},
      {"vartheta",  LM_TK_SYM, LM_vartheta},
      {"mapsto",  LM_TK_SYM, LM_mapsto},
      {"int",  LM_TK_BIGSYM, LM_int},
      {"frac",  LM_TK_FRAC,},
      {"neg",  LM_TK_SYM, LM_neg},
      {"quad",  LM_TK_SPACE, LM_quad},
      {"doteq",  LM_TK_SYM, LM_doteq},
      {"qquad",  LM_TK_SPACE, LM_qquad},
      {"csc",  LM_TK_FUNC},
      {"circ",  LM_TK_SYM, LM_circ},
      {"aleph",  LM_TK_SYM, LM_aleph},
      {"min",  LM_TK_FUNCLIM},
      {"nu",  LM_TK_SYM, LM_nu},
      {"deg",  LM_TK_FUNC},
      {"gcd",  LM_TK_FUNCLIM},
      {"upsilon",  LM_TK_SYM, LM_upsilon},
      {"dim",  LM_TK_FUNC},
      {"mid",  LM_TK_SYM, LM_mid},
      {"iota",  LM_TK_SYM, LM_iota},
      {"pi",  LM_TK_SYM, LM_pi},
      {"phi",  LM_TK_SYM, LM_phi},
      {"psi",  LM_TK_SYM, LM_psi},
      {"begin",  LM_TK_BEGIN,},
      {"Lambda",  LM_TK_SYM, LM_Lambda},
      {"cong",  LM_TK_SYM, LM_cong},
      {"hookleftarrow",  LM_TK_SYM, LM_hookleftarrow},
      {"hookrightarrow",  LM_TK_SYM, LM_hookrightarrow},
      {"bigtriangledown",  LM_TK_SYM, LM_bigtriangledown},
      {"mathbf",  LM_TK_FONT, LM_TC_BF},
      {"mathsf",  LM_TK_FONT, LM_TC_SF},
      {"bmod",  LM_TK_FUNC},
      {"oslash",  LM_TK_SYM, LM_oslash},
      {"bar",  LM_TK_ACCENT, LM_bar},
      {"varepsilon",  LM_TK_SYM, LM_varepsilon},
      {"geq",  LM_TK_SYM, LM_geq},
      {"ker",  LM_TK_FUNC},
      {"div",  LM_TK_SYM, LM_div},
      {"Leftarrow",  LM_TK_SYM, LM_Leftarrow},
      {"dashv",  LM_TK_SYM, LM_dashv},
      {"Longleftarrow",  LM_TK_SYM, LM_Longleftarrow},
      {"Leftrightarrow",  LM_TK_SYM, LM_Leftrightarrow},
      {"Longrightarrow",  LM_TK_SYM, LM_Longrightarrow},
      {"gg",  LM_TK_SYM, LM_gg},
      {"bigcirc",  LM_TK_SYM, LM_bigcirc},
      {"Longleftrightarrow",  LM_TK_SYM, LM_Longleftrightarrow},
      {"check",  LM_TK_ACCENT, LM_check},
      {"in",  LM_TK_SYM, LM_in},
      {"ni",  LM_TK_SYM, LM_ni},
      {"vec",  LM_TK_ACCENT, LM_vec},
      {"hbar",  LM_TK_SYM, LM_hbar},
      {"mathrm",  LM_TK_FONT, LM_TC_RM},
      {"mu",  LM_TK_SYM, LM_mu},
      {"cosh",  LM_TK_FUNC},
      {"coth",  LM_TK_FUNC},
      {"inf",  LM_TK_FUNCLIM},
      {"chi",  LM_TK_SYM, LM_chi},
      {"Pi",  LM_TK_SYM, LM_Pi},
      {"Phi",  LM_TK_SYM, LM_Phi},
      {"Psi",  LM_TK_SYM, LM_Psi},
      {"hom",  LM_TK_FUNC},
      {"backslash",  LM_TK_SYM, LM_backslash},
      {"vdash",  LM_TK_SYM, LM_vdash},
      {"varpi",  LM_TK_SYM, LM_varpi},
      {"varphi",  LM_TK_SYM, LM_varphi},
      {"imath",  LM_TK_SYM, LM_imath},
};

static short lookup[] =
{
        -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   8,  -1,  -1,  -1,  -1,  -1,
        -1,   9,  10,  -1,  11,  -1,  -1,  -1,  12,  -1,  -1, 486, -13,  -2,
        -1,  15,  16, 486, -17,  -2,  19,  -1,  -1,  20,  -1,  21,  22,  23,
        -1,  -1,  24,  -1,  25,  -1,  26,  -1,  -1,  27,  28,  -1,  29,  30,
        31,  -1,  32,  -1, 563,  36,  37,  38,  -1,  39,  40,  -1, 493,  43,
        44,  45,  46,  47,  -1,  48, -41,  -2,  49,  -1,  50,  -1, 489,  53,
        -1,  54, -51,  -2,  55,  -1, 486, -56,  -2,  58,  59,  60,  61, 524,
        64, 487,  67, -65,  -2,  68,  69,  70,  -1,  71,  72,  -1,  73,  74,
        -1,  75,  76,  77,  -1,  78,  -1,  79, 491,  -1,  82,  -1,  83,  84,
       -80,  -2,  -1,  85,  86,  -1,  87,  88,  89,  90, -62,  -2, -33,  -3,
        91,  92,  93, 683,  96,  97,  98,  99, 673, 102, 103, 487, 106,-104,
        -2, 107, 108,  -1, 109,  -1, 110, 658, 113, 114, 115, 645, 118, 489,
       122, 123, 124,-119,  -3, 125,  -1, 126,  -1, 127,  -1, 620, 131, 132,
       133, 525, 136, 137, 138, 489, 141,  -1, 142,-139,  -2, 143, 144, 145,
        -1, 146, 492, 149, 150,  -1, 151,  -1, 152,-147,  -2, 153, 498, 156,
       157, 490, 161, 162,  -1, 163,-158,  -3, 164, 165, 166,-154,  -2,-134,
        -2, 167,  -1, 558, 170, 171, 172, 173, 174,  -1, 175, 176,  -1, 541,
       179,  -1, 180, 492,  -1, 183,  -1, 184, 185, 186,-181,  -2,  -1, 187,
       188, 189, 190, 191, 192, 193, 194, 195, 196, 513, 199, 200, 201, 202,
       203, 204, 205,  -1, 206, 207, 208, 486,-209,  -2,  -1, 211, 212, 213,
       214, 215, 489, 218, 219, 220,-216,  -2, 221,-197,  -2,  -1, 222,-177,
        -2, 488,  -1, 225,-223,  -2,-168,  -2,  -1, 487, 228,-226,  -2, 229,
       489,  -1, 232, 233,-230,  -2,-128,  -3, 234,  -1, 235, 236, 237, 486,
      -238,  -2, 240,-116,  -2, 241, 242,  -1, 243,  -1, 244, 245,-111,  -2,
      -100,  -2, 246, 247, 248, -94,  -2, 249, 492,  -1, 252, 253, 254,  -1,
       255,-250,  -2,  -1,  -1,  -1,  -1, 488, 258, 259,-256,  -2,  -1,  -1,
        -1,  -1, 260, 261,  -1,  -1,  -1,  -1,  -1,  -1, 486,-262,  -2,  -1,
        -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, 264,  -1,  -1,  -1,
        -1, 265,  -1,  -1,  -1, 266, 486,-267,  -2,  -1,  -1,  -1,  -1,  -1,
        -1,  -1,  -1,  -1,  -1,  -1,  -1, 269,  -1,  -1,  -1,  -1,  -1,  -1,
        -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
        -1,  -1,  -1,  -1,  -1, 270,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
        -1,  -1, 271,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
        -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, 272, 273,  -1,  -1,  -1,  -1,
        -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, 274,
};

struct latexkeys *
in_word_set (register const char *str, register int len)
{
  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register int index = lookup[key];

          if (index >= 0 && index < MAX_HASH_VALUE)
            {
              register char *s = wordlist[index].name;

              if (*s == *str && !strcmp (str + 1, s + 1))
                return &wordlist[index];
            }
          else if (index < 0 && index >= -MAX_HASH_VALUE)
            return 0;
          else
            {
              register int offset = key + index + (index > 0 ? -MAX_HASH_VALUE : MAX_HASH_VALUE);
              register struct latexkeys *base = &wordlist[-lookup[offset]];
              register struct latexkeys *ptr = base + -lookup[offset + 1];

              while (--ptr >= base)
                if (*str == *ptr->name && !strcmp (str + 1, ptr->name + 1))
                  return ptr;
            }
        }
    }
  return 0;
}


latexkeys *lm_get_key_by_id(int t, short tk)
{
   latexkeys* l = &wordlist[MIN_HASH_VALUE+TOTAL_KEYWORDS];
   latexkeys* base = &wordlist[MIN_HASH_VALUE];
   while (--l >= base) {
     if (t==l->id && tk==l->token)
       return l;
   }
   return NULL;
}

latexkeys *lm_get_key_by_index(int i)
{
   if (i>0 && i<TOTAL_KEYWORDS+2)
     return &wordlist[i];
   else
     return NULL;
}

