/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor
* 	 
*	    Copyright (C) 1995 Matthias Ettrich
*
*======================================================*/


/* very simple help system. 
 * It just loads a lyx documentation file.
 * The only difference is, that the file selector's directory
 * is set to LYX_DIR/doc and the table of contents is invoked
 * automatically. */ 

#include "config.h"

#include "forms.h"

#include "file.h"
#include "docu.h"
#include "lyx_cb.h"
#include "paths.h"
#include "lyxrc.h"
#include "minibuffer.h"

/* extern */
extern char * system_lyxdir;

/* functions from lyx_cb.C */ 
extern void LoadLyXFile(const char*);
extern void ResizeCurrentBufferPseudoExpose();
extern void MenuShowTableOfContents();
extern char* document_path;

void MenuDocu() {
   const char *got_fname;
   char * doc_dir;
   // int i=0, file_type=0; // unused

   /* try directory  LYX_DIR/doc */ 
   doc_dir = AddPath(NULL, system_lyxdir, "doc");
   // got_fname = fl_show_file_selector("Documentation to Open", doc_dir,"*.lyx","");
   SetFSelButton(0, "Documents", doc_dir);
   SetFSelButton(1, "Templates", lyxrc.template_path);
   got_fname = SelectFile("Documentation to Open", doc_dir,"*.lyx","");
   SetFSelButton(0, NULL, NULL);
   SetFSelButton(1, NULL, NULL);
   /* flushes Xlib queue */
   XFlush(fl_get_display());
   /* shorten the filename if it begins with the path */
   delete doc_dir;
   if (!got_fname)
      return;
   // revise this dabn100
   char *fname = new char[strlen(got_fname)+5];
   strcpy(fname, got_fname);

   minibuffer.Set("Opening document",fname,"...");   

   LoadLyXFile(fname);
   ResizeCurrentBufferPseudoExpose();
   MenuShowTableOfContents();
}
