#!/usr/bin/perl

# Copyright 1998 by Marco Budde (Budde@tu-harburg.de)
# GNU GPL license



%config = ( "c't - magazin fr computer technik", 
               "/var/lib/heise-register/ct.cti",
            "iX", "/var/lib/heise-register/ix.cti",
            "Gateway", "/var/lib/heise-register/gw.cti",
            "Elrad", "/var/lib/heise-register/el.cti" );

#  c't - 1/93 bis 15/97
#  iX  - 1/93 bis 12/97
#  Gateway - 94 bis 97
#  Elrad - 1/93 bis 6/97

####################################
# some subroutines for cgi parsing #
####################################

sub url_decode 
{
    my $input = shift;
    $input =~ s/\+/ /g;
    $input =~ s/%([0-9A-Fa-f-]{2})/pack("c", $1)/eg;
    return $input;
}

sub parse_cgi
{
    my $input = shift;
    my %FORM;
    my (@PAIRS, $pair);

    @PAIRS = split (/&/, $input);
    foreach $pair (@PAIRS) 
    {
      ($key, $value) = split (/=/, $pair);
      $key = &url_decode ($key);
      $value = &url_decode ($value);
      if (defined $FORM {$key})
      {
	  $FORM {$key} .= "\0" . $value;
      }
    else
    {
	$FORM {$key} = $value;
    }
  }

    return %FORM;
}


###########################
#  parse the index files  #
###########################

sub parse_cti
{
    $cti{'head1'} = <INCTI>;
    $cti{'head2'} = <INCTI>;
    $cti{'autor'} = <INCTI>;
    chop $cti{'autor'};
    $cti{'autor_k'} = <INCTI>;
    chop $cti{'autor_k'};
    $cti{'seite'} = <INCTI>;
    $cti{'monat'} = <INCTI>;
    chop $cti{'monat'}; 
    $cti{'jahr'} = <INCTI>;
    $cti{'jahr'} =~ /[a-x](.*)/i;
    $cti{'jahr'} = $1;
    my $zw = <INCTI>;
    $cti{'stichworte'} = <INCTI>;
}


####################
#  output results  #
####################

sub html_head
{
    print "<H2>$datei</H2>\n";
    print "<TABLE>\n";
    print "<TR BGCOLOR=#FFFFCC><TH>Titel<TH>Autor<TH>Ausgabe<TH>Seite\n";
}

sub html_output
{
    printf ("<TR VALIGN=top><TD><B>%s</B><BR>", $cti{'head1'});
    printf ("%s", $cti{'head2'});

    printf ("    <TD>%s (%s)\n", $cti{'autor'}, $cti{'autor_k'});
    printf ("    <TD>%s/%s", $cti{'monat'}, $cti{'jahr'});
    printf ("	 <TD>%s", $cti{'seite'});
}

sub html_tail
{
    print "</TABLE>\n";
}


############
#   main   #
############

%FORM = &parse_cgi ($ENV {'QUERY_STRING'});

#$FORM{'search'} = "Intel";

print "Content-type: text/html\n\n";
print "<HTML>\n<HEAD>\n";
print "<TITLE>Suche in Magazinen vom Heise Verlag</TITLE>\n";
print "</HEAD>\n<BODY BGCOLOR=#FFFFFF>\n";
print "<H1>Suche nach: $FORM{'search'}</H1>";

foreach $datei (keys %config)
{
  &html_head;
  open (INCTI, "< $config{$datei}");

  while (&parse_cti)
  { 
    if ($cti{'stichworte'} =~ /$FORM{'search'}/ or
        $cti{'head1'} =~ /$FORM{'search'}/ or
        $cti{'head2'} =~ /$FORM{'search'}/ or
        $cti{'autor'} =~ /$FORM{'search'}/)
    {
      &html_output;
    }

  }

  close (INCTI);
  &html_tail;
}

print "</BODY>\n</HTML>\n";
