/*****************************************************************************/

/*
 *	xfhdlcchpar.c  -- kernel hdlc radio modem driver channel parameter setting utility.
 *
 *	Copyright (C) 1996  Thomas Sailer (sailer@ife.ee.ethz.ch)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Please note that the GPL allows you to use the driver, NOT the radio.
 *  In order to use the radio, you need a license from the communications
 *  authority of your country.
 *
 *
 * History:
 *   0.1  14.12.96  Started
 *   0.2  11.05.97  introduced hdrvcomm.h
 */

/*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <linux/if.h>
#include <forms.h>
#include "hdrvcomm.h"
#include "xfhdlcchpar.h"

/* ---------------------------------------------------------------------- */

static char *progname;
static FD_chpar *fd_chpar;

/* ---------------------------------------------------------------------- */

void cb_update(FL_OBJECT *ob, long data)
{
	int ret;
	struct hdrvc_channel_params cp;

	cp.tx_delay = 0.1*fl_get_slider_value(fd_chpar->txdelay);
	cp.tx_tail = 0.1*fl_get_slider_value(fd_chpar->txtail);
	cp.slottime = 0.1*fl_get_slider_value(fd_chpar->slottime);
	cp.ppersist = fl_get_slider_value(fd_chpar->ppersist);
	cp.fulldup = !!fl_get_button(fd_chpar->fulldup);
	ret = hdrvc_set_channel_access_param(cp);
	if (ret < 0) 
		perror("hdrvc_set_channel_access_param");
}

/* ---------------------------------------------------------------------- */

void cb_quit(FL_OBJECT *ob, long data)
{
	exit(0);
}

/* ---------------------------------------------------------------------- */

static const char *usage_str = 
"[-i smif]\n"
"  -i: specify the name of the baycom kernel driver interface\n\n";

/* ---------------------------------------------------------------------- */

int main(int argc, char *argv[])
{
	int ret;
	struct hdrvc_channel_params cp;

	progname = *argv;
	printf("%s: Version 0.2; (C) 1996-1997 by Thomas Sailer HB9JNX/AE4WA\n", *argv);
	fl_initialize(&argc, argv, 0, 0, 0);
	hdrvc_args(&argc, argv, "bc0");
	while ((ret = getopt(argc, argv, "")) != -1) {
		switch (ret) {
		default:
			printf("usage: %s %s", *argv, usage_str);
			exit(-1);
		}
	}

	fd_chpar = create_form_chpar();
	fl_set_object_label(fd_chpar->ifname, hdrvc_ifname());
	/*
	 * set channel params
	 */
	ret = hdrvc_get_channel_access_param(&cp);
	if (ret < 0) {
		perror("hdrvc_get_channel_access_param");
		exit(1);
	}
	fl_set_slider_step(fd_chpar->txdelay, 10);
	fl_set_slider_value(fd_chpar->txdelay, cp.tx_delay*10);
	fl_set_slider_step(fd_chpar->txtail, 10);
	fl_set_slider_value(fd_chpar->txtail, cp.tx_tail*10);
	fl_set_slider_step(fd_chpar->slottime, 10);
	fl_set_slider_value(fd_chpar->slottime, cp.slottime*10);
	fl_set_slider_step(fd_chpar->ppersist, 1);
	fl_set_slider_value(fd_chpar->ppersist, cp.ppersist);
	fl_set_button(fd_chpar->fulldup, !!cp.fulldup);
	fl_show_form(fd_chpar->chpar, FL_PLACE_CENTER, FL_FULLBORDER, 
		     "HDLC channel parameters");
	for (;;)
		fl_do_forms();
	exit(0);
}
