!**************************************************************************
!*
!* Boot-ROM-Code to load an operating system across a TCP/IP network.
!*
!* Module:  bcc_idiv.S
!* Purpose: Routines required by bcc
!* Entries: idiv_, idiv_u
!*
!**************************************************************************
!*
!* Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
!*
!*  This program is free software; you can redistribute it and/or modify
!*  it under the terms of the GNU General Public License as published by
!*  the Free Software Foundation; either version 2 of the License, or
!*  any later version.
!*
!*  This program is distributed in the hope that it will be useful,
!*  but WITHOUT ANY WARRANTY; without even the implied warranty of
!*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!*  GNU General Public License for more details.
!*
!*  You should have received a copy of the GNU General Public License
!*  along with this program; if not, write to the Free Software
!*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!*


!
!**************************************************************************
!
! Include assembler macros:
!
#include <macros.inc>
#include <memory.inc>
#include "./libpriv.inc"


!
!**************************************************************************
!
! Start code segment.
!
	.text

	public	idiv_		! define entry points
	public	idiv_u


!
!**************************************************************************
!
! Define BCC support functions
!
! DIV
idiv_:	cwd
	idiv	bx
	ret


! unsigned DIV
idiv_u:	xor	dx,dx
	div	bx
	ret


!
!**************************************************************************
!
	end

