/*
 * mapfile.h
 * 
 * Choose-OS mapfile stuff
 *
 * Copyright (c) Tuomo Valkonen 1996-1997.
 */
#ifndef _MAPFILE_H
#define _MAPFILE_H

#include"chos.h"

#define MF_ENDSECTOR	0xfffffffe
#define MF_NULLSECTOR	0xffffffff
#define MF_NULLEND_HI	0xffff
#define MF_NULL_LOW		0xffff
#define MF_END_LOW		0xfffe

#define MF_NENTS		127
#define MF_SIZEENTS		508
#define MF_NAME_LEN		39
#define MF_NEXT_OFF		508

#define BID_DATA_SIZE	56		// how many bytes 1 image descriptor uses
#define BID_NAME_LEN	40		// image name max len
#define BID_NAME_OFF	0		// offset of image name within it's descriptor 
#define BID_COLOR_OFF	40		// color used to display this
#define BID_HOTKEY_OFF	41		// hotkey
#define BID_X_OFF		42		// x position
#define BID_Y_OFF		43		// y position
#define BID_FLAGS_OFF	44		// flags
#define BID_TYPE_OFF	46		// image type
#define BID_LOADER_OFF	47		// loader nr.
#define BID_DRIV_OFF	48		// bios drive number
#define BID_RWDEV_OFF	49		// mbr rewrite device
#define BID_KEYPRESS_OFF 50
#define BID_ADDR_OFF	52		// linear sector address

#define CF_HOT_HIDDEN	0x10	// don't print hotkey
#define CF_NOPASS		0x20	// Don't use password for this image
#define CF_RESTRICTED	0x40	// Restricted - password is only
								//  asked if command line is specified

// bootsector flags
#define BS_REWRITE		0x01	// rewrite partition table
#define BS_SWAPHD		0x02	// swap hda/hdb
#define BS_SWAPFD		0x04	// swap fd0/fd1
#define BS_DOS4BOOT		0x08	// Tell dos4.0+/ OS/2 to boot off hdb

#define AUTOBOOT_NO				0
#define AUTOBOOT_PRESSED		1
#define AUTOBOOT_NOT_PRESSED	2

#define MAX_LOADERS			4
#define MAX_LOADER_SIZE		7
#define LOADER_SHIFT		5

#define MAX_PASSWD_LEN		31

#ifndef __ASSEMBLY__

 typedef struct{
 	uchar	name[BID_NAME_LEN];
 	uchar	color;
 	uchar	hotkey;
 	uchar	x,y;
 	ushort	flags;
 	uchar	type;
 	uchar	loader;
 	uchar	device;
 	uchar	rewrite_device;
 	ushort	keypress;	//pad2;
 	ulong	addr;
 }MF_ImageDes;
 
 #define MAX_IMAGES	((SECTORSIZE-4)/sizeof(MF_ImageDes))
 
 typedef struct{
 	uchar	drive;
 	uchar	nsects;
 	ushort	_pad1;
 	ulong	sects[MAX_LOADER_SIZE];
 }MF_Loader;
 
 typedef struct{
 	// Header
 	char		unused[2];
 	char		id[3];
 	char		type;
 	char		major,minor;
 	
 	uchar		delay;
 	uchar		nimages;
 	uchar		default_image;
 	uchar		color;
 	
 	uchar		selcolor; 	
 	uchar		autoboot;
 	uchar		singleshot;
 	uchar		nloaders;
 	
 	signed char	timex;
 	signed char	timey;
 	signed char	timestrx;
 	signed char	loady;
 	
 	uchar		map_drive;
 	uchar		bg_drive;
 	ushort		pad;
 	ulong		map_sect1;
 	
 	ulong		bg_sects[8];
 	char		passwd[MAX_PASSWD_LEN+1];
 	MF_Loader	loaders[MAX_LOADERS];
 }MF_HeaderSector;					

 typedef struct{
 	MF_ImageDes 	images[MAX_IMAGES];
 }MF_ImageSector;

 typedef struct{
  	ulong		floppybsect;
 	uchar		device;
	uchar		rd_device;
	ushort		rd_size;	// in sectors
	ulong		rd_load_addr;
	ulong		rd_map;
 	char		cmdline[SECTORSIZE-5*4];
 	ulong		next_map;
 }MF_LinuxFirstSector;

 typedef struct{
 	ulong		sect[MF_NENTS];
 	ulong		next_map;
 }MF_KernelSector;
 
#endif

#endif /* _MAPFILE_H */