/*
 * image.S
 *
 * Image stuff
 *
 * Copyright (c) Tuomo Valkonen 1997.
 */
 

// Prepare stuff for image StartUp
// Returns address of image on descriptor in SI.
//////////////////////////////////////////////////
prepare_start:
// Reset screen
/////////////////
	mov	al,chos_color		// Don't want background anymore
	and	al,#0x0f
	cmp	al,#0x00
	jne	color_still_ok
	mov	al,#0x07
color_still_ok:
	mov	chos_color,al
	
	mov	dh,chos_loady
clear_loop:
	cmp	dh,#24
	ja	clear_done
	call	clear_line
	inc	dh
	jmp	clear_loop
clear_done:
	mov	dh,chos_loady
	dec	dh
	xor	dl,dl
	call	set_cursor_pos		// move the cursor to sane place
	call	crlf			// will scroll screen if at bottom
	
// Find the image descriptor
//////////////////////////////
	mov	al,selected		// count descriptor offset
	mov	cl,#BID_DATA_SIZE
	mul	cl
	mov	si,#boot_images
	add	si,ax
	mov	image,si
	
// Check if password is required
//////////////////////////////////
	cmp	byte ptr chos_passwd,#0
	je	no_password
	test	(si+BID_FLAGS_OFF),#CF_NOPASS
	jnz	no_password
	cmp	byte ptr ask_cmdline,#1
	je	do_ask_pass
	test	(si+BID_FLAGS_OFF),#CF_RESTRICTED
	jnz	no_password

do_ask_pass:
	mov	si,#str_password
	call	print

	mov	bl,#1
	mov	di,#0
pass_loop:
	mov	ah,#0
	int	#0x16
	cmp	ax,#KEY_ENTER
	je	got_passwd
	cmp	al,#0
	je	pass_loop
	cmp	al,(di+chos_passwd)
	je	got_ok
	mov	bl,#0
got_ok:
	cmp	di,#MAX_PASSWD_LEN-1
	je	got_passwd
	inc	di
	jmp	pass_loop
got_passwd:
	call	crlf
	cmp	bl,#1
	jne	invalid_password
	cmp	(di+chos_passwd),#0
	jne	invalid_password

	mov	si,image
no_password:
	ret

invalid_password:
	mov	si,#str_invalid_password
	call	print
	dec	byte ptr passwd_count
	jnz	do_ask_pass
asdf:	hlt
	jmp	asdf


// Say that an image is being loaded
//////////////////////////////////////
tell_loading:
	pusha

	mov	si,#str_loading
	call	print

	mov	si,image
	call	print

	mov	si,#dots
	call	print
	
	popa
	ret


// Data
/////////
passwd_count:		.byte	3

str_password:		.ascii	"Password: "
			.byte	0

str_invalid_password:	.ascii	"Invalid!"
			.byte	0xd,0

