/*
 * loader.S
 *
 * Choose-OS second stage loader main file.
 *
 * Copyright (c) Tuomo Valkonen 1996-1997.
 */

.text

#define STAGE2

#include <chos/chos.h>
#include <chos/mapfile.h>
#include <chos/address.h>

#define selected	chos_default

.globl  _main

.org    STAGE2_OFF
_main:  jmp     start
.org    STAGE2_OFF+2
chos_id:	.ascii	"CHO"			// cs:2 = "CHO"
chos_stage:	.byte	CHOS_LOADER		// cs:3 = 2 = second stage loader
chos_major:	.byte	CHOS_MAJOR		// cs:6 = major version #
chos_minor:	.byte   CHOS_MINOR		// cs:7 = minor version #

// Initialization
///////////////////
start:
        cli
	mov     ax,#STAGE2_SEG			// init
        mov     ds,ax
	mov	es,ax
	mov	fs,ax
        mov     sp,#STACK_SIZE
        mov     ax,#STACK_SEG
        mov     ss,ax
	sti

// Check single-shot autoboot
///////////////////////////////
	cmp	byte ptr chos_singleshot,#0
	je	no_singleshot

	mov	al,chos_singleshot
	dec	al
	push	ax	// Save it - we copy it to "selected" later
	mov	byte ptr chos_singleshot,#0

#ifndef NO_BEEP
	// Beep
        mov     ah,#0x0e	! print char
        mov     al,#0x07	! "bell"
        mov     bl,#0x00	! no color	
        int     0x10		! do "beep" 
#endif
	// Rewrite 1st mapfile sector !
	/////////////////////////////////
	mov	ax,word ptr chos_map_sect1
	mov	dx,word ptr chos_map_sect1+2
	mov	bx,#DATA_OFF
	mov	cl,chos_map_drive
	call	write_linear

	pop	ax
	mov	selected,al

	mov	chos_autoboot,#AUTOBOOT_NOT_PRESSED

	// Fall thru
no_singleshot:

// Check autoboot
///////////////////
	cmp	byte ptr chos_autoboot,#AUTOBOOT_NO
	je	no_autoboot
	mov	ah,#0x02
	int	#0x16
	test	al,#0x7
	jz	autoboot_test_nopress	// nothing pressed
	cmp	byte ptr chos_autoboot,#AUTOBOOT_PRESSED
	je	autoboot_init
	jmp	no_autoboot
autoboot_test_nopress:
	cmp	byte ptr chos_autoboot,#AUTOBOOT_NOT_PRESSED
	jne	no_autoboot
	
	// We're doing an autoboot this time...
autoboot_init:
	mov	si,#fast_banner
	call	print

	mov	al,selected		// count descriptor offset
	mov	cl,#BID_DATA_SIZE
	mul	cl
	mov	si,#boot_images
	add	si,ax
	mov	image,si

	br	autoboot
	
no_autoboot:

// Initialize menu
////////////////////
	call	load_background
	call	print_images

	cmp	byte ptr chos_delay,#255
	jne	do_set_timer
	mov	byte ptr old_sec,#255
	jmp	no_timer

// Initialize timer
/////////////////////
do_set_timer:
	call	set_timer
	
// main loop - wait for user input. 
// If no input in <chos_delay> seconds, start default
///////////////////////////////////////////////////////
wait_input:
	cmp	byte ptr old_sec,#255
	je	no_timer

	call	read_timer
	cmp	al,#0				// time expired ?
	jne 	no_timer
	br	do_start_it

no_timer:
	mov	ah,#1
	int	0x16
	jz	wait_input			// nuffin...
	
	cmp	byte ptr old_sec,#255
	je	already_off
	
	pusha
	movb	old_sec,#255			// = timer is off.
	mov	dh,chos_timey
	mov	dl,chos_timestrx
	call	set_cursor_pos
	mov	cx,#3
	add	cl,chos_timex
	sub	cl,dl
	mov	bl,chos_color
	mov	ax,#0x0920
	int	#0x10
	popa

already_off:
	mov	ah,#0				// Read it to empty buffer...
	int	0x16
	cmp	al,#0
	je	wi_special
	cmp	al,#0x0d			// Enter - we wanna start it
	je	do_start_it
	cmp	al,#0x20
	je	do_start_it_opt

	// A hotkey?
	call	toupper

	mov	ah,#0
	mov	si,#boot_images
check_hotkey:	
	cmp	(si+BID_HOTKEY_OFF),al
	je	it_is_a_hotkey
	add	si,#BID_DATA_SIZE
	inc	ah
	cmp	ah,chos_images
	jae	wait_input
	jmp	check_hotkey
	
it_is_a_hotkey:
	mov	al,ah
	call	select
	jmp	do_start_it

wi_special:

	cmp	ah,#0x48	// Up	 - prev
	je	wi_prev
	cmp	ah,0x4b		// Left  - prev
	je	wi_prev
	cmp	ah,#0x50	// Down  - next
	je	wi_next
	cmp	ah,0x4d		// Right - next
	je	wi_next
	br	wait_input
wi_next:
	mov	al,selected
	inc	al
	jmp	wi_test
wi_prev:
	mov	al,selected
	dec	al
wi_test:
	cmp	al,chos_images
	jb	sel_done
	jge	sel_first_image
	mov	al,chos_images
	dec	al
	jge	sel_done
sel_first_image:
	mov	al,#0
sel_done:
	call	select
wait_input_ret:
	br	wait_input


// Start with command line
////////////////////////////
do_start_it_opt:
	mov	byte ptr ask_cmdline,#1

	// Fall thru

// Start an image
///////////////////
do_start_it:
	call	prepare_start		// count the offset of the image n stuff
	
autoboot:
	mov	bl,(si+BID_LOADER_OFF)
	cmp	bl,chos_nloaders
	jb	loader_ok
	mov	si,#str_corrupt_map
	jmp	die
	
loader_ok:
	shl	bl,#LOADER_SHIFT
	xor	bh,bh
	add	bx,#chos_loaders
	mov	cl,(bx)
	mov	al,(bx+1)
	mov	secno,al
	add	bx,#4
	mov	si,bx
	push	ds
	pop	es
	mov	bx,#LOADER_OFF
	call	load_sects

	mov	si,image
	mov	bl,(si+BID_TYPE_OFF)
	shl	ebx,#24
	or	ebx,#0x104f4843
	
	// Is the loader valid ?
	cmp	dword ptr [2+LOADER_OFF],ebx
	jne	loader_invalid
	
	cmp	byte ptr [6+LOADER_OFF],#CHOS_MAJOR ! is it current version ?
	jne	loader_invalid
	
	cmp	byte ptr [7+LOADER_OFF],#CHOS_MINOR ! is it current version ?
	jne	loader_invalid

	// Load boot sector/1st map sector
	call	load_1st_sector
	
	mov	byte ptr last_drive,#0xff
	// Pass control to the loader
	jmpi	#LOADER_OFF,#STAGE2_SEG
	
loader_invalid:
	mov	si,#str_loader_invalid
	call	print
	mov	si,#LOADER_OFF
	jmp	die

// Includes
/////////////
	
#include "misc.S"
#include "int13.S"
#include "read.S"
#include "screen.S"
#include "timer.S"
#include "extmem.S"
#include "image.S"
#include "background.S"

// Data
/////////
text_invalid:	.ascii	"Failure."
		.byte	0

str_loader_invalid:
		.ascii	"Loader signature invalid"
		.byte	0
str_corrupt_map:
		.ascii	"Corrupt mapfile"
		.byte	0

fast_banner:	.ascii	"Choose-OS "
		.ascii	CHOS_VERSIONSTR
		.ascii	" booting..."
		.byte	0xd,0

// Function entry point table
///////////////////////////////
.org FN_TABLE_OFF
	.word	print
	.word	print_period
	.word	crlf
	.word	get_cmdline
	.word	tell_loading
	.word	load_1st_sector
	.word	load_next_map
	.word	load_map
	.word	read_linear
	.word	load_it
	.word	toupper
	.word	putch
	.word	end_load
	.word	reset_drive
	.word	write_linear

// Exported variables
///////////////////////
image:		.word	0
ask_cmdline:	.word	0
drive:		.word	0
load_high:	.word	0
secno:		.word	0

// GDT used for transfering data above 1M
///////////////////////////////////////////
copy_gdt:
	.word	0,0,0,0
	.word	0,0,0,0

copy_src:
	.word	0xffff
copy_src_base:
	.byte	0,0,1			! base = 0x010000
	.byte	0x93			! typbyte
	.word	0			! limit16,base24 =0

copy_dst:
	.word	0xffff
copy_dst_base:
	.byte	0,0,0x10		! base = 0x100000
	.byte	0x93			! typbyte
	.byte	0			! limit16
copy_dst_base24:				
	.byte	0			! base24=0

	.word	0,0,0,0			! BIOS CS
	.word	0,0,0,0			! BIOS DS


.org	DATA_OFF
