static char dqs_parse_qconf_rcsid[]="$Id: dqs_parse_qconf.c,v 1.1.1.1 1997/04/10 15:10:33 green Exp $";

/*----------------------------------------------------
 * dqs_parse_qconf.c Tom Green Mon Jan 31 10:42:56 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_parse_qconf.c,v $
 * Revision 1.1.1.1  1997/04/10 15:10:33  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.16  1996/11/20 23:04:04  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.15  1996/06/27  01:55:55  nrl
 * changes to accomodate osf gcc
 *
 * Revision 3.14  1996/06/23  19:41:17  nrl
 * added missing templates for dqs_write_consumable_list,
 * added message types to log entries
 * setup GNU base for makefile.proto.in
 *
 * Revision 3.13  1996/03/22  04:20:56  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.12  1996/03/21  17:07:04  nrl
 * added fortran and "c" syntax to resource requests
 *
 * Revision 3.11  1996/03/19  23:27:19  nrl
 * added capability to clean up consumable resources whenthey
 * get out of sync with reality
 *
 * Revision 3.10  1996/03/14  03:16:22  nrl
 * merge in subordinate queues and consumable resource changes
 *
 * Revision 3.9  1995/05/29  18:08:52  nrl
 * More solaris stuff GAGGHH had to differentiate more cases of
 * solaris2.3 and solaris2.4 stuff
 *
 * Revision 3.8  1995/02/13  02:17:55  nrl
 * repaired a goof I introduced in add_queue during the
 * recent
 * updates.
 *
 * Revision 3.7  1995/02/09  22:44:11  nrl
 * Added "-mq" modify queue option
 *
 * Revision 3.5  1994/03/26  19:49:34  green
 * fixed queue "acl" and "xacl" functionality.
 *
 * Revision 3.4  1994/03/26  17:33:31  green
 * "qconf -aq" now pulls across "GENERIC_QUEUE"
 *
 * Revision 3.3  1994/03/26  16:33:35  green
 * added "-srl" support.
 *
 * dqs_resolve.c:dqs_read_resolve_file() now returns the primary qmaster
 * name for fields marked as "none"
 *
 * Revision 3.2  1994/03/26  15:29:16  green
 * allowed for "qconf -sq [dest_id_list]" vs "qconf -sq dest_id_list"
 *
 * write generic queue configuration in common_dir
 *
 * Revision 3.1  1994/03/17  15:40:18  green
 * added support for "qconf -qmon"
 *
 * Revision 3.0  1994/03/07  04:14:17  green
 * 3.0 freeze
 *
 * Revision 1.5  1994/02/23  20:34:30  green
 * added some sanity checking to dqs_parse_job() and dqs_parse_qconf()
 *
 * Revision 1.4  1994/02/10  18:24:36  green
 * removed the following options from "qsub"
 *
 * 	-k
 * 	-p
 * 	-u
 * 	-z
 *
 * fixed the following options in "qsub"
 *
 * 	-e
 * 	-o
 * 	-N
 * 	-v
 *
 * synced with docs
 *
 * Revision 1.3  1994/02/09  19:48:12  green
 * syncing source with docs
 *
 * Revision 1.2  1994/02/02  20:22:12  green
 * cleaned up "qconf.c" to sync with docs
 *
 * Revision 1.1.1.1  1994/02/01  17:57:44  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/

 
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/************************************************************************/
dqs_list_type *dqs_parse_qconf(argv_head,envp)
dqs_list_type *argv_head;
char **envp;

/*
dqs_parse_qconf - is the parser utilized by "qconf"

dqs_parse_qconf() returns a chained linked list of requests to
be forwarded, individually, to the qmaster.

*/

{
     
     int           sfd;
     int           status;
     char          *cp=NULL;
     char          *cp2=NULL;
     char          *cp3=NULL;
     string        str;
     string        tmpfname;     
     string        tmpname;
     string        consstr;
     int           consfile, conslen;
     dqs_list_type *head=NULL;
     dqs_list_type *sp=NULL;
     dqs_list_type *tmp_sp=NULL;
     dqs_list_type *listel_ptr;
     dqs_list_type *response_list=NULL;
     
     DENTER((DQS_EVENT,"dqs_parse_qconf"));
     
     sp=argv_head;
     listel_ptr=(dqs_list_type *)dqs_malloc(sizeof(dqs_list_type));

     while (sp) {
	  
	  bzero((char *)listel_ptr,sizeof(dqs_list_type));

/*-----------------------------------------------------------------------------*/
          /* "-ac complex [complex_template]" */
	  
          if (!strcmp("-ac",sp->str0)) 
	  {	
	       cp=NULL;  /* new complex name */
	       cp2=NULL; /* template name */
	       cp3=NULL; /* tmpfilename */
	       
	       dqs_validate_option(ac_OPT,sp->str0);
	       sp=dqs_parser_get_next(sp,sp->str0);
	       cp=dqs_string_insert(cp,sp->str0); 
	       
	       cp3=(char *)tmpnam(str);
	       if (!cp3)
	       {
		    if (dqs_should_i_continue("error generating tempoary file name",NULL))
		    continue;
	       }
	       close(creat(cp3,0755));
	       
	       status=dqs_edit(cp3);
	       if (status < 0) 
	       {
		    DTRACE;
                    unlink(cp3);
                    if (dqs_should_i_continue("edit failed",NULL))
                    continue;
		    
	       }
	       DTRACE;
	       
	       if (status > 0) 
	       {
                    unlink(cp3);
                    if (dqs_should_i_continue("file unchanged",NULL))
                    continue;
	       }
	       
	       bzero((char *)listel_ptr,sizeof(dqs_list_type));
	       listel_ptr->type=QCONF;
	       listel_ptr->int0=ac_OPT;
	       listel_ptr->str0=cp;
	       listel_ptr->chain=dqs_read_complex_file(NULL,cp3);
	       if (!listel_ptr->chain)
	       {
		    unlink(cp3);
                    if (dqs_should_i_continue("error reading in file",NULL))
                    continue;
               }
               listel_ptr->int2=dqs_length_of_list(listel_ptr->chain);

	       unlink(cp3);
	       dqs_showlist(listel_ptr,DQS_DEBUG|DQS_INT0|DQS_INT1|DQS_STR0|DQS_CHAIN,8);
	       
	       head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
	       
               continue;
          }
	  
/*-----------------------------------------------------------------------------*/
          /* "-acons consumable " */
	  
          if (!strcmp("-acons",sp->str0)) 
	  {	
	       cp=NULL;  /* new consumable name */
	       cp3=NULL; /* tmpfilename */
	       
	       dqs_validate_option(acons_OPT,sp->str0);
	       sp=dqs_parser_get_next(sp,sp->str0);

	       cp=dqs_string_insert(cp,sp->str0); 
	       
	       cp3=(char *)tmpnam(str);
	       if (!cp3)
	       {
		    if (dqs_should_i_continue("error generating tempoary file name",NULL))
		    continue;
	       }
	       sprintf(consstr,"consumable %s\navailable= 0\nconsume_by= 0\ncurrent= 0\n",sp->str0);
	       consfile=creat(cp3,0755);
	       conslen= strlen(consstr);
	       write(consfile,consstr,conslen);
	       close(consfile);
	       
	       status=dqs_edit(cp3);
	       if (status < 0) 
	       {
		    DTRACE;
                    unlink(cp3);
                    if (dqs_should_i_continue("edit failed",NULL))
                    continue;
		    
	       }
	       DTRACE;
	       
	       if (status > 0) 
	       {
                    unlink(cp3);
                    if (dqs_should_i_continue("file unchanged",NULL))
                    continue;
	       }
	       
	       bzero((char *)listel_ptr,sizeof(dqs_list_type));
	       listel_ptr->type=QCONF;
	       listel_ptr->int0=acons_OPT;
	       listel_ptr->str0=cp;
	       listel_ptr->chain=dqs_read_consumable_file(NULL,cp3);
	       if (!listel_ptr->chain)
	       {
		    unlink(cp3);
                    if (dqs_should_i_continue("error in consumabale description",NULL))
                    continue;
               }
               listel_ptr->int2=dqs_length_of_list(listel_ptr->chain);

	       unlink(cp3);
	       dqs_showlist(listel_ptr,DQS_DEBUG|DQS_INT0|DQS_INT1|DQS_STR0|DQS_CHAIN,8);
	       
	       head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
	       
               continue;
          }
	  
	  /*-----------------------------------------------------------------------------*/
	  /* "-ah server_name[,server_name,...]" */
	  
	  if (!strcmp("-ah",sp->str0)) { 
	       dqs_validate_option(ah_OPT,sp->str0);
	       sp=dqs_parser_get_next(sp,sp->str0);
	       dqs_parse_name_list(&head,sp->str0,ah_OPT);
	       sp=sp->next;
	       continue;
	  }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-am user_list" */
	  
          if (!strcmp("-am",sp->str0))
          {
               dqs_validate_option(am_OPT,sp->str0);
               sp=dqs_parser_get_next(sp,sp->str0);
               dqs_parse_name_list(&head,sp->str0,am_OPT);
               sp=sp->next;
               continue;
          }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-ao user_list */
	  
          if (!strcmp("-ao",sp->str0))
          {
               dqs_validate_option(ao_OPT,sp->str0);
               sp=dqs_parser_get_next(sp,sp->str0);
               dqs_parse_name_list(&head,sp->str0,ao_OPT);
               sp=sp->next;
               continue;
          }
	  
          /*-----------------------------------------------------------------------------*/
          /*  "-aq [q_template]" */
	  
          if (!strcmp("-aq",sp->str0))
          {
               cp=NULL; 
           dqs_validate_option(aq_OPT,sp->str0);
	       bzero((char *)listel_ptr,sizeof(dqs_list_type));
	       listel_ptr->type=QCONF;
	       listel_ptr->int0=sq_OPT;
	       if (!dqs_next_is_an_opt(sp))
	       {
		    sp=dqs_parser_get_next(sp,sp->str0);
		    listel_ptr->str0=dqs_string_insert(NULL,sp->str0);
	       }

	       sp=sp->next;
	       if ((sfd=dqs_send_list(me.default_cell,conf.qmaster_service,sfd,listel_ptr))<0)
	       {
		    if (dqs_should_i_continue("unable to contact qmaster",NULL))
		    continue;
	       }
	       if (dqs_get_list(sfd,&response_list))
	       {
		    if (dqs_should_i_continue("unable to get queue_template from qmaster",NULL))
		    continue;
	       }
	       bzero((char *)listel_ptr,sizeof(dqs_list_type));
	       listel_ptr=(dqs_list_type *)dqs_malloc(sizeof(dqs_list_type));
	       listel_ptr->type=DQS_ACK;
	       (void) dqs_send_list(NULL,NULL,sfd,listel_ptr);
	       dqs_close_sfd(sfd);
	       DTRACE;            
	       if (response_list->status!=DQS_ACK)
	       {
		    DTRACE;
		    if (dqs_should_i_continue(NULL,response_list))
		    continue;
	       }
	       DTRACE;
	       cp=dqs_write_qconf(FALSE,NULL,NULL,response_list->queue);
	       
	       if (!cp) 
	       {
		    if (dqs_should_i_continue("unable to write queue_template",NULL))
		    continue;
	       }

               status=dqs_edit(cp);
               if (status < 0) 
               {
                    unlink(cp);
                    if (dqs_should_i_continue("edit failed",NULL))
                    continue;
                    
               }
               
               if (status > 0) 
               {
                    unlink(cp);
                    if (dqs_should_i_continue("file unchanged",NULL))
                    continue;
               }
               
               bzero((char *)listel_ptr,sizeof(dqs_list_type));
               listel_ptr->type=QCONF;
               listel_ptr->int0=aq_OPT;
               listel_ptr->queue=dqs_read_in_qconf(NULL,cp);
               if (!listel_ptr->queue)
               {
                    unlink(cp);
                    if (dqs_should_i_continue("error reading in file",NULL))
                    continue;
               }
               listel_ptr->str0=dqs_string_insert(NULL,listel_ptr->queue->qname);

               unlink(cp);

               head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
               continue;
          }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-au user_list list_name[,list_name,...]"*/

          if (!strcmp("-au",sp->str0))
          {
               dqs_validate_option(au_OPT,sp->str0);
               sp=dqs_parser_get_next(sp,sp->str0);
               if (!sp->next)
               {
                    ERROR((DQS_EVENT,"DQS_ERROR_0334 no list_name provided to \"-au %s\"",
                         sp->str0));
                    dqs_usage();
                    DEXITE;
                    exit(DQS_EINVAL);
               }
	       cp=dqs_string_insert(NULL,sp->str0);
               sp=dqs_parser_get_next(sp,sp->str0);
               dqs_parse_acl_list(&head,cp,sp->str0,au_OPT);
               sp=sp->next;
               continue;
          }
	 
          /*-----------------------------------------------------------------------------*/
          /* "-Aq fname" */
	  
          if (!strcmp("-Aq",sp->str0))
          {
               dqs_validate_option(Aq_OPT,sp->str0);
               sp=dqs_parser_get_next(sp,sp->str0);
               listel_ptr->type=QCONF;
               listel_ptr->int0=aq_OPT;
	       listel_ptr->queue=dqs_read_in_qconf(NULL,sp->str0);
               if (!listel_ptr->queue)
               {
                    if (dqs_should_i_continue("error reading in file",NULL))
                    continue;
               }
               listel_ptr->str0=dqs_string_insert(NULL,listel_ptr->queue->qname);
               head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
               sp=sp->next;
               continue;
          }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-cell cell_name" */
	  
          if (!strcmp("-cell",sp->str0))
          {
               dqs_validate_option(cell_OPT,sp->str0);
	       sp=dqs_parser_get_next(sp,sp->str0);
               me.default_cell=dqs_string_insert(me.default_cell,sp->str0);
               sp=sp->next;
               continue;
          }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-cq destin_id[,destin_id,...]" */
	  
          if (!strcmp("-cq",sp->str0))
          {
               dqs_validate_option(cq_OPT,sp->str0);
               sp=dqs_parser_get_next(sp,sp->str0);
               dqs_parse_destination_id_list(&head,sp->str0,cq_OPT);
	       sp=sp->next;
               continue;
          }
          /*-----------------------------------------------------------------------------*/
          /* "-dc complex " */
	  
          if (!strcmp("-dc",sp->str0)) 
	  {	
	       
	       dqs_validate_option(ac_OPT,sp->str0);
	       sp=dqs_parser_get_next(sp,sp->str0);
	       cp=dqs_string_insert(cp,sp->str0); 
	       
	       bzero((char *)listel_ptr,sizeof(dqs_list_type));
	       listel_ptr->type=QCONF;
	       listel_ptr->int0=dc_OPT;
	       listel_ptr->str0=cp;
	       
	       head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
	       
               continue;
          }
	  
	  
          /*-----------------------------------------------------------------------------*/
          /* "-dcons consumable " */
	  
          if (!strcmp("-dcons",sp->str0)) 
	  {	
	       
	       dqs_validate_option(dcons_OPT,sp->str0);
	       sp=dqs_parser_get_next(sp,sp->str0);
	       cp=dqs_string_insert(cp,sp->str0); 
	       
	       bzero((char *)listel_ptr,sizeof(dqs_list_type));
	       listel_ptr->type=QCONF;
	       listel_ptr->int0=dcons_OPT;
	       listel_ptr->str0=cp;
	       
	       head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
	       
               continue;
          }
	  
	  
          /*-----------------------------------------------------------------------------*/
          /* "-dh server_name[,server_name,...]" */
	  
          if (!strcmp("-dh",sp->str0))
          {
               dqs_validate_option(dh_OPT,sp->str0);
               sp=dqs_parser_get_next(sp,sp->str0);
               dqs_parse_name_list(&head,sp->str0,dh_OPT);
               sp=sp->next;
               continue;
          }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-dm user_list" */
	  
          if (!strcmp("-dm",sp->str0))
          {
               dqs_validate_option(dm_OPT,sp->str0);
               sp=dqs_parser_get_next(sp,sp->str0);
               dqs_parse_name_list(&head,sp->str0,dm_OPT);
               sp=sp->next;
               continue;
          }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-do user_list" */
	  
          if (!strcmp("-do",sp->str0))
          {
               dqs_validate_option(do_OPT,sp->str0);
               sp=dqs_parser_get_next(sp,sp->str0);
               dqs_parse_name_list(&head,sp->str0,do_OPT);
               sp=sp->next;
               continue;
          }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-dq destin_id[,destin_id,...]" */
	  
          if (!strcmp("-dq",sp->str0))
          {
               dqs_validate_option(dq_OPT,sp->str0);
               sp=dqs_parser_get_next(sp,sp->str0);
	       dqs_parse_destination_id_list(&head,sp->str0,dq_OPT);
               sp=sp->next;
               continue;
          }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-du user_list list_name[,list_name,...]" */
	  
          if (!strcmp("-du",sp->str0))
          {
               dqs_validate_option(du_OPT,sp->str0);
               sp=dqs_parser_get_next(sp,sp->str0);
               if (!sp->next)
               {
                    ERROR((DQS_EVENT,"DQS_ERROR_0335 no list_name provided to \"-du %s\"",
                         sp->str0));
                    dqs_usage();
                    DEXITE;
                    exit(DQS_EINVAL);
               }
               cp=dqs_string_insert(NULL,sp->str0);
               sp=dqs_parser_get_next(sp,sp->str0);
               dqs_parse_acl_list(&head,cp,sp->str0,du_OPT);
               sp=sp->next;
               continue;
          }

          /*-----------------------------------------------------------------------------*/
          /* "-help" */
	  
          if (!strcmp("-help",sp->str0))
          {
	       dqs_usage();
	       exit(0);
	  }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-kq server_name[,server_name,...]" */
	  
          if (!strcmp("-kq",sp->str0)) 
	  {
               dqs_validate_option(kq_OPT,sp->str0);
               sp=dqs_parser_get_next(sp,sp->str0);
               dqs_parse_name_list(&head,sp->str0,kq_OPT);
               sp=sp->next;
               continue;
          }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-kqs" */
	  
          if (!strcmp("-kqs",sp->str0))
          {
               dqs_validate_option(kqs_OPT,sp->str0);
               listel_ptr->int0=kqs_OPT;
               head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
               sp=sp->next;
               continue;
          }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-mc complex_name" */
	  
          if (!strcmp("-mc",sp->str0))
          {
           cp=NULL; 
           dqs_validate_option(aq_OPT,sp->str0);
	       bzero((char *)listel_ptr,sizeof(dqs_list_type));
	       listel_ptr->type=QCONF;
	       listel_ptr->int0=gc_OPT;          /* request complex from qmaster */

	       if (!dqs_next_is_an_opt(sp))
	       {
		    sp=dqs_parser_get_next(sp,sp->str0);
		    listel_ptr->str0=dqs_string_insert(NULL,sp->str0); /* complex name */
	       }
	       else {
	       		  if (dqs_should_i_continue("Need a complex Name",NULL))
		          continue;
		   }

	       if ((sfd=dqs_send_list(me.default_cell,conf.qmaster_service,sfd,listel_ptr))<0)
	       {
		    if (dqs_should_i_continue("unable to contact qmaster",NULL))
		    continue;
	       }
	       if (dqs_get_list(sfd,&response_list))
	       {
		    if (dqs_should_i_continue("unable to get complex from qmaster",NULL))
		    continue;
	       }
	       bzero((char *)listel_ptr,sizeof(dqs_list_type));
	       listel_ptr=(dqs_list_type *)dqs_malloc(sizeof(dqs_list_type));
	       listel_ptr->type=DQS_ACK;
	       (void) dqs_send_list(NULL,NULL,sfd,listel_ptr);
	       dqs_close_sfd(sfd);
	       
	       DTRACE;            
	       if (response_list->status!=DQS_ACK)
	       {
		    DTRACE;
		    if (dqs_should_i_continue(NULL,response_list))
		    continue;
	       }

	       DTRACE;

	       cp=dqs_write_complex_list(response_list);
	       
	       if (!cp) 
	       {
		    if (dqs_should_i_continue("unable to write old queue complex to temp file",NULL))
		    continue;
	       }

               status=dqs_edit(cp);
               if (status < 0) 
               {
                    unlink(cp);
                    if (dqs_should_i_continue("complex edit failed",NULL))
                    continue;
                    
               }
               
               if (status > 0) 
               {
                    unlink(cp);
                    if (dqs_should_i_continue("complex file unchanged",NULL))
                    continue;
               }
               
               bzero((char *)listel_ptr,sizeof(dqs_list_type));
               listel_ptr->type=QCONF;
               listel_ptr->int0=mc_OPT;
               listel_ptr->str0=dqs_string_insert(NULL,sp->str0); /* complex name */               
    	       listel_ptr->chain=dqs_read_complex_file(NULL,cp);
	       if (!listel_ptr->chain)
	       {
         		    unlink(cp);
                    if (dqs_should_i_continue("error reading in complex temp file",NULL))
                    continue;
               }
               listel_ptr->int2=dqs_length_of_list(listel_ptr->chain);

	       unlink(cp);
	       dqs_showlist(listel_ptr,DQS_DEBUG|DQS_INT0|DQS_INT1|DQS_STR0|DQS_CHAIN,8);

           head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
           sp=sp->next;
           continue;
          }

	  
          /*-----------------------------------------------------------------------------*/
          /* ??? "-mconf" */
	  
          if (!strcmp("-mconf",sp->str0))
          {
               dqs_validate_option(mconf_OPT,sp->str0);
               sp=dqs_parser_get_next(sp,sp->str0);

               listel_ptr->int0=mconf_OPT;
               head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
               sp=sp->next;
               continue;
          }
          /*-----------------------------------------------------------------------------*/
          /* "-mcons  consumable_name" */
	  
          if (!strcmp("-mcons",sp->str0))
          {
           cp=NULL; 
           dqs_validate_option(aq_OPT,sp->str0);
	       bzero((char *)listel_ptr,sizeof(dqs_list_type));
	       listel_ptr->type=QCONF;
	       listel_ptr->int0=gcons_OPT;          /* request consumable from qmaster */

	       if (!dqs_next_is_an_opt(sp))
	       {
		    sp=dqs_parser_get_next(sp,sp->str0);
		    listel_ptr->str0=dqs_string_insert(NULL,sp->str0); /*consumable */
	       }
	       else {
	       		  if (dqs_should_i_continue("Need a consumable Name",NULL))
		          continue;
		   }
	       if ((sfd=dqs_send_list(me.default_cell,conf.qmaster_service,sfd,listel_ptr))<0)
	       {
		    if (dqs_should_i_continue("unable to contact qmaster",NULL))
		    continue;
	       }
	       if (dqs_get_list(sfd,&response_list))
	       {
		    if (dqs_should_i_continue("unable to get consumable from qmaster",NULL))
		    continue;
	       }
	       bzero((char *)listel_ptr,sizeof(dqs_list_type));
	       listel_ptr=(dqs_list_type *)dqs_malloc(sizeof(dqs_list_type));
	       listel_ptr->type=DQS_ACK;
	       (void) dqs_send_list(NULL,NULL,sfd,listel_ptr);
	       dqs_close_sfd(sfd);
	       
	       DTRACE;            
	       if (response_list->status!=DQS_ACK)
	       {
		    DTRACE;
		    if (dqs_should_i_continue(NULL,response_list))
		    continue;
	       }
	       DTRACE;
	       cp=dqs_write_consumable_list(response_list);
	       
	       if (!cp) 
	       {
		    if (dqs_should_i_continue("unable to write old consumable to temp file",NULL))
		    continue;
	       }
               status=dqs_edit(cp);
               if (status < 0) 
               {
                    unlink(cp);
                    if (dqs_should_i_continue("consumable edit failed",NULL))
                    continue;
               }
               
               if (status > 0) 
               {
                    unlink(cp);
                    if (dqs_should_i_continue("consumable unchanged",NULL))
                    continue;
               }
               bzero((char *)listel_ptr,sizeof(dqs_list_type));
               listel_ptr->type=QCONF;
               listel_ptr->int0=mcons_OPT;
               listel_ptr->str0=dqs_string_insert(NULL,sp->str0); /* consumable name */
    	       listel_ptr->chain=dqs_read_consumable_file(NULL,cp);
	       if (!listel_ptr->chain)
	       {
         		    unlink(cp);
                    if (dqs_should_i_continue("error reading in consumable temp file",NULL))
                    continue;
               }
               listel_ptr->int2=dqs_length_of_list(listel_ptr->chain);
	       unlink(cp);
	       dqs_showlist(listel_ptr,DQS_DEBUG|DQS_INT0|DQS_INT1|DQS_STR0|DQS_CHAIN,8);

           head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
           sp=sp->next;
           continue;
          }

	  
	  
          /*-----------------------------------------------------------------------------*/
          /*  "-mq queue" */
	  
          if (!strcmp("-mq",sp->str0))
          {
           dqs_validate_option(mq_OPT,sp->str0);

           cp=NULL; 
           
	       bzero((char *)listel_ptr,sizeof(dqs_list_type));
	       listel_ptr->type=QCONF;
	       listel_ptr->int0=sq_OPT;
	       if (!dqs_next_is_an_opt(sp))
	       {
		    sp=dqs_parser_get_next(sp,sp->str0);
		    listel_ptr->str0=dqs_string_insert(NULL,sp->str0);
	       }
	       else {
	       		  if (dqs_should_i_continue("Need a queue Name",NULL))
		          continue;
		   }

	       sp=sp->next;
	       if ((sfd=dqs_send_list(me.default_cell,conf.qmaster_service,sfd,listel_ptr))<0)
	       {
		    if (dqs_should_i_continue("unable to contact qmaster",NULL))
		    continue;
	       }
	       if (dqs_get_list(sfd,&response_list))
	       {
		    if (dqs_should_i_continue("unable to get queue from qmaster",NULL))
		    continue;
	       }
	       bzero((char *)listel_ptr,sizeof(dqs_list_type));
	       listel_ptr=(dqs_list_type *)dqs_malloc(sizeof(dqs_list_type));
	       listel_ptr->type=DQS_ACK;
	       (void) dqs_send_list(NULL,NULL,sfd,listel_ptr);
	       dqs_close_sfd(sfd);
	       DTRACE;            
	       if (response_list->status!=DQS_ACK)
	       {
		    DTRACE;
		    if (dqs_should_i_continue(NULL,response_list))
		    continue;
	       }
	       DTRACE;
	       cp=dqs_write_qconf(FALSE,NULL,NULL,response_list->queue);
	       
	       if (!cp) 
	       {
		    if (dqs_should_i_continue("unable to write old queue",NULL))
		    continue;
	       }

               status=dqs_edit(cp);
               if (status < 0) 
               {
                    unlink(cp);
                    if (dqs_should_i_continue("edit failed",NULL))
                    continue;
                    
               }
               
               if (status > 0) 
               {
                    unlink(cp);
                    if (dqs_should_i_continue("file unchanged",NULL))
                    continue;
               }
               
               bzero((char *)listel_ptr,sizeof(dqs_list_type));
               listel_ptr->type=QCONF;
               listel_ptr->int0=mq_OPT;
               listel_ptr->queue=dqs_read_in_qconf(NULL,cp);
               if (!listel_ptr->queue)
               {
                    unlink(cp);
                    if (dqs_should_i_continue("error reading in file",NULL))
                    continue;
               }
               listel_ptr->str0=dqs_string_insert(NULL,listel_ptr->queue->qname);

               unlink(cp);

               head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);

               continue;

          }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-qmon" */

          if (!strcmp("-qmon",sp->str0))
          {
               dqs_validate_option(qmon_OPT,sp->str0);
               listel_ptr->int0=qmon_OPT;
               head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
               sp=sp->next;
               continue;
          }

          /*-----------------------------------------------------------------------------*/
          /* "-refr" */

          if (!strcmp("-refr",sp->str0))
          {
               dqs_validate_option(refr_OPT,sp->str0);
               listel_ptr->int0=refr_OPT;
               head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
               sp=sp->next;
               continue;
          }

          /*-----------------------------------------------------------------------------*/
          /* "-sc complex_name_list" */
	  
          if (!strcmp("-sc",sp->str0))
          {
               dqs_validate_option(sc_OPT,sp->str0);
               sp=dqs_parser_get_next(sp,sp->str0);
               dqs_parse_name_list(&head,sp->str0,sc_OPT);
               sp=sp->next;
               continue;
          }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-scl" */
	  
          if (!strcmp("-scl",sp->str0))
          {
               dqs_validate_option(scl_OPT,sp->str0);
	       listel_ptr->type=me.who;
               listel_ptr->int0=scl_OPT;
               head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
               sp=sp->next;
               continue;
          }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-sconf [cell]" */
	  
          if (!strcmp("-sconf",sp->str0))
          {
               dqs_validate_option(sconf_OPT,sp->str0);
	       sp=sp->next;

	       if (sp)
	       {
		    if (sp->str0[0]!='-')
		    {
			 me.default_cell=dqs_string_insert(me.default_cell,sp->str0);
			 sp=sp->next;
		    }
	       }
               listel_ptr->int0=sconf_OPT;
               head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
               continue;
          }

          /*-----------------------------------------------------------------------------*/
          /* "-scons consumable_name_list" */
	  
          if (!strcmp("-scons",sp->str0))
          {
               dqs_validate_option(scons_OPT,sp->str0);
               sp=dqs_parser_get_next(sp,sp->str0);
               dqs_parse_name_list(&head,sp->str0,scons_OPT);
               sp=sp->next;
               continue;
          }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-sconsl" */
	  
          if (!strcmp("-sconsl",sp->str0))
          {
               dqs_validate_option(scl_OPT,sp->str0);
	       listel_ptr->type=me.who;
               listel_ptr->int0=sconsl_OPT;
               head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
               sp=sp->next;
               continue;
          }
	  
	  
          /*-----------------------------------------------------------------------------*/
          /* "-sh" */
	  
          if (!strcmp("-sh",sp->str0))
          {
               dqs_validate_option(sh_OPT,sp->str0);
               listel_ptr->int0=sh_OPT;
               listel_ptr->type=me.who;
               head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
               sp=sp->next;
               continue;
          }

          /*-----------------------------------------------------------------------------*/
          /* "-shutd" */

          if (!strcmp("-shutd",sp->str0))
          {
               dqs_validate_option(shutd_OPT,sp->str0);
               listel_ptr->int0=shutd_OPT;
               head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
               sp=sp->next;
               continue;
          }

          /*-----------------------------------------------------------------------------*/
          /* "-sm" */
	  
          if (!strcmp("-sm",sp->str0))
          {
               dqs_validate_option(sm_OPT,sp->str0);
               listel_ptr->type=me.who;
               listel_ptr->int0=sm_OPT;
               head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
               sp=sp->next;
               continue;
          }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-so" */
	  
          if (!strcmp("-so",sp->str0))
          {
               dqs_validate_option(so_OPT,sp->str0);
               listel_ptr->type=me.who;
               listel_ptr->int0=so_OPT;
               head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
               sp=sp->next;
               continue;
          }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-sq [destin_id[,destin_id,...]]" */
	  
          if (!strcmp("-sq",sp->str0))
          {
               dqs_validate_option(sq_OPT,sp->str0);
	       if (sp->next)
	       {
		    sp=sp->next;
		    if (strncmp("-",sp->str0,1))
		    {
			 dqs_parse_destination_id_list(&head,sp->str0,sq_OPT);
			 sp=sp->next;
			 continue;
		    }
		    else
		    {
			 listel_ptr->type=me.who;
			 listel_ptr->int0=sq_OPT;
			 head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
			 continue;
		    }
	       }
	       else
	       {
		    listel_ptr->type=me.who;
		    listel_ptr->int0=sq_OPT;
		    head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
		    sp=sp->next;
		    continue;
	       }
          }

          /*-----------------------------------------------------------------------------*/
          /* "-sql" */
	  
          if (!strcmp("-sql",sp->str0))
          {
               dqs_validate_option(sql_OPT,sp->str0);
               listel_ptr->int0=sql_OPT;
               head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
               sp=sp->next;
               continue;
          }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-su [list_name[,list_name,...]]" */
	  
          if (!strcmp("-su",sp->str0))
          {
               dqs_validate_option(su_OPT,sp->str0);
               sp=dqs_parser_get_next(sp,sp->str0);
	       dqs_parse_name_list(&head,sp->str0,su_OPT);
               sp=sp->next;
               continue;
          }
	  
          /*-----------------------------------------------------------------------------*/
          /* "-sul" */
	  
          if (!strcmp("-sul",sp->str0))
          {
               dqs_validate_option(sul_OPT,sp->str0);
               listel_ptr->int0=sul_OPT;
               head=dqs_insert(DQS_STR0,TAIL,head,listel_ptr);
               sp=sp->next;
               continue;
          }

          /*-----------------------------------------------------------------------------*/
          /* "-srl" */

          if (!strcmp("-srl",sp->str0))
          {
               dqs_validate_option(srl_OPT,sp->str0);
	       printf("Resolve list\n");
	       dqs_showlist(Resolver_head,DQS_STDOUT|DQS_STR0|DQS_STR1|DQS_STR2|DQS_STR3|DQS_CHAIN,8);
               sp=sp->next;
               continue;
          }

          /*-----------------------------------------------------------------------------*/
          /* "-huh?" */

          if (!strncmp("-",sp->str0,1)) {
               ERROR((DQS_EVENT,"DQS_ERROR_0336 invalid option argument \"%s\"",sp->str0));
               dqs_usage();
               DEXITE;
               exit(DQS_EINVAL);
          }

	  sp=sp->next;
	  
     }

     if (head)
     head->user=dqs_string_insert(NULL,me.user_name);
     
     DEXIT;
     return(head);
     
}

/***********************************************************************/
void *dqs_parse_destination_id_list(head,cp,opt)
dqs_list_type **head;
char          *cp;
int           opt;

{

     dqs_list_type listel;
     dqs_list_type *listel_ptr=NULL;
     dqs_list_type *listel_ptr2=NULL;

     DENTER((DQS_EVENT,"dqs_parse_destination_id_list"));

     dqs_parse_destination_identifier_list(&listel_ptr,cp);

     listel_ptr2=listel_ptr;
     while (listel_ptr2)
     {
	  bzero((char *)&listel,sizeof(listel));
	  listel.type=me.who;
	  listel.int0=opt;
	  listel.str0=dqs_string_insert(NULL,listel_ptr2->str0);
	  *head=dqs_insert(DQS_STR0,TAIL,*head,&listel);
	  listel_ptr2=listel_ptr2->next;
     }

     DEXIT;
     return;

}

/***********************************************************************/
void dqs_parse_name_list(head,cp,opt)
dqs_list_type **head;
char          *cp;
int           opt;

{

     char          *cp2;
     dqs_list_type listel;
     
     DENTER((DQS_EVENT,"dqs_parse_name_list"));
     
     bzero((char *)&listel,sizeof(listel));
     listel.type=me.who;
     listel.int0=opt;
     cp2=strtok(cp,",");
     listel.str0=dqs_string_insert(NULL,cp2);
     DQS_ASSERT((listel.str0));
     *head=dqs_insert(DQS_STR0,TAIL,*head,&listel);

     bzero((char *)&listel,sizeof(listel));
     while ((cp2=strtok(0,","))!=(char *)NULL) {
	  listel.str0=dqs_string_insert(NULL,cp2);
          listel.type=me.who;
          listel.int0=opt;
          DQS_ASSERT((listel.str0));
          *head=dqs_insert(DQS_STR0,TAIL,*head,&listel);
	  bzero((char *)&listel,sizeof(listel));
     } 

     DEXIT;
     return;
     
}

/***********************************************************************/
void dqs_parse_acl_list(head,users,list_names,opt)
dqs_list_type **head;
char          *users;
char          *list_names;
int           opt;

{

     char          *cp;
     string        str;
     dqs_list_type *ul=NULL;
     dqs_list_type *ll=NULL;
     dqs_list_type *tmp_ll;
     dqs_list_type listel;

     DENTER((DQS_EVENT,"dqs_parse_acl_list"));

     bzero((char *)&listel,sizeof(listel));
     cp=strtok(users,",");
     listel.str0=dqs_string_insert(NULL,cp);
     DQS_ASSERT((listel.str0));
     ul=dqs_insert(DQS_STR0,TAIL,ul,&listel);
     bzero((char *)&listel,sizeof(listel));
     while ((cp=strtok(0,","))!=(char *)NULL) {
	  listel.str0=dqs_string_insert(NULL,cp);
          DQS_ASSERT((listel.str0));
          ul=dqs_insert(DQS_STR0,TAIL,ul,&listel);
          bzero((char *)&listel,sizeof(listel));
     }

     bzero((char *)&listel,sizeof(listel));
     cp=strtok(list_names,",");
     listel.str0=dqs_string_insert(NULL,cp);
     DQS_ASSERT((listel.str0));
     ll=dqs_insert(DQS_STR0,TAIL,ll,&listel);
     bzero((char *)&listel,sizeof(listel));
     while ((cp=strtok(0,","))!=(char *)NULL) 
     {
	  listel.str0=dqs_string_insert(NULL,cp);
          DQS_ASSERT((listel.str0));
          ll=dqs_insert(DQS_STR0,TAIL,ll,&listel);
          bzero((char *)&listel,sizeof(listel));
     }

     while (ul) 
     {
	  tmp_ll=ll;
	  while (tmp_ll)
	  {
	       bzero((char *)&listel,sizeof(listel));
	       bzero((char *)str,sizeof(str));
	       sprintf(str,"%s...%s",ul->str0,tmp_ll->str0);
               listel.type=me.who;
	       listel.int0=opt;
               listel.str0=dqs_string_insert(NULL,str);
	       listel.str1=dqs_string_insert(NULL,ul->str0);
	       listel.str2=dqs_string_insert(NULL,tmp_ll->str0);
               *head=dqs_insert(DQS_STR0,TAIL,*head,&listel);
 	       listel.str0=dqs_string_insert(NULL,str);
	       tmp_ll=tmp_ll->next;
          }
          ul=ul->next;
     }

     DEXIT;
     return;

}

/***********************************************************************/
int dqs_edit(fname)
char *fname;	

{
     
     struct stat before,after;
     pid_t pid;			
     int status;			
     int ws = 0;
     
     DENTER((DQS_EVENT,"dqs_edit"));;
     
     if (stat(fname, &before)) {
	  ERROR((DQS_EVENT,"DQS_ERROR_0337 edit file %s does not exist", fname));
	  DEXITE;
	  return(-1);
     } 
     
     chown(fname,me.uid,me.gid);

     pid = fork();
     if (pid) 
     {		
	  while (ws != pid) 
	  {
	       ws = waitpid (pid, &status, 0);
	       if (WIFEXITED(status)) 
	       {
		    if (WEXITSTATUS(status) != 0) 
		    {
			 ERROR((DQS_EVENT,"DQS_ERROR_0338 editor exited with error %d",
				WEXITSTATUS(status)));
			 DEXITE;
			 return (-1);
		    } 
		    else
		    {
			 if (stat(fname, &after)) 
			 {
			      ERROR((DQS_EVENT,"DQS_ERROR_0339 edit file %s no longer exists",fname));
			      DEXIT;
			      return(-1);
			 } 
			 if ((before.st_mtime != after.st_mtime) ||
			     (before.st_size  != after.st_size)) 
			 {
			      DEXIT;			
			      return(0);
			 } 
			 else 
			 {
			      /* file is unchanged; inform caller */
			      DEXIT;
			      return(1);
			 } 
		    } 
	       } 
	       if (WIFSIGNALED(status)) 
	       {
		    ERROR((DQS_EVENT,"DQS_ERROR_0340 editor was terminated by a signal %d\n",
			   WTERMSIG(status)));
		    DEXIT;
		    return (-1);
	       } 
	  } 
     } 
     else
     {	
	  setuid(getuid());	
	  setgid(getgid());
	  
	  execlp (me.default_editor,me.default_editor, fname, (char *) 0);
	  ERROR((DQS_EVENT,"DQS_ERROR_0341 error: could not exec %s",me.default_editor));
	  exit (-1);
     } 
     
     DEXIT;
     return (-1);		
     
} 

/****************************************************************************/
int dqs_next_is_an_opt(ptr)
dqs_list_type *ptr;

{
     DENTER_EXT((DQS_EVENT,"dqs_next_is_an_opt"));
     
     if (!ptr->next)
     {
	  DEXITE;
	  return(-1);
     }
     
     if (ptr->next->str0[0]=='-')
     {
          printf("b\n");
	  
	  
	  DEXIT;
	  return(1);
     }
     
     
     DEXITE;
     return(0);
     
}

/****************************************************************************/
int dqs_should_i_continue(ptr,head)
char *ptr;
dqs_list_type *head;

{
     
     char c;
     
     DENTER_EXT((DQS_EVENT,"dqs_should_i_continue"));
     
     fflush(stderr);
     fflush(stdout);
     
     if (ptr)
     {     
	  fprintf(stderr,"\n%s\n",ptr);
	  fflush(stderr);
     }
     
     if (head)
     {
	  dqs_show_acknak_list(head);
     }
     
     fprintf(stderr,"\n    abort %s ?  y|n ",me.unqualified_prog_name);
     
     c=getc(stdin);
     if (c!='n')
     {
	  fprintf(stderr,"aborting %s\n",me.unqualified_prog_name);
	  fflush(stderr);
	  DEXITE;
	  exit(-1);
     }

     /* this should be removed - but first I got to clean up some stuff */
     fprintf(stderr,"sorry but I've just got to abort\n");
     fflush(stderr);
     DEXITE;
     exit(-1);
 
     
/*     c=getc(stdin);
     
     DEXIT;
     return(1);
*/
     
     
}

/****************************************************************************/
char *dqs_write_complex_template(ptr)
dqs_list_type *ptr;


{
     
     char *str;
     char *cp;
     FILE *fp;
     
     DENTER_EXT((DQS_EVENT,"dqs_write_complex_template"));
     str=dqs_malloc(MAX_STRING_SIZE);
     
     cp=(char *)tmpnam(str);
     
     if (!cp)
     {
	  ERROR((DQS_EVENT,"DQS_ERROR_0342 error generating tempoary file name"));
	  DEXITE;
	  return(NULL);
     }
     
     fp = fopen(cp,"w");
     if (!fp) {
	  ERROR((DQS_EVENT,"DQS_ERROR_0343 error opening %s for writing",cp));
	  DEXITE;
	  return(NULL);
     }
     
     while (ptr)
     {
	  fprintf(fp,"%s",ptr->str0);
	  if (ptr->int0)
	  fprintf(fp,"=%d",ptr->int0);
	  fprintf(fp,"\n");
	  ptr=ptr->next;
     }
     
     fclose(fp);
     
     chown(cp,me.uid,me.gid);
     chmod(cp,0700);
     
     DEXIT;
     return(cp);
     
}

/*********************************************************************/
/*
   ex: 
   mem=5
   group=ibm
   arc=RIOS
   pvm

   here's what we're gonna do:

   each "resource_group" will consist of a "chain" with the head->str0
   being the "complex_name".

   listel.str0="complex_name"
   listel.int1=chain_length
   listel.chain=chained_element->
                                 resource[=field][,resource[=field],...]
                                 str0 - resource
                                 str1 - [field]
                                 int0 - [qty]
                                 int1 - [op]
                                 next->
                                        resource[=field][,resource[=field],...]
                                        str0 - resource
                                        str1 - [field]
                                        int0 - qty
                                        int1 - [op]
                                        next->
                                              ...
    listel.next
    :
    :
    NULL

   */
 
dqs_list_type *dqs_read_complex_file(prefix,fname)
char *prefix;
char *fname;

{
     
     FILE *fp;
     char c;
     char *resource;
     char *resource_field;
     string str;
     string file_name;
     dqs_list_type listel;
     dqs_list_type *head=NULL;
     
     DENTER((DQS_EVENT,"dqs_read_complex_file"));
     
     bzero((char *)file_name,sizeof(file_name));
     if (prefix)
     {
	  sprintf(file_name,"%s/%s",prefix,fname);
     }
     else
     {
	  sprintf(file_name,"%s",fname);
     }
     
     head=NULL;
     
     fp=fopen(file_name,"r");
     
     if (!fp)
     {
          ERROR((DQS_EVENT,"DQS_ERROR_0344 error opening %s for reading",file_name));
          DEXITE;
	  
          return(NULL);
     }
     
     while (fscanf(fp,"%[^\n]",str)!=EOF)
     {
          if ((str[0]==' ') || (str[0]=='\0') )
	  {
	       c=getc(fp);
          
               if ((unsigned char)c==255) break;
	       continue;
	  }
	  
	  bzero((char *)&listel,sizeof(listel));
	  listel.str3=dqs_string_insert(NULL,str);
	  resource=dqs_strtok(str,"=");
	  DQS_ASSERT((resource));
	  listel.str0=dqs_string_insert(NULL,resource);
	  resource_field=dqs_strtok((char *)0,"=");
	  
	  if (resource_field)
	  {
               if (!dqs_is_int(resource_field))
               {
                    DTRACE;
                    listel.int0=dqs_atoi(resource_field);
		    if (listel.int0<=0)
		    {
			 ERROR((DQS_EVENT,
				"invalid resource_field \"%s\" in \"%s\"",
				resource,resource_field));
			 dqs_free_list(head);
			 DEXITE;
			 return(NULL);
		    }

               }
               else 
               {
		    listel.str1=dqs_string_insert(NULL,resource_field);
               }
	       listel.int1=EQ_OP;
	  }
      str[0]='\0';          /*ensure proper handling of empty line */
          head=dqs_insert(DQS_STR0,TAIL,head,&listel);     	  


          c=getc(fp);
          if ((unsigned char)c==255) break;
     }
     fclose(fp);
     DEXIT;
     return(head);
     
}

/*********************************************************************/

dqs_list_type *dqs_read_consumable_file(prefix,fname)
char *prefix;
char *fname;

{
     
     FILE *fp;
     char c;
     char *infstat;
     char *resource;
     char *resource_field;
     string str;
     string file_name;
     dqs_list_type listel;
     dqs_list_type *head=NULL;
     int found_available, found_by, found_current;
     int value;
     
     DENTER((DQS_EVENT,"dqs_read_consumable_file"));

/*
     Consumable file contain the following entries:

     consumable  <name>                   ->str0
     available= <amount of resource>      ->int0
     consume_by= <amount to reduce by>    ->int1
     current=  <current state of resource>->int2
*/
     found_available=0;
     found_by=0;
     found_current=0;
     
     bzero((char *)file_name,sizeof(file_name));
     if (prefix){
	  sprintf(file_name,"%s/%s",prefix,fname);
     }
     else{
	  sprintf(file_name,"%s",fname);
     }
     head=NULL;
     fp=fopen(file_name,"r");
     if (!fp) {
          ERROR((DQS_EVENT,"DQS_ERROR_0345 error opening %s for reading",file_name));
          DEXITE;
          return(NULL);
     }
     
     bzero((char *)&listel,sizeof(listel));     
     listel.int0= -1;
     listel.int1= -1;
     listel.int2= -1;
     do{
        infstat= fgets(str, MAX_STRING_SIZE, fp);
        if(!infstat) break;
        
     	resource=strtok(str,"= ");
        if(!resource) continue;
        
	    resource_field=strtok(NULL,"= \n");
        if (!resource_field) continue;
DPRINTF((DQS_EVENT,"read consumable >%s< >%s< >%s<",
                                  str,resource, resource_field));
        if(!strncmp(resource,"consumable",10) ){
        	/* consumable name  */
        	listel.str0= dqs_string_insert(NULL, resource_field);
        	continue;
        }
               
        if (!dqs_is_int(resource_field))value=dqs_atoi(resource_field);
          else{
         	 ERROR((DQS_EVENT,
		"invalid consumable value \"%s\" in \"%s\"",
		 resource,resource_field));
		 dqs_free_list(head);
		 DEXITE;
		 return(NULL);
	  }

	  if (!strncmp(resource,"avail",5)){
                found_available=1;
                listel.int0= value;
          }
      if (!strncmp(resource,"cons",4)){
                found_by=1;
                listel.int1= value;
 	  }
      if (!strncmp(resource,"curr",4)){
          	found_current=1;
          	listel.int2= value;
	  }

     } while (infstat);

DPRINTF((DQS_EVENT,"avail=%d cons=%d curr=%d",found_available, found_by, found_current));
     if( found_available & found_by & found_current){     
         head=dqs_insert(DQS_STR0,TAIL,head,&listel);     
         fclose(fp);
         DEXIT;
         return(head);
     } 
    DEXITE;
    return(NULL); 
}


