static char cluster_rcsid[]="$Id";
/**********************************************************
 * globals.h - definitions for qmon
 *
 * Written By: Lakhamraju R. Raju
 * Date: 11/03/93
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *
 *  cluster.c,v
 * Revision 1.2  1994/11/28  16:54:40  kerce
 * *** empty log message ***
 *
 * Revision 1.4  1994/09/13  18:01:59  raju
 * *** empty log message ***
 *
 * Revision 1.3  1994/08/21  02:56:58  raju
 * *** empty log message ***
 *
 **********************************************************/

#include "globals.h"
#include "qmonerrs.h"

static Widget           cluster_popup;
static Widget           widget_clusterrc;
static Widget           widget_clusterlabel;
static Widget           widget_clusterframe;
static Widget           widget_clustermenu;
static Widget           widget_clustermain;
static Widget           widget_clusterexec;
static Widget           widget_clusterclear;
static Widget           widget_clusterclose;
static Widget           widget_clusterseparator;
static Widget           widget_clusteropt;

struct optionstruct clustermenu[]={
  0,"version        ",NULL,INPUTTYPE,NULL,NULL,
  0,"spool_dir      ",NULL,INPUTTYPE,NULL,NULL,
  0,"execd_spool_dir",NULL,INPUTTYPE,NULL,NULL,
  0,"qmaster        ",NULL,INPUTTYPE,NULL,NULL,
  0,"xterm          ",NULL,INPUTTYPE,NULL,NULL,
  0,"mailer         ",NULL,INPUTTYPE,NULL,NULL,
  0,"shell          ",NULL,INPUTTYPE,NULL,NULL,
  0,"min_gid        ",NULL,INPUTTYPE,NULL,NULL,
  0,"min_uid        ",NULL,INPUTTYPE,NULL,NULL,
  0,"maxujobs       ",NULL,INPUTTYPE,NULL,NULL,
  0,"dqs_bin        ",NULL,INPUTTYPE,NULL,NULL,
  0,"administrator  ",NULL,INPUTTYPE,NULL,NULL,
  0,"default_group  ",NULL,INPUTTYPE,NULL,NULL,
  0,"user_access    ",NULL,INPUTTYPE,NULL,NULL,
  0,"default_rerun  ",NULL,INPUTTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};


/***********************************************************
 * pb_clusterexec - Activate callback for exec
 */
XtCallbackProc pb_clusterexec(Widget w,caddr_t client_data,caddr_t call_data)
{
  char            command[MAX_STRING_SIZE];
  char            errmsg[MAX_STRING_SIZE];
  char            tmpfilename[MAX_STRING_SIZE];
  char            *ptr;
  int             ii;
  FILE            *fp;

  tmpnam(tmpfilename);
  if(!(fp=fopen(tmpfilename,"w"))) {
    sprintf(errmsg,ERROR_108,tmpfilename);
    logerr(errmsg);
    return;
  }

  for(ii=0;clustermenu[ii].name;ii++) {
    ptr=QmonTextGetString(clustermenu[ii].widgetid);
    fprintf(fp,"%s\t%s\n",clustermenu[ii].name,ptr);
  }

  fclose(fp);

  sprintf(command,"%s -cell %s -MC %s",QCONF_BINARY,current_cell,tmpfilename);
  execit(command);
  sleep(1);
  unlink(tmpfilename);
  refreshicons();
}
 


/***********************************************************
 * pb_clusterclear - Activate callback for clear
 */
XtCallbackProc pb_clusterclear(Widget w,caddr_t client_data,caddr_t call_data)
{
  char            buffer[MAX_STRING_SIZE];
  char            command[MAX_STRING_SIZE];
  char            str1[MAX_STRING_SIZE];
  char            str2[MAX_STRING_SIZE];
  int             ii;
  FILE            *pfp;
  
  /*
   * We need to fill in the options with the default
   * values from qconf -sc
   */
  sprintf(command,"%s -cell %s -sc",QCONF_BINARY,current_cell);
  pfp=popen(command,"r");
  if(pfp) {
    ii=0;
    while(fgets(buffer,MAX_STRING_SIZE,pfp)) {
      sscanf(buffer,"%s %s",str1,str2);
      QmonTextSetString(clustermenu[ii].widgetid,str2);
      ii++;
    }
    pclose(pfp);
  }
  else {
    logerr("openwidget_clustersub: cannot do qconf -sc");
  }
}


/*
 * pb_clusterclose - Activate callback for close
 */
XtCallbackProc pb_clusterclose(Widget w,caddr_t client_data,caddr_t call_data)
{
  closesubmenuwin();
}


/***********************************************************
 * clusteraction - Activate callback for action type menu
 */
XtCallbackProc clusteraction(Widget w,caddr_t client_data,caddr_t call_data)
{
  int             ii;
  char            command[MAX_STRING_SIZE];

  for(ii=0;clustermenu[ii].name;ii++) {
    if(w==clustermenu[ii].widgetid) {
      sprintf(command,"%s -cell %s %s &",QCONF_BINARY,current_cell,clustermenu[ii].flag);
      execit(command);
      break;
    }
  }
}


/***********************************************************
 * create_cluster - Create widgets used for the cluster menu
 */
void create_cluster_dialog(Widget w,XtPointer client_data,XtPointer  call_data)
{
  int             ii;
  Arg             args[32];
  Widget        cluster_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec,clear,close;

  create_sorry_dialog(w,NULL,NULL);

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  cluster_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w, args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  cluster_form = XtCreateManagedWidget("form", formWidgetClass, cluster_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_clusterlabel=
        XtCreateManagedWidget("Configure Cluster",labelWidgetClass,cluster_form,args
,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_clusterlabel); ii++;
  widget_clustermain=XtCreateManagedWidget("box",formWidgetClass,cluster_form,
                                        args,ii);

 exec=QmonAddButtonN(widget_clustermain,NULL,"Exec",(XtCallbackProc)pb_clusterexec,NULL);
/*
 exec=QmonAddButtonN(widget_clustermain,NULL,"Exec",NULL,NULL);
 */
 clear=QmonAddButtonN(widget_clustermain,exec,"Clear",(XtCallbackProc)pb_clusterclear,NULL);
 close=QmonAddButtonN(widget_clustermain,clear,"Close",(XtCallbackProc)pb_clusterclose,NULL);


  widget_clusteropt=createmenuoptions(cluster_form,widget_clustermain,clustermenu,(XtCallbackProc)clusteraction);
  
}


/***********************************************************
 * openwidget_clustersub - Open the cluster menu
 */
void openwidget_clustersub(Widget w,XtPointer client_data,XtPointer  call_data)
{
  char            buffer[MAX_STRING_SIZE];
  char            command[MAX_STRING_SIZE];
  char            str1[MAX_STRING_SIZE];
  char            str2[MAX_STRING_SIZE];
  int             ii;
  FILE            *pfp;
  
  XtPopup(cluster_popup,XtGrabNone);;
  
  /*
   * We need to fill in the options with the default
   * values from qconf -sc
   */
  sprintf(command,"%s -cell %s -sc",QCONF_BINARY,current_cell);
  pfp=popen(command,"r");
  if(pfp) {
    ii=0;
    while(fgets(buffer,MAX_STRING_SIZE,pfp)) {
      sscanf(buffer,"%s %s",str1,str2);
      QmonTextSetString(clustermenu[ii].widgetid,str2);
      ii++;
    }
    pclose(pfp);
  }
  else {
    logerr("openwidget_clustersub: cannot do qconf -sc");
  }
}


/***********************************************************
 * closewidget_clustersub - Close the cluster menu
 */
void closewidget_clustersub()
{
  XtPopdown(cluster_popup);
}



