///////////////////////////////////////////////////////////////////////////////
// $Id: BasicWidget.hxx,v 1.1 1995/01/12 02:09:17 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// BasicWidget.hxx - Abstract base class for all widgets
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 11,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: BasicWidget.hxx,v $
// Revision 1.1  1995/01/12  02:09:17  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef BASICWIDGET_HXX
#define BASICWIDGET_HXX

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "Sprite.hxx"

class ContainerWidget;
class UIApplication;

// Enumerated type for widget's manage state
enum ManageState { Managed, Unmanaged };


class BasicWidget {
  private:
    int myX;                            // My X Coordinate relative to parent
    int myY;                            // My Y Coordinate relative to parent
    int myWidth;                        // My width in pixels
    int myHeight;                       // My height in pixels
    const char *const myName;           // My symbolic name
    ManageState myManageState;          // Indicates what state I'm in

  protected:
    unsigned long myForeground;         // My foreground color
    unsigned long myBackground;         // My background color
    unsigned long myBackgroundHigh;     // My background highlight color 
    unsigned long myBackgroundLow;      // My background lowlight color
    ContainerWidget *const myParent;    // A reference to my parent widget
    Window myWindow;                    // My only visual being

    // Protected constructor to prevent instantiation
    BasicWidget(ContainerWidget *const parent, const char *const name,
        int x, int y, int width, int height);

    // UIApplication needs access to the handleEvent and findWidget methods
    friend UIApplication;

    // ContainerWidget needs access to the findWidget method
    friend ContainerWidget;

    // Called whenever an event arrives for me
    virtual void handleEvent(XEvent* event);

    // Find the widget for the given window
    virtual BasicWidget* findWidget(Window window);

  public:
    virtual ~BasicWidget();

    // Manage the entire widget subtree that I represented
    virtual void manage();

    // Unmanage the entire widget subtree that I represented
    virtual void unmanage();

    // Answer my manage state
    const ManageState manageState() { return myManageState; }

    // Answer my name
    const char* name() const { return myName; }

    // Answer my window
    const Window window() const { return myWindow; }

    // Set my background to the named color
    virtual void background(const char* name);

    // Set my background to the given sprite
    virtual void background(const Sprite *const sprite);

    // Set my foreground to the named color
    virtual void foreground(const char* name);

    // Resize myself to the given width and height
    void resize(int width, int height);
 
    // Move myself to the given x and y location
    void move(int x, int y);

    unsigned long background() const { return myBackground; }
    unsigned long backgroundHigh() const { return myBackgroundHigh; }
    unsigned long backgroundLow() const { return myBackgroundLow; }
    unsigned long foreground() const { return myForeground; }
    int x() const { return myX; }
    int y() const { return myY; }
    int width() const { return myWidth; }
    int height() const { return myHeight; }

    // Answer my class
    virtual const char *const className() const { return("BasicWidget"); }
};
#endif

