//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

/**
  Object of this class are used to represent 4K cartridges.

  @author  Bradford W. Mott
  @version $Id: Cart4K.cxx,v 1.2 1997/05/17 19:00:03 bwmott Exp $
*/

#include "Cart4K.hxx"
#include "System.hxx"

//============================================================================
// Constructor
//============================================================================
Cartridge4K::Cartridge4K(System& system, uByte* image)
    : Cartridge(system),
      myImageOffset(0)
{
  // Copy the ROM image into my buffer
  for(uWord addr = 0; addr < 4096; ++addr)
    myImage[addr] = image[addr];

  // Map all of my addresses in the system
  for(uWord address = 0; address < 8192; ++address)
  {
    if(address & 0x1000)
    {
      mySystem.mapPeek(address, *this, 
          &myImage[address & 0x0fff], &myImageOffset);
      mySystem.mapPoke(address, *this);
    }
  }
}
 
//============================================================================
// Destructor
//============================================================================
Cartridge4K::~Cartridge4K()
{
}

//============================================================================
// Answer the byte at the given address
//============================================================================
uByte Cartridge4K::peek(uWord addr)
{
  return myImage[addr & 0x0fff];
}

//============================================================================
// Reset to my power on state
//============================================================================
void Cartridge4K::reset()
{
  myImageOffset = 0;
}
 
