//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

/**
  Controls the console switches for the system.

  @author  Bradford W. Mott
  @version $Id: Console.cxx,v 1.2 1997/05/17 19:00:05 bwmott Exp $
*/

#include <string.h>
#include "Console.hxx"
#include "System.hxx"
#include "BasTerm.hxx"

//============================================================================
// Constructor
//============================================================================
Console::Console(System& system)
    : mySystem(system)
{
  myTimer = 0;
  mySwitches = 0xff;

  if(strcmp(mySystem.properties().find("Console.RightDifficulty"), "B") == 0)
    mySwitches &= ~0x80;
  else
    mySwitches |= 0x80;  

  if(strcmp(mySystem.properties().find("Console.LeftDifficulty"), "B") == 0)
    mySwitches &= ~0x40;
  else
    mySwitches |= 0x40;  

  if(strcmp(mySystem.properties().find("Console.TelevisionType"), "Color") == 0)
    mySwitches |= 0x08;
  else
    mySwitches &= ~0x08;  
}
 
//============================================================================
// Destructor
//============================================================================
Console::~Console()
{
}

//============================================================================
// Update the console switches
//============================================================================
void Console::update()
{
  if(mySystem.terminal().eventState(BasicTerminal::Color))
    mySwitches |= 0x08;
  else if (mySystem.terminal().eventState(BasicTerminal::BlackAndWhite))
    mySwitches &= ~0x08;

  if(mySystem.terminal().eventState(BasicTerminal::RightDifficultyA))
    mySwitches &= ~0x80;
  else if(mySystem.terminal().eventState(BasicTerminal::RightDifficultyB))
    mySwitches |= 0x80;

  if(mySystem.terminal().eventState(BasicTerminal::LeftDifficultyA))
    mySwitches &= ~0x40;
  else if(mySystem.terminal().eventState(BasicTerminal::LeftDifficultyB))
    mySwitches |= 0x40;

  if(mySystem.terminal().eventState(BasicTerminal::Select))
  {
    mySwitches &= ~0x02;
    myTimer = 4;
  }

  if(mySystem.terminal().eventState(BasicTerminal::Reset))
  {
    mySwitches &= ~0x01;
    myTimer = 4;
  }

  // See if it's time to release the levers yet
  if(myTimer > 0)
    --myTimer;
  else
    mySwitches |= 0x03;
}


