//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

/**
  The 2600's joystick controller.

  @author  Bradford W. Mott
  @version $Id: Joystick.cxx,v 1.2 1997/05/17 19:00:05 bwmott Exp $
*/

#include "BasTerm.hxx"
#include "Joystick.hxx"
#include "System.hxx"

//============================================================================
// Constructor
//============================================================================
Joystick::Joystick(const System& system, Joystick::PhysicalPort port)
    : Controller(system),
      myPort(port)
{
}
 
//============================================================================
// Destructor
//============================================================================
Joystick::~Joystick()
{
}

//============================================================================
// Invoked before each frame is generated
//============================================================================
void Joystick::update()
{
  if(myPort == Zero)
  {
    if(mySystem.terminal().eventState(BasicTerminal::LeftJoystickFire))
    {
      // Clear the fire button bit
      myTIA &= 0x03;
    }
    else
    {
      // Set the fire button bit
      myTIA |= 0x04;
    }

    // Joystick Right
    if(mySystem.terminal().eventState(BasicTerminal::LeftJoystickRight))
      myPIA &= 0x07;
    else
      myPIA |= 0x08;

    // Joystick Left
    if(mySystem.terminal().eventState(BasicTerminal::LeftJoystickLeft))
      myPIA &= 0x0b;
    else
      myPIA |= 0x04;

    // Joystick Down
    if(mySystem.terminal().eventState(BasicTerminal::LeftJoystickDown))
      myPIA &= 0x0c;
    else
      myPIA |= 0x02;

    // Joystick Up
    if(mySystem.terminal().eventState(BasicTerminal::LeftJoystickUp))
      myPIA &= 0x0e;
    else
      myPIA |= 0x01;
  }
  else
  {
    if(mySystem.terminal().eventState(BasicTerminal::RightJoystickFire))
    {
      // Clear the fire button bit
      myTIA &= 0x03;
    }
    else
    {
      // Set the fire button bit
      myTIA |= 0x04;
    }

    // Joystick Right
    if(mySystem.terminal().eventState(BasicTerminal::RightJoystickRight))
      myPIA &= 0x07;
    else
      myPIA |= 0x08;

    // Joystick Left
    if(mySystem.terminal().eventState(BasicTerminal::RightJoystickLeft))
      myPIA &= 0x0b;
    else
      myPIA |= 0x04;

    // Joystick Down
    if(mySystem.terminal().eventState(BasicTerminal::RightJoystickDown))
      myPIA &= 0x0c;
    else
      myPIA |= 0x02;

    // Joystick Up
    if(mySystem.terminal().eventState(BasicTerminal::RightJoystickUp))
      myPIA &= 0x0e;
    else
      myPIA |= 0x01;
  }
}

//============================================================================
// Configure the TIA part of the controller
//============================================================================
void Joystick::configureTIA(Controller::TIACommand)
{
  // TODO: I guess we should really do something if we receive
  //       the latch enable or disable command
}


