//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef SOUNDUNIX_HXX
#define SOUNDUNIX_HXX

#include "machine.hxx"
#include "Snd.hxx"

/**
  This class implements the sound API for the Unix operating system.
  Under Unix the real work of the sound system is in another process
  called "stella-sound".  This process is started when an instance 
  of the SoundUnix class is created.  Communicattion with the 
  "stella-sound" process is done through a pipe.

  @author  Bradford W. Mott
  @version $Id: SndUnix.hxx,v 1.2 1997/05/17 19:00:07 bwmott Exp $
*/
class SoundUnix : public Sound
{
  public:
    /// Constructor
    SoundUnix();
 
    /// Destructor
    virtual ~SoundUnix();

  public: 
    /// Set the given sound register to the specified value
    virtual void set(Sound::Register reg, uByte value);

  private:
    // Indicates if the sound system couldn't be initialized
    bool myDisabled;

    // Process Id of the stella-sound process
    int myProcessId;

    // Write file descriptor for IPC
    int myFd;

    // Buffers for the audio registers used so we only 
    // send "changes" to the stella-sound process
    uByte myAUDC0;
    uByte myAUDC1;
    uByte myAUDF0;
    uByte myAUDF1;
    uByte myAUDV0;
    uByte myAUDV1;
};
#endif

