#include <sys/soundcard.h>
#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include "mp3info.h"
#include <termio.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>

static int decpid;
static int decinpipe;

static int dsp_speed, dsp_stereo;
static int samplesize;
static int audio;

static char audio_name[20] = AUDIO;

static int canplay,lastsig;

int initpipe(void) {
   int dec_inpipe[2];
   int devnull;
   
   devnull=open("/dev/null",O_WRONLY);
   
   if (pipe(dec_inpipe)!=0) {
      return(0);
   }
   
   if ((decpid = fork()) == 0) {
      close(dec_inpipe[1]); 
      dup2(dec_inpipe[0], fileno(stdin));
      close(dec_inpipe[0]);
      
      dup2(audio,fileno(stdout));
      dup2(devnull,fileno(stderr));
      
      execlp(DECODER, DECODER, DECODEOPTS, NULL);
      fprintf(stderr, "Error: Decoder failed.\n");
      exit(1);
   }
   
   close(dec_inpipe[0]);
   decinpipe = dec_inpipe[1];
   close(devnull);
   return(1);
}


int initsound() {
   int tmp;
   
   audio = open (audio_name, O_WRONLY, 0);
   
   if (audio == -1) {
      perror (audio_name);
      return(0);
   }
   
   tmp = 0x7FFF000C;
   if (ioctl(audio, SNDCTL_DSP_SETFRAGMENT, &tmp)) {
      fprintf(stderr,"Error: Unable to optimize fragment size.\n");
   }
   
   tmp = samplesize;
   ioctl(audio, SNDCTL_DSP_SAMPLESIZE, &samplesize);
   
   if (tmp != samplesize) {
      fprintf(stderr, "Error: Unable to set the sample size.\n");
      return(0);
   }
   
   if (ioctl (audio, SNDCTL_DSP_STEREO, &dsp_stereo)==-1)     {
      fprintf (stderr, "Error: Unable to set mono/stereo.\n");
      perror (audio_name);
      return(0);
   }
   
   if (ioctl (audio, SNDCTL_DSP_SPEED, &dsp_speed) == -1)     {
      fprintf (stderr, "Error: Unable to set audio speed.\n");
      perror (audio_name);
      return(0);
   }
   
   ioctl (audio, SNDCTL_DSP_GETBLKSIZE, &tmp);
   if (tmp!=4096) {
      fprintf (stderr, "Error: Fragment size is not 4096.\n");
   }     
   return(1);
}

void end(int wait) {
   if (decpid) {
      if (wait) ioctl(audio,SNDCTL_DSP_POST,0);
      close(decinpipe);
      if (wait) ioctl(audio, SNDCTL_DSP_SYNC, 0);
      kill(decpid, SIGKILL);
      close(audio);
      decpid = 0;
      decinpipe = 0;
   }
}

void sighandler(int sig) {
   canplay=0;
   lastsig=sig;
   return;
}

bool Mpfile::play(int threads) {
   char buffer[PLAY_BUF_LEN];
   size_t size;
   struct sigaction sigstruc;
   
   dsp_speed=layer->sfreq();
   samplesize=16;
   if (layer->stereo) dsp_stereo=1;
   else dsp_stereo=0;
   if (!initsound()) {
      fprintf(stderr,"Error: Failed to init sound device.\n");
      return(0);
   }
   if (!initpipe()) {
      fprintf(stderr,"Error: Failed to open Decoder Pipe.\n");
      return(0);
   }
   
#ifdef L3UNREG
   write(decinpipe,"N",1);
#endif
   
   canplay=1;
   lastsig=0;

   sigstruc.sa_handler=sighandler;
   memset(&sigstruc.sa_mask,0,sizeof(sigstruc.sa_mask));
   sigstruc.sa_flags=SA_RESTART;

   sigaction(SIGHUP,&sigstruc,NULL);
   sigaction(SIGTERM,&sigstruc,NULL);
   signal(SIGCHLD,SIG_IGN);

   fseek(file,0,SEEK_SET);
   while ((size=fread(&buffer,1,PLAY_BUF_LEN,file)) && canplay) {
      write(decinpipe,&buffer,size);
   }
   end(canplay);
   if (lastsig==SIGTERM) exit(0);
   return(1);
}
