
import java.sql.*;




/**
 * Test commits and rollbacks to the database.
 */
public class t0010
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException, java.lang.Exception
   {
      boolean  passed = true;


      System.out.println("Test commits and rollbacks to the database.");


      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      int         i;
      int         j;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();
      ResultSet   rs       = null;


      try
      {
         stmt.executeUpdate("drop table t0010");
      }
      catch (SQLWarning e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0010', " +
                                      "because it does")))
         {
            throw e;
         }
      }

      count = stmt.executeUpdate("create table t0010              "
                                 + "  (i  integer  not null,      "
                                 + "   s  char(10) not null)      ");
      System.out.println("Creating table affected " + count + " rows");


      cx.setAutoCommit(false);

      PreparedStatement pStmt = cx.prepareStatement(
         "insert into t0010 values (?, ?)");

      int rowsToAdd = 8;
      final String theString = "abcdefghijklmnopqrstuvwxyz";
      count = 0;
      for(i=1; i<=rowsToAdd; i++)
      {
         pStmt.setInt(1, i);
         pStmt.setString(2, theString.substring(0, i));

         count += pStmt.executeUpdate();
      }
      cx.rollback();

      stmt = cx.createStatement();
      rs = stmt.executeQuery("select s, i from t0010");
      count = 0;
      while(rs.next())
      {
         System.out.println(rs.getString("i") + ":" +
                            rs.getString("s"));
         count ++;
      }
      passed = passed && (count==0);
      if (!passed)
      {
         throw new SQLException("failed.  count was " + count);
      }
      cx.commit();


      for(j=1; j<=2; j++)
      {
         rowsToAdd = 6;
         count = 0;
         for(i=1; i<=rowsToAdd; i++)
         {
            pStmt.setInt(1, i+((j-1)*rowsToAdd));
            pStmt.setString(2, theString.substring(0, i));
            
            count += pStmt.executeUpdate();
         }
         cx.commit();
      }

      rs = stmt.executeQuery("select s, i from t0010");
      count = 0;
      while(rs.next())
      {
         System.out.println(rs.getString("i") + ":" +
                            rs.getString("s"));
         count++;
      }
      passed = passed && (count==12);
      if (!passed)
      {
         throw new SQLException("failed. count was " + count);
      }
      cx.close();

      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0010.\n");
      System.exit(passed ? 0 : 1);
   }
}


