
import java.sql.*;


/**
 * Test getBoolean() 
 *
 */
public class t0031
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException 
   {
      boolean   passed = true;


      System.out.println("Starting test t0031-  test text columns");


      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();

      try
      {
         stmt.executeUpdate("drop table t0031");
      }
      catch (SQLWarning e)
      {
         String okayError = "Cannot drop the table";

         if (! (e.getMessage().startsWith(okayError)))
         {
            throw e;
         }
      }
    
      count = stmt.executeUpdate("create table t0031                " +
                                 "  (t_nullable      text null,     " +
                                 "   t_notnull       text not null, " +
                                 "   i               int not null)  ");
      System.out.println("Creating table affected " + count + " rows");

      stmt.executeUpdate("insert into t0031 values(null, '',   1)");
      stmt.executeUpdate("insert into t0031 values(null, 'b1', 2)");
      stmt.executeUpdate("insert into t0031 values('',   '',   3)");
      stmt.executeUpdate("insert into t0031 values('',   'b2', 4)");
      stmt.executeUpdate("insert into t0031 values('a1', '',   5)");
      stmt.executeUpdate("insert into t0031 values('a2', 'b3', 6)");

    
      ResultSet  rs = stmt.executeQuery("select * from t0031 " +
                                        " order by i ");
      

      
      if (!rs.next())
      {
         throw new SQLException("Failed");
      }
      passed = passed && (rs.getString(1) == null);
      passed = passed && (rs.getString(2).equals(""));
      passed = passed && (rs.getInt(3) == 1);

      if (!rs.next())
      {
         throw new SQLException("Failed");
      }
      passed = passed && (rs.getString(1) == null);
      passed = passed && (rs.getString(2).equals("b1"));
      passed = passed && (rs.getInt(3) == 2);

      if (!rs.next())
      {
         throw new SQLException("Failed");
      }
      passed = passed && (rs.getString(1).equals(""));
      passed = passed && (rs.getString(2).equals(""));
      passed = passed && (rs.getInt(3) == 3);

      if (!rs.next())
      {
         throw new SQLException("Failed");
      }
      passed = passed && (rs.getString(1).equals(""));
      passed = passed && (rs.getString(2).equals("b2"));
      passed = passed && (rs.getInt(3) == 4);

      if (!rs.next())
      {
         throw new SQLException("Failed");
      }
      passed = passed && (rs.getString(1).equals("a1"));
      passed = passed && (rs.getString(2).equals(""));
      passed = passed && (rs.getInt(3) == 5);

      if (!rs.next())
      {
         throw new SQLException("Failed");
      }
      passed = passed && (rs.getString(1).equals("a2"));
      passed = passed && (rs.getString(2).equals("b3"));
      passed = passed && (rs.getInt(3) == 6);

      
     System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0031.\n");
      System.exit(passed ? 0 : 1);
   }
}

