#include "NativeTest.h"

jclass Sclazz =0;
jfieldID SfieldX, SfieldY, SfieldZ;

JNIEXPORT void JNICALL Java_NativeTest_instanceAddNativeFast
  (JNIEnv *env, jobject obj)
{
	if (!Sclazz)
	{
		Sclazz = (*env)->GetObjectClass(env,obj);
		SfieldX = (*env)->GetFieldID(env,Sclazz,"x","I");
		SfieldY = (*env)->GetFieldID(env,Sclazz,"y","I");
		SfieldZ = (*env)->GetFieldID(env,Sclazz,"z","I");

	}	

	(*env)->SetIntField(env,obj,SfieldZ, 
				(
					(*env)->GetIntField(env,obj,SfieldX) +
					(*env)->GetIntField(env,obj,SfieldY)
				)
			);
	return;
}


JNIEXPORT void JNICALL Java_NativeTest_instanceAddNativeSlow
  (JNIEnv *env, jobject obj)
{
	jclass clazz;
	jfieldID fieldX, fieldY, fieldZ;
	clazz = (*env)->GetObjectClass(env,obj);
	fieldX = (*env)->GetFieldID(env,clazz,"x","I");
	fieldY = (*env)->GetFieldID(env,clazz,"y","I");
	fieldZ = (*env)->GetFieldID(env,clazz,"z","I");
	(*env)->SetIntField(env,obj,fieldZ, 
				(
					(*env)->GetIntField(env,obj,fieldX) +
					(*env)->GetIntField(env,obj,fieldY)
				)
			);
	return;
}

JNIEXPORT void JNICALL Java_NativeTest_emptyNative
  (JNIEnv *env, jobject obj)
{
}



JNIEXPORT jint JNICALL Java_NativeTest_addNative
  (JNIEnv *env, jclass cl, jint x, jint y)
{
	return x+y;
}
