public class NativeTest
{
	int x =1;
	int y =2;
	int z;

	static {
		System.loadLibrary("NativeTest");
	}
	
	public static void main( String argv[] )
	{
		int i;
		long startTime;
		long endTime;
		
		startTime=System.currentTimeMillis();
		for (i=0; i < 1000000; i++ )
		{
			addJava(1,2);
		}
		endTime=System.currentTimeMillis();
		System.out.println( "addJava " + (endTime-startTime));
		
		startTime=System.currentTimeMillis();
		for (i=0; i < 1000000; i++ )
		{
			addNative(1,2);
		}
		endTime=System.currentTimeMillis();
		System.out.println( "addNative " + (endTime-startTime));
		
		NativeTest nt = new NativeTest();

		startTime=System.currentTimeMillis();
		for (i=0; i < 1000000 ; i++ )
		{
			nt.emptyJava();
		}
		endTime=System.currentTimeMillis();
		System.out.println( "emptyJava mcalls " + (endTime-startTime));
	
		startTime=System.currentTimeMillis();
		for (i=0; i < 1000000 ; i++ )
		{
			nt.emptyNative();
		}
		endTime=System.currentTimeMillis();
		System.out.println( "emptyNative mcalls " + (endTime-startTime));
	

		startTime=System.currentTimeMillis();
		for (i=0; i < 1000000; i++ )
		{
			nt.instanceAddNativeFast();
		}
		endTime=System.currentTimeMillis();
		System.out.println( "instanceAddNativeFast " + (endTime-startTime));
		if ( nt.z != 3)
			System.out.println("Z!=3 !!!!");
		
		startTime=System.currentTimeMillis();
		for (i=0; i < 1000000; i++ )
		{
			nt.instanceAddNativeSlow();
		}
		endTime=System.currentTimeMillis();
		System.out.println( "instanceAddNativeSlow " + (endTime-startTime));		
		if (nt.z != 3 )
			System.out.println("Z!=3 !!!!");


		startTime=System.currentTimeMillis();
		for (i=0; i < 1000000; i++ )
		{
			nt.instanceAddJava();
		}
		
		endTime=System.currentTimeMillis();
		System.out.println( "instanceAddJava " + (endTime-startTime));
			
		
	}
	
	public native void instanceAddNativeFast();
	public native void instanceAddNativeSlow();
	public void instanceAddJava()
	{
		z = x+y;
	}
	
	public void emptyJava() {}
	public native void emptyNative();
	
	public static native int addNative(int x, int y);
	public static int addJava(int x, int y )
	{
		return x+y;
	}
}
