// Copyright (c) 1997,1998,1999,2000 Albrecht Kleine    All rights reserved
// file version #300

#include "tyaconfig.h"
#include <stdio.h>
#include <native.h>
#include <monitor.h>
#include "tya.h"


#ifdef MEMDEBUG
#include "MemDebug.h"
#endif

//------ some mixed functions very often called during runtime -------------
//
// -all are called by our compiled code during runtime
//
// -some portions are rewritten to pure asm code: you can control
//  usage of this functions via setting #define USEASM in tyaconfig.h


#ifdef TRY_FAST_INVOKE
#ifndef USEASM


#ifndef JDK12
 #define DEF_CreateNewJavaStack(a,b)   CreateNewJavaStack(a,b)
#else
 #define DEF_CreateNewJavaStack(a,b)   CreateNewJavaStack(a,b,min_javastack_chunk_size)
#endif


// helper macro for FastInvCheck* ()
//
#define FASTINVPREPARE() if (TRUE)					\
{									\
	JavaFrame *JF;							\
	JavaStack *JS;							\
 	dprintf(stderr,"fast inv calling   %s.%s %s %d %d\n",		\
		unha11(mb->fb.clazz)->name,mb->fb.name,	\
		mb->fb.signature,mb->nlocals,mb->maxstack);\
        dprintf(stderr,"         called by %s.%s   %d %d\n",		\
		unha11(ee->current_frame->current_method->fb.clazz)->name,\
		ee->current_frame->current_method->fb.name,		\
		ee->current_frame->current_method->nlocals,		\
		ee->current_frame->current_method->maxstack);		\
	JF=ee->current_frame;						\
        JS=JF->javastack;						\
	JF++; \
	if (((char*)JF+100)>(char*)/*(JavaFrame*)*/JS->end_data) \
	{								\
	  if (!JS->next)						\
	    JS=DEF_CreateNewJavaStack(ee,ee->current_frame->javastack);	\
	  else 								\
	    JS=JS->next;						\
	  JF=(JavaFrame*)JS->data;					\
	}								\
	JF->vars=sp;							\
	JF->prev=ee->current_frame;					\
	JF->current_method=mb;						\
	JF->javastack=JS;						\
	JF->optop=JF->ostack;						\
	JF->constant_pool=NULL;						\
	ee->current_frame=JF;      					\
}


//returns both machine code address to call and stackspace
//                    = %eax                     = %edx
//
unsigned long long FastInvCheck32(struct execenv *ee,struct methodblock *mb,stack_item *sp)
{
      unsigned long long res;
      // if there isn't yet compiled code, so compile such one...(try it)
      if (!mb->CompiledCode)
         if (!JITCompileMethod(mb,ee))
         {
	   if (!(mb->fb.access & ACC_NATIVE))
	     lprintf("TYA: JIT problem 32: in %s.%s %s %d %d\n",
		     unha11(mb->fb.clazz)->name,mb->fb.name,mb->fb.signature,mb->nlocals,mb->maxstack);
           return (long long)CodeRunner32_withDummies;

         }
      FASTINVPREPARE();
      res=mb->nlocals*SIS4;
      res<<=32;
      res |= (long)mb->CompiledCode;
      return res;
}

// compare description in FastInvCheck32
//
unsigned long long FastInvCheck64(struct execenv *ee,struct methodblock *mb,stack_item *sp)
{
   unsigned long long res;
      // if there isn't yet compiled code, so compile such one...(try it)
      if (!mb->CompiledCode)
         if (!JITCompileMethod(mb,ee))
         {
	   if (!(mb->fb.access & ACC_NATIVE))
	     lprintf("TYA: JIT problem 64 in %s.%s %s %d %d\n",unha11(mb->fb.clazz)->name,mb->fb.name,mb->fb.signature,mb->nlocals,mb->maxstack);
           return (long long)CodeRunner64_withDummies;
         }
      FASTINVPREPARE();
      res=mb->nlocals*SIS4;
      res<<=32;
      res |= (long)mb->CompiledCode;
      return res;
}

// compare description in FastInvCheck32
// but this function doesn't contain a test for compilation
//
unsigned long long FastInvNoCheck32(struct execenv *ee,struct methodblock *mb,stack_item *sp)
{
   unsigned long long res;
   FASTINVPREPARE();
   res=mb->nlocals*SIS4;
   res<<=32;
   res |= (long)mb->CompiledCode;
   return res;
}

void FastInvPrepare(struct execenv *ee,struct methodblock *mb,stack_item *sp)
{
   FASTINVPREPARE();
}
#endif USEASM
#endif TRY_FAST_INVOKE


//---------------------------------------------------------------------------------

// wrapper, called during runtime
//	 
HObject *MyArrayAlloc(int type,int len)
{
   HObject *o=ArrayAlloc(type,len);
//   int *i=unhand(o);  
//   dprintf(stderr,"%x %x %x %x\n",i[0],i[1],i[2],i[3]);
   if (o)
#ifdef INIT0
      memset(unhand(o),0,T_ELEMENT_SIZE(type)*len)
#endif       
       ;
#ifndef EXT_ERR       
   else
     out_of_memory();
#endif
   return o;
}

#ifndef USEASM
// wrapper, called during runtime
//	 
HObject *MyObjAlloc(ClassClass *dcb)
{
   HObject *o;
   dprintf(stderr,"MyObjAlloc %p\n",dcb);
   o=ObjAlloc(dcb,0);
#ifdef INIT0   
   if (o)
      memset(unhand(o),0,unha11(dcb)->instance_size)
#endif       
       ;
   return o;
}
#endif

// Arithmethics called during runtime.
//					 
long long llmul_wrapper(long long x,long long z)
{
   return z*x;
}
#ifndef INLINE_LONGARITM
long long lldiv_wrapper(long long x,long long z)
{
   return z/x;
}

long long llrem_wrapper(long long x,long long z)
{
   return z%x;
}
#endif

//---------------------------------------------------------------------------------

// Compile call of this function if you want to know the stack contents during runtime
//  (very helpful for debugging purposes)
// Of course you can modify this, depending what you have to expect on stack,
//  but be careful, most time you have to preserve the register on caller's side.
//  Sometimes you cannot push/pop, because you'll get some very nice side effects ;-)
//
void debughelper(void *stacA,void *stacB,void *stacC)
{
  // please NEVER use iprint,lprint,dprint... (or whatever)  A.K.
  fprintf(stderr,"debughelper says: ## %p ## %p ## %p\n",stacA,stacB,stacC);
}


//--------------------------------------------------------------------------------

// invocation helper
//
// TODO: use terse_signatures in 1.2
//
void MakeStackRevInstruction(struct methodblock *mb,int nonstatic)
 {
    char aaa[256];
    char *xxx=aaa;
    int o,k,found64=0,found32=0;
    char *y=mb->fb.signature;
    if (nonstatic)
    {
     found32++;
     *xxx++=0x32;
    }
    y++;					// ignore '(' aka SIGNATURE_FUNC
    while (*y!=SIGNATURE_ENDFUNC)
	     {
		if (*y==SIGNATURE_ARRAY)
	  	{ 
 	   	 while (*y==SIGNATURE_ARRAY)	// multi dim array
	      	  y++;
	   	 if (*y==SIGNATURE_CLASS)	// array of objects
	    		while (*y!=SIGNATURE_ENDCLASS)
	      			y++;
		 found32++;  
	   	 *xxx++=0x32;	
	  	}
		else
	  	{  
	     	     if (*y==SIGNATURE_CLASS)	// object
	       	      while (*y!=SIGNATURE_ENDCLASS)
	         	y++;
		   if (*y!=SIGNATURE_LONG && *y!=SIGNATURE_DOUBLE)
		     {
	     	        *xxx++=0x32;
			found32++;
		     }
		   else
		     {
			*xxx++=0x64;		// because we have 64 bit  :) :)
			found64++;
		     }
	  	}
		y++;				// next src
     }
    k=found32+found64;				// ==strlen

    switch (found32+ (found64<<8))
      {
       case 256:(int)mb->CompiledCodeInfo=256;break;
       case 0:(int)mb->CompiledCodeInfo=257;break;
       case 1:(int)mb->CompiledCodeInfo=1;break;
       case 2:(int)mb->CompiledCodeInfo=2;break;
       case 3:(int)mb->CompiledCodeInfo=3;break;
       // FYI: never let (int)mb->CompiledCodeInfo be 0
       default:
	 mb->CompiledCodeFlags |= ((k-1)<<8); //shift lenght-1 into mask
	 mb->CompiledCodeInfo=sysMalloc(k+1);
	 for (o=0;o<k;o++)
	     ((char*)mb->CompiledCodeInfo)[o]=aaa[k-o-1];	//reverse string
	 ((char*)mb->CompiledCodeInfo)[k]=0;
	// dprintf(stderr,"RI-String %s\n",(char*)mb->CompiledCodeInfo);
	 break;
      }
 }

#ifndef USEASM
struct methodblock *RTGetIMeth(HObject *o,ClassClass *klassX,int u)
{
   int j=0;
   struct methodtable *omt=o->methods;
   struct imethodtable *oimt=unhand( omt->classdescriptor)->imethodtable;
   while  (klassX != oimt->itable[j].classdescriptor)
   {
#ifdef EXT_ERR      
      if (!oimt->itable[j].classdescriptor) return NULL;
#endif      
      j++;
   }
   return omt->methods[ oimt->itable[j].offsets[u] ];
}
#endif		       


//invocation helper
//
static void ReverseCopyViaScript(stack_item *loc,char *xx,int anz,stack_item *args)
{
   int i;
   anz--;
   for (i=0;i<=anz;i++)
     {
	if (*xx++ != 0x64)
          loc[anz-i]=args[i];
        else
	  {
	     loc[anz-i]=args[i+1];
	     loc[anz-i-1]=args[i];
	     i++;
	  }
     }
}

//----------------------------------------------------------------------

// helper macros for CodeRunner* ()
//
#define REVERSE_ARGS()  if (TRUE)					\
{									\
   switch ((int)mb->CompiledCodeInfo)					\
     {									\
/*      case 0: this should never happen  */				\
      case 257:								\
	break;								\
      case 256:local=alloca(2*SIS4);					\
	     local[ 0]=args[0];						\
	     local[ 1]=args[1];						\
	     args=local;						\
	break;								\
      case 1:local=alloca(1*SIS4);					\
	     local[ 0]=args[0];						\
	     args=local;						\
	break;								\
      case 2:local=alloca(2*SIS4);					\
	     local[ 1]=args[0];						\
	     local[ 0]=args[1];						\
	     args=local;						\
	break;								\
      case 3:local=alloca(3*SIS4);					\
	     local[ 2]=args[0];						\
	     local[ 1]=args[1];						\
	     local[ 0]=args[2];						\
	     args=local;						\
	break;								\
      default:local=alloca(mb->args_size*SIS4);				\
              ReverseCopyViaScript((stack_item*)local,			\
		(char*)mb->CompiledCodeInfo,				\
		mb->args_size,(stack_item*)args);			\
              args=local; 						\
	break;								\
     }									\
}

#define REVERSE_ARGS_NEW()  if (TRUE)					\
{									\
   switch ((int)mb->CompiledCodeInfo)					\
     {									\
/*      case 0: this should never happen  */				\
      case 257:								\
	break;								\
      case 256:local[ 0]=args[0];					\
	     local[ 1]=args[1];						\
	break;								\
      case 1:local[ 0]=args[0];						\
	break;								\
      case 2:local[ 1]=args[0];						\
	     local[ 0]=args[1];						\
	break;								\
      case 3:local[ 2]=args[0];						\
	     local[ 1]=args[1];						\
	     local[ 0]=args[2];						\
	break;								\
      default:ReverseCopyViaScript((stack_item*)local,			\
		(char*)mb->CompiledCodeInfo,				\
		mb->args_size,(stack_item*)args);			\
	break;								\
     }									\
}



// ---------------------- invocation main stuff ------------------------------------
// at all 4 functions
//  -the first two are to be called from section 6A
//  -the second two are to be called from section 6B
//   (6B has to carry one DUMMY (former 2) parameter for compatiblity reason with fast invocation)
// (But all are quite similar so we could consider to put them into some macros.)
//
#undef EXP
#define EXP
int CodeRunner32(ExecEnv *ee, struct methodblock *mb, int *args)
{
   int j;
   void *f;
   int *local;
#ifdef EXP   
   if (mb->code)
#else     
   if (mb->invoker==invokeJNINativeMethod
	||mb->invoker==invokeJNISynchronizedNativeMethod
	||mb->invoker==invokeNativeMethod
	||mb->invoker==invokeSynchronizedNativeMethod)
#endif       
   {
      local=(int*)ee->current_frame->optop;
      REVERSE_ARGS_NEW();
      if (! (mb->fb.access & ACC_STATIC))
	f=(void*)args[mb->args_size-1];
      else
	f=mb->fb.clazz;
      mb->invoker(f, mb, mb->args_size,ee);
      if (mb->CompiledCodeFlags & CCF_VOID)
	return 0;
      ee->current_frame->optop--;
      return (*ee->current_frame->optop).i;
   }
   
   REVERSE_ARGS();
   
   dprintf(stderr,"NEW CR32 (3) %s %p sync=%d\n",mb->fb.name,mb->code,0!=(mb->fb.access & ACC_SYNCHRONIZED));
   if (! (mb->fb.access & ACC_STATIC))
      f=(void*)*args++;
   else
      f=mb->fb.clazz;
   j=  do_execute_java_method_vararg(ee,f /* = object or class */,
	mb->fb.name,mb->fb.signature,mb, mb->fb.access & ACC_STATIC ,(void*)args,NULL, TRUE);
   dprintf(stderr,"NEW CR32 (4) %s %p sync=%d\n",mb->fb.name,mb->code,0!=(mb->fb.access & ACC_SYNCHRONIZED));
   dprintf(stderr,"NEW CR32 (5) %s EXC=%d\n",mb->fb.name,ee->exceptionKind);
   return j;
}

long long CodeRunner64(ExecEnv *ee, struct methodblock *mb, int *args)
{
   long long resu;
   int *local;
   void *f;
#ifdef EXP   
   if (mb->code)
#else     
   if (mb->invoker==invokeJNINativeMethod
	||mb->invoker==invokeJNISynchronizedNativeMethod
	||mb->invoker==invokeNativeMethod
	||mb->invoker==invokeSynchronizedNativeMethod)
#endif       
   {
      local=(int*)ee->current_frame->optop;
      REVERSE_ARGS_NEW();
   if (! (mb->fb.access & ACC_STATIC))
      f=(void*)args[mb->args_size-1];
   else
      f=mb->fb.clazz;
      mb->invoker(f, mb, mb->args_size,ee);
      ee->current_frame->optop-=2;
      return *(long long *)ee->current_frame->optop;
   }

   REVERSE_ARGS();
   dprintf(stderr,"NEW CR64 (3) %s %p sync=%d\n",mb->fb.name,mb->code,0!=(mb->fb.access & ACC_SYNCHRONIZED));
   if (! (mb->fb.access & ACC_STATIC))
      f=(void*)*args++;
   else
      f=mb->fb.clazz;   
   do_execute_java_method_vararg(ee,f,
	mb->fb.name,mb->fb.signature,mb,mb->fb.access & ACC_STATIC,(void*)args,NULL, TRUE);
#ifndef JDK12
   resu= *(long long *)((char*)ee->current_frame+
		  (2*(sizeof(JavaFrame)-SIS4)+
		   ee->current_frame->current_method->maxstack * SIS4));
#else
   resu= *(long long *)((char*)ee->current_frame+
		  (   2*sizeof(JavaFrame)+SIS4         //  2* (sizeof(JavaFrame)-SIS4)  
		   +
		   ee->current_frame->current_method->maxstack * SIS4));
#endif
   return resu;
} 

int CodeRunner32_withDummies(int d2,ExecEnv *ee, struct methodblock *mb, int *args)
{
   int *local;
   void *thisobj=(void*)args[mb->args_size-1];
#ifdef EXP
   if (mb->code)
#else     
   if (mb->invoker==invokeJNINativeMethod
	||mb->invoker==invokeJNISynchronizedNativeMethod
	||mb->invoker==invokeNativeMethod
	||mb->invoker==invokeSynchronizedNativeMethod)
#endif       
   {
      local=(int*)ee->current_frame->optop;
      REVERSE_ARGS_NEW();
      mb->invoker(thisobj, mb, mb->args_size,ee);
      if (mb->CompiledCodeFlags & CCF_VOID)
	return 0;
      ee->current_frame->optop--;
      return (*ee->current_frame->optop).i;
   }
   
   REVERSE_ARGS();
   dprintf(stderr,"NEW CR32d (3) %s %p sync=%d\n",mb->fb.name,mb->code,0!=(mb->fb.access & ACC_SYNCHRONIZED));
   return do_execute_java_method_vararg(ee,thisobj,
	mb->fb.name,mb->fb.signature,mb,0,(void*)&args[1],NULL, TRUE);
}


long long CodeRunner64_withDummies(/*int d1,*/ int d2,ExecEnv *ee, struct methodblock *mb, int *args)
{
   long long resu;
   int *local;
   void *thisobj=(void*)args[mb->args_size-1];
#ifdef EXP
   if (mb->code)
#else     
   if (mb->invoker==invokeJNINativeMethod
	||mb->invoker==invokeJNISynchronizedNativeMethod
	||mb->invoker==invokeNativeMethod
	||mb->invoker==invokeSynchronizedNativeMethod)
#endif       
   {
      local=(int*)ee->current_frame->optop;
      REVERSE_ARGS_NEW();
      mb->invoker( thisobj, mb, mb->args_size,ee);
      ee->current_frame->optop-=2;
      return *(long long *)ee->current_frame->optop;
   }
   REVERSE_ARGS();
   dprintf(stderr,"NEW CR64d (3) %s %p sync=%d\n",mb->fb.name,mb->code,0!=(mb->fb.access & ACC_SYNCHRONIZED));
   do_execute_java_method_vararg(ee,thisobj,
	mb->fb.name,mb->fb.signature,mb,0,(void*)&args[1],NULL, TRUE);
#ifndef JDK12
   resu= *(long long *)((char*)ee->current_frame+
		  (2*(sizeof(JavaFrame)-SIS4)+
		   ee->current_frame->current_method->maxstack * SIS4));
#else
   resu= *(long long *)((char*)ee->current_frame+
		  (   2*sizeof(JavaFrame)+SIS4         //  2* (sizeof(JavaFrame)-SIS4)  
		   +
		   ee->current_frame->current_method->maxstack * SIS4));
#endif
   return resu;
} 
