#ifndef CW_TEXT_H
#define CW_TEXT_H

#include <fstream>
#include <string>
#include <gtk--/text.h>

class Gtk_Box;
class Gtk_Table;
class Gtk_VScrollbar;
class Gdk_Font;

class CWText : public Gtk_Text
{
 public:
  
  Signal1<const string&> FileLoaded;

  CWText(Gtk_Box* parent);
  virtual ~CWText();

  void show();

  void Clear();
  void insert(const _gtk_string& buffer, gint length = -1);
  void LoadFile(string fileName, bool waitUntilAtEnd = false);

  //
  // WARNING: GotoEnd() does not work after inserting text with freeze()
  //          on until after you call thaw().
  //
  void GotoEnd();

 protected:

  void ValueChangedCB();
  void ChangedCB();

 private:

  static const unsigned MAX_READ_BUFFER = 1024;
  char _readBuffer[MAX_READ_BUFFER];

  void CheckFileInput();
  bool GetFileSize(off_t& size);
  void FileInsert();

  gint TickCB();

  Gtk_Table* table;
  Gtk_VScrollbar* vscrollbar;
  Gdk_Font* _fixedFont;

  Gtk_Adjustment* vadj;
  gfloat _endValue;
  bool _isAtEnd;
  bool _wasAtEndLastTick;
  
  bool _isFileRequested;
  string _requestedFile;

  ifstream* _file;
  streampos _currPos;
  Connection _tick;
};

#endif  /*  CW_TEXT_H  */
