/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-1999.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/. 
 */

/* Note: this is basically the gtkbutton code, hacked a bit to do
   needed it to do.  As of 11/17/99 I've contributed a total of
   two comment marks - just so no one thinks I'm trying to take
   credit for *anyone's* work here. :)  - Rob
*/

#ifndef __GTK_MOVIE_H__
#define __GTK_MOVIE_H__


#include <gdk/gdk.h>
#include <gtk/gtkbin.h>
#include <gtk/gtkenums.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_TYPE_MOVIE			(gtk_movie_get_type ())
#define GTK_MOVIE(obj)			(GTK_CHECK_CAST ((obj), GTK_TYPE_MOVIE, GtkMovie))
#define GTK_MOVIE_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_MOVIE, GtkMovieClass))
#define GTK_IS_MOVIE(obj)		(GTK_CHECK_TYPE ((obj), GTK_TYPE_MOVIE))
#define GTK_IS_MOVIE_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_MOVIE))


typedef struct _GtkMovie       GtkMovie;
typedef struct _GtkMovieClass  GtkMovieClass;

struct _GtkMovie
{
  GtkBin bin;

  GtkWidget *child /* deprecapted field,
		    * use GTK_BIN (movie)->child instead
		    */;

  guint in_button : 1;
  guint button_down : 1;
  guint relief : 2;
};

struct _GtkMovieClass
{
  GtkBinClass        parent_class;
  
  void (* pressed)  (GtkMovie *movie);
  void (* released) (GtkMovie *movie);
  void (* clicked)  (GtkMovie *movie);
  void (* enter)    (GtkMovie *movie);
  void (* leave)    (GtkMovie *movie);
};


GtkType        gtk_movie_get_type       (void);
GtkWidget*     gtk_movie_new            (void);
GtkWidget*     gtk_movie_new_with_label (const gchar *label);
void           gtk_movie_pressed        (GtkMovie *movie);
void           gtk_movie_released       (GtkMovie *movie);
void           gtk_movie_clicked        (GtkMovie *movie);
void           gtk_movie_enter          (GtkMovie *movie);
void           gtk_movie_leave          (GtkMovie *movie);
void           gtk_movie_set_relief     (GtkMovie *movie,
					  GtkReliefStyle newstyle);
GtkReliefStyle gtk_movie_get_relief      (GtkMovie *movie);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_MOVIE_H__ */
