/*
	GXAnim : A GTK frontend to XAnim
	by Robert Warren
	(c) 1999

	This program is covered under the General Public License.
	See COPYING file for licensing information.
	
	===============================================

	util.c

	utility routines and miscellaneous stuff

*/

#include "header.h"


/*
	function : show_window

	show a hidden window and raise it to foreground

*/

gint hide_window_action (GtkWidget *widget, GtkWidget *hidewidget)
{
	return hide_window_event(widget, _NULL, hidewidget);
}

gint hide_window_event (GtkWidget *widget, GdkEvent *event, GtkWidget *hidewidget)
{
	if (GTK_WIDGET_VISIBLE(hidewidget)) {
		gtk_widget_hide_all(hidewidget);
	}
	else
		show_window(_NULL, hidewidget);

	return (TRUE);
}


void show_window (GtkWidget *widget, GtkWidget *showwidget)
{
	gtk_widget_show_all(showwidget);
	raise_window(showwidget);
	return;
}


/*
	function : raise_window

	bring a window to the foreground
*/

void raise_window(GtkWidget *widget)
{
	Display *dpy;
	
	dpy = XOpenDisplay(_NULL);
	XRaiseWindow(dpy, get_xwindow(widget));
	XCloseDisplay(dpy);
	return;
}



/* 
	function : size_window

	manually change the size of a window on the server level
*/

void size_window(GtkWidget *widget, I16 size_x, I16 size_y)
{
	Display *dpy;
	
	dpy = XOpenDisplay(_NULL);
	XResizeWindow(dpy, get_xwindow(widget), size_x, size_y);
	XCloseDisplay(dpy);
	return;
}



/* 
	function : move_window

	set the screen location of a window
*/

void move_window(GtkWidget *widget, I16 move_x, I16 move_y)
{
	Display *dpy;
	
	dpy = XOpenDisplay(_NULL);
	XMoveWindow(dpy, get_xwindow(widget), move_x, move_y);
	XCloseDisplay(dpy);
	return;
}



/* Sat 03/20/99 10:23am

	This took me *forever* it seemed to get right, not to mention countless hours ripping apart the
	GTK/GDK source code to find what I needed.  Essentially the idea here is to be able to
	minimally screw around with X directly without interfering with GTK/GDK, and that starts with
	having to find the xwindow ID for a given widget.

	What is comes down to is: recast (GtkWidget) widget-> (GdkWindow) window into GtkWindowPrivate.
	Then grab window->xwindow for the xwindow ID.  The entire trick to this is to make sure the screen
	object is visible (i.e., you gtk_widget_show the widget) *before* you retrieve the ID and open a channel
	to the server.  Show the widget, get the ID, XOpenDisplay, do what you need to do, and then 
	XCloseDisplay.

	I'm using this technique here to bring certain widgets to the foreground when selected, as well as
	isolating the xwindow ID to the movie screen window in order to map XAnim's output.

	- Rob
*/

/* 
	get_xwindow (pointer to widget)

	return the xwindow ID for a given GTK widget.  it's up to the programmer to use it wisely.
*/

unsigned long get_xwindow(GtkWidget *widget) 
{
	GdkWindow *window;
	GdkWindowPrivate *private;

	if (!GTK_WIDGET_VISIBLE(widget))
		gtk_widget_show(widget); 

	private = (GdkWindowPrivate *) widget->window;
	return (unsigned long) private->xwindow;
}



/*
	function : extr_string

	given a source string and two bookend strings, return the string contained between
	the two.  note, this dynamically allocates memory but doesn't free it.  that needs to
	be done by the caller.
*/

void *extr_string (void *line, const char *lvalue, const char *rvalue)
{
	I8 count = 0;
	I8 lvlen = 0;

	char *word = _NULL;
	char *lstart = _NULL;
	char *rstart = _NULL;

	if (!lvalue || !(lstart = strstr(line, lvalue)))
		lstart = line;
	else
		lvlen = strlen(lvalue);

	if (rvalue) 
		rstart = strstr(lstart + lvlen, rvalue);
	else
		rstart = line + strlen(line) - 1;

	if (lvlen > 0 && rstart) {
		count = rstart - (lstart + strlen(lvalue));
		word = dalloc(word, count); 
		memcpy(word, lstart + strlen(lvalue), count); 
	}
	
	
	return word;
}


/*
	function : file_only

	given a source string (the entire path name of a file), extract just the filename and
	return it.

*/

void *file_only (char *line)
{
	char *retval = _NULL;
	I32 here = 0;
	
	for (here = strlen(line); here > 1 && line[here - 1] != '/'; here--);
	
	retval = dalloc(retval, strlen(line) - here);
	memcpy(retval, line + here, strlen(line) - here);

	return (void *)retval;
}


/* determine where to find the local .rc file */

char *find_home_path (char *buf, char *fname)
{
	buf = (char *)dalloc(buf, BUFLEN);	
	
	if (getenv("HOME"))
		sprintf(buf, "%s/%s", getenv("HOME"), fname);		
	else
		sprintf(buf, "./%s", fname);

	return buf;
}


/* get rid of spaces in a dynamically allocated string */

void *nospace (char *buf) {

	int i, j = 0;
	char *retval = _NULL;

	retval = dalloc(retval, strlen(buf) + 1);

	for (i=0; i < strlen(buf); i++) {
		if (buf[i] != 32) {
			*(retval + j) = buf[i];
			j++;
		}
	}

	dfree(buf);

	return retval;
}



