/*
 * Decompiled with CFR 0.152.
 */
package com.jtauber.fop.apps;

import com.jtauber.fop.Version;
import com.jtauber.fop.apps.FOPException;
import com.jtauber.fop.apps.SAXProcessor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;

public class CommandLine {
    static Parser createParser() {
        String string = System.getProperty("org.xml.sax.parser");
        if (string == null) {
            string = "com.jclark.xml.sax.Driver";
        }
        System.err.println("using SAX parser " + string);
        try {
            return (Parser)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            System.err.println(String.valueOf(string) + " is not a SAX driver");
        }
        return null;
    }

    protected static InputSource fileInputSource(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        String string3 = System.getProperty("file.separator");
        if (string3 != null && string3.length() == 1) {
            string2 = string2.replace(string3.charAt(0), '/');
        }
        if (string2.length() > 0 && string2.charAt(0) != '/') {
            string2 = String.valueOf('/') + string2;
        }
        try {
            return new InputSource(new URL("file", null, string2).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    public static void main(String[] stringArray) {
        Parser parser;
        System.err.println(Version.getVersion());
        if (stringArray.length != 2) {
            System.err.println("usage: java com.jtauber.fop.apps.CommandLine formatting-object-file pdf-file");
            System.exit(1);
        }
        if ((parser = CommandLine.createParser()) == null) {
            System.err.println("ERROR: Unable to create SAX parser");
            System.exit(1);
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(stringArray[1]));
            SAXProcessor sAXProcessor = new SAXProcessor(parser, CommandLine.fileInputSource(stringArray[0]));
            sAXProcessor.format(printWriter);
        }
        catch (FOPException fOPException) {
            System.err.println("FATAL ERROR: " + fOPException.getMessage());
            System.exit(1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("FATAL ERROR: " + fileNotFoundException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println("FATAL ERROR: " + iOException.getMessage());
            System.exit(1);
        }
    }
}

