/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef _ATRAPS_H_
#define _ATRAPS_H_

#include "Miscellaneous.h"		// StMemoryMapper

class SessionFile;

class ATrap
{
	public:
								ATrap		(void);
								~ATrap		(void);

		long					Call		(uae_u16 trapWord);

		void					PushByte	(uae_u8 iByte);
		void					PushWord	(uae_u16 iWord);
		void					PushLong	(uae_u32 iLong);

		void					SetNewDReg	(int regNum, uae_u32 value);
		void					SetNewAReg	(int regNum, uae_u32 value);

		uae_u32					GetD0		(void);
		uae_u32					GetA0		(void);

		static Bool				DoingCall	(void) { return fgCallCount > 0; }

		static void				Initialize	(void);
		static void				Reset		(void);
		static void				Save		(SessionFile&);
		static void				Load		(SessionFile&);
		static void				Dispose		(void);

	protected:

		long					DoCall		(uae_u16 trapWord);

	private:
		regstruct				fNewRegisters;

		static long				fgCallCount;

//		static const int		kStackSize = 4096;	// VC++ is a bit medieval here...
		enum { kStackSize = 4096 };
		char					fStack[kStackSize];

		StMemoryMapper			fMapper;
};

#endif /* _ATRAPS_H_ */

