/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

public class Cookie
implements Cloneable {
    private static String validChars = "!#$%&'*+-.0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ^_`abcdefghijklmnopqrstuvwxyz|~";
    private String myName;
    private String myValue;
    private String myComment = null;
    private String myDomain = null;
    private int myMaxAge = -1;
    private String myPath = null;
    private boolean mySecure = false;
    private int myVersion = 0;

    public String getComment() {
        return this.myComment;
    }

    public String getDomain() {
        return this.myDomain;
    }

    public int getMaxAge() {
        return this.myMaxAge;
    }

    public String getName() {
        return this.myName;
    }

    public String getPath() {
        return this.myPath;
    }

    public boolean getSecure() {
        return this.mySecure;
    }

    public String getValue() {
        return this.myValue;
    }

    public int getVersion() {
        return this.myVersion;
    }

    public void setComment(String string) {
        this.myComment = string;
    }

    public void setDomain(String string) {
        this.myDomain = string;
    }

    public void setMaxAge(int n) {
        this.myMaxAge = n;
    }

    public void setPath(String string) {
        this.myPath = string;
    }

    public void setSecure(boolean bl) {
        this.mySecure = bl;
    }

    public void setValue(String string) {
        this.myValue = string;
    }

    public void setVersion(int n) {
        this.myVersion = n;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Cookie(String string, String string2) throws IllegalArgumentException {
        if (string.length() == 0) {
            throw new IllegalArgumentException("Empty names are not allowed");
        }
        if (string.charAt(0) == '$') {
            throw new IllegalArgumentException("'$' not allowed as first char of Cookie name");
        }
        int n = 0;
        while (n < string.length()) {
            if (validChars.indexOf(string.charAt(n)) == -1) {
                throw new IllegalArgumentException("Character '" + string.charAt(n) + "' is not a valid HTTP/1.1 token");
            }
            ++n;
        }
        this.myName = string;
        this.myValue = string2;
    }
}

