/*
 * PAPP.C - generic post processor routines for PANACEA
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "panace.h"

#define NCURVE 100

PDBfile
 *pduf;

int
 first_cycle = 0,
 last_cycle = 0,
 n_curve = 0,
 npt;

static char
 pp_title[MAXLINE],
 pp_bf[MAXLINE],
 pp_ubf[MAXLINE];

static void
 SC_DECLARE(_PA_t_wr_data, 
            (int fcyc, int nfirst, int nlast, int n_dom)),
 SC_DECLARE(_PA_next_uf, (char *ufname, int flag));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_TRANSPOSE_PP - transpose the family of .pxx files and create a
 *                 - corresponding family of .uxx files for ULTRA
 *                 - NOTE: the family part isn't implemented yet
 */

void PA_transpose_pp(ppname, ntp, nuv)
   char *ppname;
   int ntp, nuv;
   {char s[MAXLINE], *ufname, *ps;

    if (ntp <= 0)
       return;

/* close the pp file */
    if (PA_pp_file != NULL)
       {PD_write(PA_pp_file, "n-time-plots", "integer", &ntp);
        PD_write(PA_pp_file, "n-time-arrays", "integer", &nuv);
        PD_write(PA_pp_file, "last-cycle", "integer", &PA_current_pp_cycle);

        PA_ERR(!PD_close(PA_pp_file),
               "TROUBLE CLOSING POST PROCESSOR FILE %s - PA_TRANSPOSE_PP",
               ppname);};

/* name the first edit file */
    strcpy(s, ppname);
    ps = strchr(s, '.');
    if (ps != NULL)
       ps[1] = 'u';
    else
       strcat(s, ".u00");

    ufname = SC_strsavef(s, "char*:PA_TRANSPOSE_PP:s");

/* open the pp file */
    PA_pp_file = PD_open(ppname, "r");
    PA_ERR((PA_pp_file == NULL),
           "CAN'T OPEN THE POST PROCESSOR FILE %s - PA_TRANSPOSE_PP",
           ppname);

/* create the ultra file */
    _PA_next_uf(ufname, FALSE);

/* process the pp file */
    _PA_proc_time(ufname);

    PA_ERR(!PD_close(pduf),
           "TROUBLE CLOSING ULTRA FILE %s - PA_TRANSPOSE_PP", ufname);
    printf("Ultra file %s closed\n", ufname);

    PA_ERR(!PD_close(PA_pp_file),
           "TROUBLE CLOSING POST PROCESSOR FILE %s - PA_TRANSPOSE_PP",
           ppname);

    PA_pp_file = NULL;
    pduf = NULL;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PA_PROC_TIME - process time plots
 *               - NOTE: the logic here may give trouble if the number of
 *               -       time plots requested is greater than NCURVE.
 *               -       The problem involves data for one axis ending up
 *               -       in a different file from the other axis.
 *               - GOTCHA: this logic is not correct for file families
 *               -         and it is way wrong for time plots with
 *               -         different frequencies of editting!!!!
 *               -         This gotcha may or may not be true now.        
 */

void _PA_proc_time(ufname)
   char *ufname;
   {int it, nt, ntu, nfirst, n_dom, nd;
    char *labl, *npts, *s;
    long ind[3];

/* find the number of time plots */
    if (!PD_read(PA_pp_file, "n-time-plots", &nt))
       return;
    if (nt < 1)
       return;

/* find the number of time data arrays */
    if (!PD_read(PA_pp_file, "n-time-arrays", &ntu))
       return;

/* find the number of time domain data arrays */
    nd = 0;
    if (!PD_read(PA_pp_file, "n-time-domains", &n_dom))
       n_dom = 2;

/* process the time plot tags */
    ind[0] = 0L;
    ind[2] = 1L;
    nfirst = 0;
    for (it = 0; it < nt; it++)
        {sprintf(pp_title, "tt%d", it);                     /* read the tag */

         PA_ERR(!PD_read(PA_pp_file, pp_title, pp_bf),
                "EXPECTED TIME PLOT %s - PROC-TIME", pp_title);

/* enter the ultra tag */
         sprintf(pp_title, "curve%04d", n_curve++);
         ind[1] = strlen(pp_bf) + 1;
         PD_write_alt(pduf, pp_title, "char", pp_bf, 1, ind);

/* extract the names of the label, x array, y array and number of points */
         labl = SC_strtok(pp_bf, "|", s);
         if (labl == NULL)
            break;
         npts = SC_strtok(NULL, "|", s);
         if (npts == NULL)
            break;

/* copy the label */
         PA_ERR(!PD_read(PA_pp_file, labl, pp_ubf),
                "BAD LABEL - PROC-TIME");
         ind[1] = strlen(pp_ubf) + 1;
         PD_write_alt(pduf, labl, "char", pp_ubf, 1, ind);

/* if the maximum number of curves is reached
 * write out the curves and start a new file
 */
         if (n_curve >= NCURVE)
            {_PA_t_wr_data(first_cycle, nfirst, it, nd);
             nfirst = it + 1;
             nd     = n_dom;
             _PA_next_uf(ufname, TRUE);};};

/* write out the remaining curves */
    _PA_t_wr_data(first_cycle, nfirst, ntu, nd);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PA_T_WR_DATA - write out the time data
 *               - which means gather the time stripes from the pp file
 *               - and transform it into curves
 *               - GOTCHA: this logic is not correct for file families
 *               -         and it is way wrong for time plots with
 *               -         different frequencies of editting!!!!
 *               -         This gotcha may or may not be true now.        
 */

static void _PA_t_wr_data(fcyc, nfirst, nlast, n_dom)
   int fcyc, nfirst, nlast, n_dom;
   {int i, j, n_arrays, nptm;
    double *stripe;
    REAL **crve;
    char type[10];
    long ind[3];

/* allocate the data arrays */
    n_arrays = nlast - nfirst + 1 + n_dom;
    crve     = FMAKE_N(REAL *, n_arrays, "_PA_T_WR_DATA:crve");
    stripe   = FMAKE_N(double, n_arrays, "_PA_T_WR_DATA:stripe");
    if (sizeof(REAL) == sizeof(double))
       strcpy(type, "double");
    else
       strcpy(type, "float");

/* find the maximum possible curve length */
    nptm = last_cycle - first_cycle + 1;

    for (i = 0; i < n_arrays; i++)
        crve[i] = FMAKE_N(REAL, nptm, "_PA_T_WR_DATA:crve[]");

/* read the data in from the pp file */
    for (i = 0; i < nptm; i++)

/* read in the domain data */
        {if (n_dom > 0)
            {sprintf(pp_title, "td%d[0:%d]", i+fcyc, n_dom);
             PA_ERR(!PD_read(PA_pp_file, pp_title, stripe),
                    "EXPECTED DOMAIN DATA UNDER %s - _PA_T_WR_DATA",
                    pp_title);};

/* read in the range data */
         sprintf(pp_title, "td%d[%d:%d]",
                 i+fcyc, nfirst + n_dom, nlast + n_dom);
         PA_ERR(!PD_read(PA_pp_file, pp_title, stripe + n_dom),
                "EXPECTED TIME PLOT DATA UNDER %s - _PA_T_WR_DATA",
                pp_title);

/* transpose through the copy */
         for (j = 0; j < n_arrays; j++)
             crve[j][i] = stripe[j];};

/* write out the time plot domain data */
    ind[0] = 1L;
    ind[2] = 1L;
    for (i = 0; i < n_dom; i++)
        {nptm   = SC_arrlen(crve[i])/SIZEOF(SC_REAL_S);
         ind[1] = nptm;

         sprintf(pp_title, "td%d", i);

         PD_write_alt(pduf, pp_title, type, crve[i], 1, ind);
         SFREE_N(crve[i], nptm);};

/* write out the time plot range data */
    ind[0] = 1L;
    ind[2] = 1L;
    for (i = nfirst, j = n_dom; i <= nlast; i++, j++)
        {nptm   = SC_arrlen(crve[j])/SIZEOF(SC_REAL_S);
         ind[1] = nptm;

         sprintf(pp_title, "tn%d", i);
         PD_write(pduf, pp_title, "integer", &nptm);

         sprintf(pp_title, "td%d", i + n_dom);
         PD_write_alt(pduf, pp_title, type, crve[j], 1, ind);

         SFREE_N(crve[j], nptm);};

    SFREE_N(stripe, n_arrays);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PA_NEXT_UF - close the current ultra file, advance the name, and
 *             - initialize the next ultra file in the family
 */

static void _PA_next_uf(ufname, flag)
   char *ufname;
   int flag;
   {if (flag)
       {if (pduf != NULL)
           PA_ERR(!PD_close(pduf),
                  "TROUBLE CLOSING ULTRA FILE %s", ufname);

        PRINT(stdout, "Ultra file %s closed\n", ufname);

/* generate the next name in the family */
        PA_advance_name(ufname);};

/* create the ultra file */
    pduf = PD_open(ufname, "w");
    PA_ERR((pduf == NULL),
           "CAN'T CREATE THE ULTRA FILE %s - _PA_NEXT_UF", ufname);

    PRINT(stdout, "Ultra file %s opened\n", ufname);

    n_curve = 0;

/* find the first cycle number */
    first_cycle = 0;
    if (!PD_read(PA_pp_file, "first-cycle", &first_cycle))
       return;

/* find the last cycle number */
    last_cycle = 0;
    if (!PD_read(PA_pp_file, "last-cycle", &last_cycle))
       return;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* dump the symbol table */
/*
    char *fname, **names;

    PRINT(stdout, "File: %s\n\n", fname);
    PRINT(stdout,
          "Symbol table (%d entries)\n",
          PA_pp_file->symtab->nelements);
    names = SC_hash_dump(PA_pp_file->symtab, NULL);
    PRINT(stdout, "\nEntries:\n");
    for (i = 0; i < PA_pp_file->symtab->nelements; i++)
        PRINT(stdout, "%s\n", names[i]);
    PRINT(stdout, "\n");
    SC_pause();
*/

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
