/*
 * PDBIO.C - handle file I/O for PDBLib
 *         - do things so that it can work over networks and so on
 *
 * Source Version: 9.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pdb.h"

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PD_PIO_CLOSE - close the file wherever it is */

int _PD_pio_close(stream)
   FILE *stream;
   {int ret;

    if (stream == NULL)
       return(EOF);
   
    ret = fclose(stream);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PD_PIO_SEEK - do an fseek on the file wherever it is */

int _PD_pio_seek(stream, addr, offset)
   FILE *stream;
   off_t addr;
   int offset;
   {int ret;

    if (stream == NULL)
       return(EOF);
   
    ret = F_SEEK(stream, addr, offset);

#ifdef LINUX
    ret = FALSE;
#endif

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PD_PIO_PRINTF - do an fprintf style write to the given file
 *                - wherever it is
 */

#ifdef PCC

int _PD_pio_printf(fp, fmt, va_alist)
   FILE *fp;
   char *fmt;
   va_dcl

#endif

#ifdef ANSI

int _PD_pio_printf(FILE *fp, char *fmt, ...)

#endif

   {size_t ni, nw;
    char Pbuffer[LRG_TXT_BUFFER];

    nw = 0;

    if (fp != NULL)
       {SC_VA_START(fmt);
	SC_VSPRINTF(Pbuffer, fmt);
	SC_VA_END;

	ni = strlen(Pbuffer);
	nw = io_write(Pbuffer, (size_t) 1, ni, fp);};

    return((int) nw);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

