;
; CONSTS.SCM - symbolic constants for the ULTRA II environment
;
; Source Version: 3.0
; Software Release #92-0043
;
; #include <pact-copyright.h>
;

(define %pi 3.141592654)
(define %e  2.718281828)

(define all   0)
(define on    1)
(define off   0)
(define auto -1)
(define de  'de)

;
; PGS graphics related constants
;

(define black       0)
(define white       1)
(define gray        2)
(define dark-gray   3)
(define blue        4)
(define green       5)
(define cyan        6)
(define red         7)
(define magenta     8)
(define brown       9)
(define dark-blue  10)
(define dark-green 11)
(define dark-cyan  12)
(define dark-red   13)
(define yellow     14)
(define purple     15)

(define helvetica "helvetica")
(define times     "times")
(define courier   "courier")

(define medium "medium")
(define italic "italic")
(define bold "bold")
(define bold-italic "bold-italic")

(define cartesian -1)
(define polar     -2)
(define insel     -3)

(if (defined? pdbview)
    (begin
      (define left     1)
      (define right    2)
      (define center   3)
      (define plus     1)
      (define star     2)
      (define triangle 3))
    (begin
      (define left   -10)
      (define right  -11)
      (define center -12)
      (define plus     0)
      (define star     1)
      (define triangle 2)))

(define right-of-axis  9)
(define left-of-axis  10)
(define straddle-axis 11)

(define solid     1)
(define dashed    2)
(define dotted    3)
(define dotdashed 4)

(define cartesian-plot -1)
(define polar-plot     -2)
(define insel-plot     -3)
(define histogram-plot -4)
(define scatter-plot   -5)
(define logical-plot   -6)

(define contour    11)
(define image      12)
(define wire-frame 13)
(define shaded     14)
(define vector     15)
(define fill-poly  16)
(define poly-fill  16)
(define mesh       17)
(define points     19)
(define dvb        20)

(define standard "standard")
(define spectrum "spectrum")
(define rainbow  "rainbow")
(define bw       "bw")
(define magentas "magentas")
(define blues    "blues")
(define cyans    "cyans")
(define greens   "greens")
(define yellows  "yellows")
(define reds     "reds")

(define vector-scale           1)
(define vector-angle           2)
(define vector-headsize        3)
(define vector-fixsize         4)
(define vector-maxsize         5)
(define vector-linestyle       6)
(define vector-linethick       7)
(define vector-color           8)
(define vector-fixhead         9)

