/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * December 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_actstack_h
#define _vdkb_actstack_h

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#define MAX_ACTIONSTACK 2048

class VDKBText;

enum {
  isa_action,isa_action_delete,isa_action_insert
};
class Action
{
 protected:
  VDKBText* text;
 public:
  Action(VDKBText* text):text(text) {}
  virtual ~Action() {}
  virtual void undo() = 0;
#ifdef VDKBDEBUG  
  virtual void print()  { }
#endif  
  virtual int isA() { return isa_action; }
};

class ActionText: public Action
{
 protected:
  char *buf;
  int pos;
 public:
  ActionText(VDKBText* text,int pos):
    Action(text),buf(NULL),pos(pos){}
  virtual ~ActionText() { if(buf) delete[] buf; }
};


class ActionDelete: public ActionText
{
 public:
  ActionDelete(VDKBText* text, int start, int end);
  virtual ~ActionDelete() {  }
  int isA() { return isa_action_delete; }
  void undo();
#ifdef VDKBDEBUG  
  void print()
    { printf("\nbuff:%s,pos:%d",buf,pos); fflush(stdout); }
#endif
};

class ActionInsert: public ActionText
{
  int len;
 public:
  ActionInsert(VDKBText* text,int pos, int len):
    ActionText(text,pos),len(len) {}
  virtual ~ActionInsert() {}
  int isA() { return isa_action_insert; }
  void undo();
#ifdef VDKBDEBUG  
  void print()
    { printf("\npos:%d,len:%d",pos,len); fflush(stdout); }
#endif
};

class ActionStack
{
  Action **base, **top;
  int dim,p;
 public:
  ActionStack(int d = MAX_ACTIONSTACK): p(0)
    { top = base = new Action*[dim = d] ;}
  ~ActionStack();
  bool push(Action* t)
    {
      if(++p <= dim) { *top++ = t; return true; }
      else { p = dim; return false; }
    }
  Action* pop()
    { 
      if(--p >= 0) return *--top;
      else { p = 0; return (Action*) 0; }
    }
  bool isEmpty() { return p <= 0; }
  void flush();
};
/*
implements a unlimited stack
that overwrites less recent actions
*/

class VDKBActionStack: public ActionStack
{
 public:
  VDKBActionStack(int d = MAX_ACTIONSTACK):
    ActionStack(d) {}
  bool push(Action* t);
};
#endif

