/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _vdkb_ctree_h
#define _vdkb_ctree_h
#include <vdk/vdk.h>
#include <vdkb/vdkb_object.h>
#include <vdkb/vdkb_widpopmenu.h>
typedef VDKArray<VDKString> TitlesArray;

class VDKBGuiForm;
class VDKBParser;
class VDKBGuiCustomTree: public VDKCustomTree, public VDKBObject
{
 protected:

  VDKBWidgetPopMenu *popmenu;
  VDKMenuItem *setsize,*delwidget;
  VDKBObjectInspector* inspector; // object inspector
  VDKEntry *columnTitle;
  VDKCheckButton *autoresize;
  VDKCombo *shadow,*selmode;
 public:
  TitlesArray column_titles;
  static int Counter;
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,VDKBParser& parser);
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  VDKBGuiCustomTree(char* name,
		 VDKForm* owner, 
		 int cols, 
		 char** titles,
		 GtkSelectionMode mode = GTK_SELECTION_SINGLE,
		 int tree_column = 0);
  virtual ~VDKBGuiCustomTree() {}
  virtual int Type() { return vdkbclass_ctree; }
  virtual char* VDKName() { return "VDKCustomTree"; }
  virtual int isA() { return vdkbclass_ctree; }
  virtual VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  //  bool DelWidget(VDKObject*);
  //  bool SetWidgetSize(VDKObject* sender);
  bool OnColumnClicked(VDKObject*);
  bool OnSetColumnTitle(VDKObject*);
  bool OnSetAutoResize(VDKObject*);
  bool OnSetShadow(VDKObject*);
  bool OnSetSelectionMode(VDKObject*);
  void PopMenu() { popmenu->Popup(); }
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);
  DECLARE_SIGNAL_LIST(VDKBGuiCustomTree);
  DECLARE_EVENT_LIST(VDKBGuiCustomTree);
};
#endif


