/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.7
 * September 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */


/*
--------
OVERVIEW
--------
- This file should be considered as a template for constructing vdkbuilder
plugin components. Users should copy/paste and easily adapt this file
to their own components.
- See also plugins.txt into /plugins directory for further informations.
*/

// write here your sentinel
#ifndef _vdkb_digitalclock_h
#define _vdkb_digitalclock_h
//
#include <vdk/vdk.h>
#include <vdkb/vdkb_object.h>
#include <vdkb/vdkb_widpopmenu.h>
#include <vdkb/vdkdclock.h>
// write here your vdkbuilder component class name
#define CLASS VDKBDigitalClock
// write here your vdk component class name
#define VDK_ANCESTOR  VDKDigitalClock
// write here your vdk component class name as string
#define VDK_CLASS "VDKDigitalClock"


class VDKBGuiForm;
class VDKBParser;
class CLASS: public VDK_ANCESTOR, public VDKBObject
{
  ///////////////////////////////////////////////
  /*
    this part is common to all component
    leave it as is
  */
 protected:
    // a pop menu activated with right click on component
  VDKBWidgetPopMenu *popmenu;
  // Widget Inspector address
  VDKBObjectInspector* inspector;

 public:
  static int Counter;
  static char* CreateSource(char* buffer,
			    VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner,
			   char* buffer,
			   VDKBParser& parser);
  static int MakeWidget(VDKBGuiForm* owner,
			GdkEvent* ev = NULL);
  CLASS(char* name,VDKForm* owner);
  virtual ~CLASS() {}
  virtual char* VDKName() { return VDK_CLASS; }
  void PopMenu() { popmenu->Popup(); }
  // called from designer
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);
  // signal tables
  DECLARE_SIGNAL_LIST(CLASS);
  DECLARE_EVENT_LIST(CLASS);
  ////////////////////////////////////////////////
  /*
    this part is component specific
    patch it as you need
  */
 protected:

  /*
    This is called to add properties settings to Widget Inspector.
    Comment out if your component does not have properties to be set.
  */
 public:
  //  virtual VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  /*
    signal handler (aka response methods) for set button.
    We decided to set all (same boolean type) properties
    with a single shot.
    Comment out if your component does not have properties to be set
    or write your own handlers.
  */
  //  bool OnSetProperties(VDKObject* sender);

};
#endif
