/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_parser_h
#define _vdkb_parser_h
#include <stdio.h>
#include <vdk/vdkstring.h>
class VDKBParser
{
  VDKString fname;
  char* buffer;
 public:
  VDKBParser(char* fname);
  virtual ~VDKBParser();
  char* Buffer() { return buffer; }
  int ClassName(char* name);
  char* GetObject(char* name);
  char* GetWidget(char* name);
  char* GetObjectName(char* object,char* tgt);
  char* GetObjectClass(char* object,char* tgt);
  char* GetParam( char* arg, // target
		  char* object, // object buffer
		  char* param); // param name
  bool GetNameAndParent(char* pars_buff,
			char* obj_name, 
			char* obj_parent);
  void WriteCodeToPack(char* obj_parent,
		       char* obj_name,
		       char* source, 
		       char* buffer, 
		                                 char* tmp);
  void WriteVisible(char* obj_name, char* arg, 
		    char* source, char* buffer,
		    char* tmp);

  VDKPoint Size(char* object);
  VDKRgb Color(char*object, char* colortype);

};
#endif
