/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */


#include <vdkb/sctext.h>
#include <vdk/colors.h>
#include <stdio.h>
#include <sys/stat.h>
#include <vdk/vdkfont.h>
#include <gdk/gdkkeysyms.h>
/*
sets text->Changed property to true
if user press an edit key
*/
int VDKSCText::KeyEvent(GtkWidget *, GdkEventKey *ev, gpointer gp)
{
  g_return_val_if_fail (ev != NULL, FALSE); 
  g_return_val_if_fail (gp != NULL, FALSE); 
  bool flag = false;
  VDKSCText *text = reinterpret_cast<VDKSCText*>(gp);
  switch(ev->keyval)
    {
    case GDK_BackSpace:
    case GDK_Tab:
    case GDK_Linefeed:
    case GDK_Clear:
    case GDK_Return:
    case GDK_Delete:
      text->Changed = true;
      flag = true;
      break;
    default:
     if(ev->keyval >= 32 && ev->keyval <= 255)
       {
	 text->Changed = true;
	 flag = true;
       }
     break;
    }
  /* 
  if(flag)
    {
      // emit both for static and dyna tables
      text->SignalEmit(text_changed_signal);
      text->SignalEmit("text_changed");
    }
  */
  return TRUE;
}
/*
 */
VDKSCText::VDKSCText(VDKForm* owner,bool editable, bool override):
  VDKObject(owner),
  // sets properties
  WordWrap("WordWrap",this,false,
	   &VDKSCText::SetWordWrap),
  Editable("Editable",this,editable,
	   &VDKSCText::SetEditable),
  Pointer("Pointer",this,0,
	   &VDKSCText::SetPointer,&VDKSCText::GetPointer),
  Length("Length",this,0,&VDKSCText::GetLength),
  Changed(false)
{
  // a dirty trick to avoid widget construction
if(!override)
  {
    widget = gtk_hbox_new(FALSE,1);
    gtk_container_border_width(GTK_CONTAINER(widget),0);
    text = sigwid = gtk_sctext_new(NULL,NULL);
    gtk_sctext_set_editable(GTK_SCTEXT(text),editable);
    gtk_box_pack_start(GTK_BOX(widget),text,TRUE,TRUE,0);
    scrollbar = gtk_vscrollbar_new(GTK_SCTEXT(text)->vadj);
    gtk_box_pack_start(GTK_BOX(widget),scrollbar,FALSE,TRUE,0);
    gtk_widget_show(text);
    gtk_widget_show(scrollbar);
    /* setup event handler */   
    gtk_signal_connect (GTK_OBJECT (text), "key_press_event", 
			GTK_SIGNAL_FUNC (VDKSCText::KeyEvent), this); 
    ConnectDefaultSignals();
  }
else
  widget = NULL;
}
/*
 */
VDKSCText::~VDKSCText()
{
}
/*
 */
void VDKSCText::SetBackground(VDKRgb rgb, GtkStateType)
{
if(!GTK_WIDGET_REALIZED(text))
  return;
VDKColor *color = new VDKColor(Owner(),rgb.red,rgb.green,rgb.blue);
/*
  if(!GTK_WIDGET_REALIZED(text))
  gtk_widget_realize(text);
*/
gdk_window_set_background (GTK_SCTEXT (text)->text_area, *color);
}

/*
 */
void 
VDKSCText::SetFont(VDKFont* font)
{
if(!widget) return; 
else
  TextFont.font = font;
}

/*
 */
int VDKSCText::LoadFromFile(char* filename)
{
  if(!GTK_WIDGET_REALIZED(text))
    return 0;
  //    gtk_widget_realize(text);
  FILE* fp;
  char* edbuff,*p;
  fp = fopen(filename,"r");
  if(fp)
    {
      int c;
      struct stat info;
      stat(filename,&info);
      unsigned int size = info.st_size;
      edbuff = p = new char[size+1];
      while( (c = fgetc(fp)) != EOF)
	*p++ = (char) c;
      *p = '\0';
      fclose(fp);
      VDKFont* font = TextFont.font;
      gtk_sctext_freeze (GTK_SCTEXT (text));
      gtk_sctext_insert(GTK_SCTEXT(text),
		      font? 
		      *font :
		      (GdkFont*) NULL,
		      TextFont.foreground,
		      TextFont.background,
		      edbuff,strlen(edbuff));
      gtk_sctext_thaw (GTK_SCTEXT (text));
      delete[] edbuff;
      Changed = false;
      return true;
    }
  else
    return 0;
}

/*
 */
int VDKSCText::SaveToFile(char* filename)
{
  if(!GTK_WIDGET_REALIZED(text))
    return 0;
  //    gtk_widget_realize(text);
  FILE* fp;
  fp = fopen(filename,"w+b");
  if(fp)
    {
      int result = 0;
      char* p;
      p = GetChars(0,-1);
      if(p)
	{
	  result = fwrite(p,Length,1,fp);
	  g_free(p);
	}
      fclose(fp);
    return result == 1;
  }
  else 
    return false;
}
/*
 */
void 
VDKSCText::TextInsert(char* t, int nchar)
{
  if(!GTK_WIDGET_REALIZED(text))
    return;
  //    gtk_widget_realize(text);
  gtk_sctext_freeze(GTK_SCTEXT(text));
  gtk_sctext_insert(GTK_SCTEXT(text),
		  TextFont.font != NULL? 
		  *TextFont.font:
		  (GdkFont*) NULL,
		  TextFont.foreground,
		  TextFont.background,
		  t,
		  nchar);
  gtk_sctext_thaw(GTK_SCTEXT(text));
  Changed = true;
}

void VDKSCText::Clear()
{
int length;
if(!GTK_WIDGET_REALIZED(text))
  return;
//    gtk_widget_realize(text);
gtk_sctext_set_point(GTK_SCTEXT(text),0);
length = gtk_sctext_get_length(GTK_SCTEXT(text));
gtk_sctext_freeze(GTK_SCTEXT(text));
gtk_sctext_forward_delete(GTK_SCTEXT(text),length);
gtk_sctext_thaw(GTK_SCTEXT(text));
Changed = true;
}
