/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#include <vdkb/vdkb_custombutton.h>
#include <vdkb/vdkb_evbox.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb_form.h>
#include <vdkb/vdkb_parser.h>
#include <vdkb/vdkb_objinspect.h>
#include <stdlib.h>
#include <vdk/FileDialog.h>
#include <vdkb/vdkb_prjman.h>
#include <vdkb/vdkxpmbrowser.h>
#include <vdkb/vdkb_fixed.h>
#include <vdkb/vdkb_cbuttdlg.h>
static char *default_xpm[] = {
/* width height num_colors chars_per_pixel */
"    24    22        6            1",
/* colors */
". c #000000",
"# c #828282",
//"a c #c3c3c3",
"a c #none",
"b c #ffff00",
"c c #0000ff",
"d c #ffffff",
/* pixels */
"a......................a",
".ddddddddddddddddddddd#.",
".daaaaaaaaaaaaaaaaaaa##.",
".daaaaaadddddaaaaaaaa##.",
".daaadddaaadddaaaaaaa##.",
".daaaaaaaa.ddd.daaaaa##.",
".daa#aaadd..dd..ddaaa##.",
".daab#aa.d#.#dd.dcaaa##.",
".daab#a..dd..dd.#ddaa##.",
".daabb#..dd..dd..ddda##.",
".daabb#..dd..dd..ddda##.",
".daab#a..d#.#dd.#ddaa##.",
".daab#aa.d..ddd.ddaaa##.",
".daa#aaaad.ddd.ddaaaa##.",
".daaaaaaaa.ddd.daaaaa##.",
".daaaaaaaaaaa..aaaaaa##.",
".daaaaaaaaaa..a.aaaaa##.",
".daaaaaaaaa..aaa.aaaa##.",
".daaaaaaaaaaaaaaaaaaa##.",
".d#####################.",
".######################.",
"a......................a"
};
/*
================================
symbolic constants to templatize
a bit 
================================
*/
// for methods and other stuff
#define CLASS VDKBCustomButton
// put here vdk class name string
#define VDK_CLASS "VDKCustomButton"
// put here vdk class name 
#define VDK_ANCESTOR  VDKCustomButton
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "custombutton"

static char buff[128];

// used to autogenerate default
// labelbutton  names and captions

int CLASS::Counter = 0;
/* 
 label button properties names
 */
char* vdkcustombutton_props[] =
{ 
CAPTION,CAPTIONWRAP,PROP_RELIEF,GLYPH,
PIXMAPPED_INTERNAL,CB_TYPE_INTERNAL,
CB_POS_INTERNAL,0
};
/*
label button signals names && nicknames
Default response method name will be made by:
On<object name><nickname>.
For instance if object name = <Abutton> and nickname = <Click>
default response method name will be: <OnAbuttonClick>
*/
char* vdkcustombutton_signals[] =
{
SIGNAL_CLICKED,SIGNAL_ENTER,SIGNAL_LEAVE,0
};
char* vdkcustombutton_nicknames[] =
{
NICK_CLICKED,NICK_ENTER,NICK_LEAVE,0
};
//////////////////////////////////////////////////
// dynamic tables
DEFINE_SIGNAL_LIST(CLASS,VDK_ANCESTOR);
DEFINE_EVENT_LIST(CLASS,VDK_ANCESTOR);
//////////////////////////////////////////////////////////////
/*
  - constructor
 */
CLASS::CLASS(char* name, 
	     VDKForm* owner,
	     char* pixfile, 
	     char* label, 
	     unsigned int type,
	     GtkPositionType position):
  VDK_ANCESTOR(owner, pixfile , 
	       label, 
	       type, 
	       position),
  VDKBObject(name)
{
  int t;
  // newly constructed widget counter is incremented
  // each time 
  Counter++;
  // assign this to VDKBObject <object> member.
  object = this;
  // add to VDKBObject properties list label button properties
  // names. (Others props are prepended  by VDKBObject constructor)
  for(t=0; vdkcustombutton_props[t]; t++)
    proplist.add(VDKBProperty(vdkcustombutton_props[t]));
  if(label)
    SetPropValue(CAPTION,label);
  if(pixfile)
    SetPropValue(PIXMAPPED_INTERNAL,(char*) "true");
  sprintf(buff,"%u",type);
  SetPropValue(CB_TYPE_INTERNAL,buff);
  sprintf(buff,"%u",position);
  SetPropValue(CB_POS_INTERNAL,buff);
  // add to VDKBObject signal list label button signals
  for(t=0; vdkcustombutton_signals[t]; t++)
    siglist.add(VDKBSignal(vdkcustombutton_signals[t],
			   this,
			   vdkcustombutton_nicknames[t]));
  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
  CONNECT_COMMON_EVENTS;
}
CLASS::CLASS(char* name, 
	     VDKForm* owner,
	     char** pixdata, 
	     char* label, 
	     unsigned int type,
	     GtkPositionType position):
  VDK_ANCESTOR(owner, pixdata , label,  type, position),
  VDKBObject(name)
{
  int t;
  // newly constructed widget counter is incremented
  // each time 
  Counter++;
  // assign this to VDKBObject <object> member.
  object = this;
  // add to VDKBObject properties list label button properties
  // names. (Others props are prepended  by VDKBObject constructor)
  for(t=0; vdkcustombutton_props[t]; t++)
    proplist.add(VDKBProperty(vdkcustombutton_props[t]));
  if(label)
    SetPropValue(CAPTION,label);
  if(pixdata)
    SetPropValue(PIXMAPPED_INTERNAL,(char*) "true");
  sprintf(buff,"%u",type);
  SetPropValue(CB_TYPE_INTERNAL,buff);
  sprintf(buff,"%u",position);
  SetPropValue(CB_POS_INTERNAL,buff);
  // add to VDKBObject signal list label button signals
  for(t=0; vdkcustombutton_signals[t]; t++)
    siglist.add(VDKBSignal(vdkcustombutton_signals[t],
			   this,
			   vdkcustombutton_nicknames[t]));
  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
  CONNECT_COMMON_EVENTS;
}
////////////////////////////////////////////////////////////////
//
//               WRITER TO .FRM FILE
//
///////////////////////////////////////////////////////////////
/*
Writes a .frm format representation of label button widget
This virtual function is called by VDKBForm::WriteBoxesOnFrm()
a recursive algorithm that scans VDKBForm widget tree.
*/
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  // first of all call ancestor to write common properties
  VDKBObject::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s\"%s\";",PROP_CAPTION,(char*) GetProp(CAPTION));
  fprintf(fp,"\n\t%s%s;",PROP_CAPTIONWRAP,(char*) GetProp(CAPTIONWRAP));
  fprintf(fp,"\n\t%s%s;", PROP_RELIEF,(char*) GetProp(RELIEF));
  fprintf(fp,"\n\t%s%s;",PROP_GLYPH,(char*) GetProp(GLYPH));
  fprintf(fp,"\n\t%s%s;",PROP_PIXMAPPED_INTERNAL,
	  (char*) GetProp(PIXMAPPED_INTERNAL));
  fprintf(fp,"\n\t%s%s;",PROP_CB_TYPE_INTERNAL,
	  (char*) GetProp(CB_TYPE_INTERNAL));
  fprintf(fp,"\n\t%s%s;",PROP_CB_POS_INTERNAL,
	  (char*) GetProp(CB_POS_INTERNAL));
}
//////////////////////////////////////////////////////////////////
//
//               PREPARE GUI WIDGETS
//
//////////////////////////////////////////////////////////////////
/*
This method is called by global MakeWidget() in vdkb_design.cc
MakeWidget() scans a table that maps class id's with each
static MakeWidget() for each class. Class id's are generated
during clicks on widget palette.
 */
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable button counter
  // to ensure unicity
  CLASS* button;
  int pixmapped;
  unsigned int type;
  GtkPositionType labelpos = GTK_POS_RIGHT;

  VDKBComboButtonDlg *dlg = new VDKBComboButtonDlg(owner,
						   NULL,
						   &pixmapped,
						   &type,
						   &labelpos);
  dlg->Setup();
  dlg->ShowModal();
  // widget name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2; 
  else
    // actually makes widget
      button = new CLASS(buff,
			 owner,      
			 pixmapped ? default_xpm : (char**) NULL,
			 buff, type, labelpos);
  // add widget to form
  return owner->AddToSelf(button,ev);
}
/*
This is called by a global CreateSource() in vdkb_parser.cc.
CreateSource() scans a table that maps class names with
each static CreateSource() in widget class.
 */
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  char tmp[256];
  char obj_caption[128];
  char obj_glyph[256];
  unsigned int buttontype, labelpos;
// gets widget name and parent name
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return NULL;
  source = new char[4096];
  if(!parser.GetParam(obj_caption,buffer,PROP_CAPTION))
    strcpy(obj_caption,"none");

  if(parser.GetParam(obj_glyph,buffer, PROP_GLYPH) && 
     strcmp(obj_glyph,NIHIL_PROP))
    ;
  else
    *obj_glyph = '\0';

  if(parser.GetParam(arg,buffer, PROP_CB_TYPE_INTERNAL) && 
     strcmp(arg,NIHIL_PROP))
    buttontype = atoi(arg);
  else
    buttontype = VDK_CBUTTON_UNTOGGLED | VDK_CBUTTON_NORMAL;

  if(parser.GetParam(arg,buffer, PROP_CB_POS_INTERNAL) && 
     strcmp(arg,NIHIL_PROP))
    labelpos = atoi(arg);
  else
    labelpos = (unsigned int) GTK_POS_RIGHT;
  sprintf(tmp,"\n%s = new %s(this,%s%s%s,\"%s\",%d,(GtkPositionType) %d);",
	  obj_name,
	  VDK_CLASS,
	  *obj_glyph ? "\"" : "",
	  *obj_glyph ? obj_glyph : "(char*) NULL",
	  *obj_glyph ? "\"" : "",
	  obj_caption,
	  buttontype,
	  (GtkPositionType) labelpos);
  strcpy(source,tmp);
  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);
  if(props)
    {
      strcat(source,props);
      delete[] props;
    }
 /*
    this code is widget specific
  */
  if(
     parser.GetParam(arg,buffer,PROP_CAPTIONWRAP) && 
     strcmp(arg,NIHIL_PROP)
     )
   {
     sprintf(tmp,"\n%s->%s = %s;", obj_name, CAPTIONWRAP, arg);
     strcat(source,tmp);
   }    
  if(
     parser.GetParam(arg,buffer,PROP_RELIEF) && 
     strcmp(arg,NIHIL_PROP))
   {
     sprintf(tmp,"\n%s->%s = (GtkReliefStyle) %s;", obj_name,RELIEF,arg);
     strcat(source,tmp);
   }    
  // get code that adds widget to container
  parser.WriteCodeToPack(obj_parent,obj_name,source,buffer,tmp);
  /*
    visible property must be wrote after adding it to a parent
    container. That's the reason why is written here and not
    in vdkb_object class as should be. Written only if == false
  */
  parser.WriteVisible( obj_name, arg, source,buffer,  tmp);
  return source;
}
/*
Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
reading .frm file.
MakeGuiObjects() scans .frm file and call a global CreateWidget()
that scans a table that maps class names with
each static CreateWidget() in widget class.
*/
bool
CLASS::CreateWidget(VDKBGuiForm* owner, 
			      char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char obj_caption[256];
  char arg[64];
  char obj_glyph[256];
  unsigned int buttontype;
  GtkPositionType labelpos;
  bool pixmapped;
  CLASS* button;
 // get widget name and parent
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return false;
  // get caption,pixmapped,glyph,type
  if(!parser.GetParam(obj_caption,buffer, PROP_CAPTION))
    strcpy(obj_caption,"none");

  if(parser.GetParam(arg,buffer, PROP_PIXMAPPED_INTERNAL) && 
     !strcmp(arg,"true"))
    pixmapped = true;
  else
    pixmapped = false;

  if(pixmapped && parser.GetParam(obj_glyph,buffer,PROP_GLYPH) && 
     strcmp(obj_glyph,NIHIL_PROP))
    ;
  else
      strcpy(obj_glyph,"");

  if(parser.GetParam(arg,buffer, PROP_CB_TYPE_INTERNAL) && 
     strcmp(arg,NIHIL_PROP))
    buttontype = atoi(arg);
  else
    buttontype = VDK_CBUTTON_UNTOGGLED | VDK_CBUTTON_NORMAL;

  if(parser.GetParam(arg,buffer, PROP_CB_POS_INTERNAL) && 
     strcmp(arg,NIHIL_PROP))
    labelpos = (GtkPositionType) atoi(arg);
  else
    labelpos = GTK_POS_RIGHT;

  VDKObject* p = owner->ChildWithName(obj_parent);
  VDKBEventContainer* container = p ? 
    dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
  if(container)
    {
      if(*obj_glyph)
	button = new CLASS(obj_name,owner,
			   obj_glyph,
			   obj_caption,
			   buttontype,
			   labelpos);
      else
	button = new CLASS(obj_name,
			   owner,
			   pixmapped ? default_xpm : (char**) NULL,
			   obj_caption,
			   buttontype,
			   labelpos);
      if(parser.GetParam(arg,buffer, PROP_CAPTIONWRAP) && 
	 strcmp(arg,NIHIL_PROP))
	{
	button->CaptionWrap = !strcmp(arg,CHECK_TRUE);
	button->SetPropValue(CAPTIONWRAP,arg);
	}
      if(parser.GetParam(arg,buffer,PROP_RELIEF) && strcmp(arg,NIHIL_PROP))
	{
	  button->Relief = (GtkReliefStyle) atoi(arg);
	  button->SetPropValue(RELIEF,arg);
	}
      if(*obj_glyph)
	button->SetPropValue(GLYPH,obj_glyph);
      if(parser.GetParam(arg,buffer,PROP_PIXMAPPED_INTERNAL) && 
	 strcmp(arg,NIHIL_PROP))
	  button->SetPropValue(PIXMAPPED_INTERNAL,arg);
      if(parser.GetParam(arg,buffer,PROP_CB_TYPE_INTERNAL) && 
	 strcmp(arg,NIHIL_PROP))
	  button->SetPropValue(CB_TYPE_INTERNAL,arg);
      if(parser.GetParam(arg,buffer, PROP_CB_POS_INTERNAL) && 
	 strcmp(arg,NIHIL_PROP))
	button->SetPropValue(CB_POS_INTERNAL,arg);

      // pack widget to container
      return owner->PackToSelf(button, container, buffer, parser);
    }
  else
    return false;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
 */
static char *reliefs[] = 
{ "Normal","Half","None",0 };
/*
 */
VDKObjectContainer* 
CLASS::ExtraWidget(VDKBObjectInspector* isp) 
{ 
  inspector = isp;
  VDKFrame* bframe = new VDKFrame(inspector,NULL,v_box,shadow_etched_in);
  // FIX ME: lang support
  VDKTable* table = new VDKTable(inspector,5,2,true);

  VDKLabelButton* button = 
    new VDKLabelButton(inspector,"Set Caption");
  table->AddToCell(button,0,0);
  button->Parent(this);
  SignalConnect(button,"clicked",&CLASS::OnSetCaption);

  caption = new VDKEntry(inspector,0,(char*) GetProp(CAPTION));
  caption->SetSize(100,-1);
  table->AddToCell(caption,0,1);
  caption->Parent(this);
  SignalConnect(caption,"activate",&CLASS::OnSetCaption);

  wrap = new VDKCheckButton(inspector,"Caption wrap");
  table->AddToCell(wrap,1,0);
  wrap->Parent(this);
  SignalConnect(wrap,"toggled",&CLASS::OnSetCaptionWrap);
  
  button = new VDKLabelButton(inspector,"Set Relief");
  table->AddToCell(button,2,0);
  button->Parent(this);
  SignalConnect(button,"clicked",&CLASS::OnSetRelief);

  int r = atoi(GetProp(RELIEF));
  relief = new VDKCombo(inspector,NULL);
  relief->SetSize(100,-1);
  StringList sl;
  int t = 0;
  for(;reliefs[t];t++)
    sl.add(VDKString(reliefs[t]));
  relief->PopdownStrings = sl;
  relief->SelectItem(r);
  table->AddToCell(relief,2,1);
  // does not show glyph controls if the button isn't pixmapped
  bool isEnabled = !strcmp(GetProp(PIXMAPPED_INTERNAL),"true");
  if(isEnabled)
    {
      button = new VDKLabelButton(inspector,"Set glyph");
      table->AddToCell(button,3,0);
      button->Parent(this);
      SignalConnect(button,"clicked",&CLASS::OnSetGlyph);
      VDKString s = GetProp(GLYPH);
      pixfile = new VDKEntry(inspector,0,
			     !strcmp((char*) s,NIHIL_PROP) ? NULL : (char*) s);
      table->AddToCell(pixfile,3,1);
      pixfile->SetSize(100,-1);
      pixfile->Editable = false;
      
      shortname = new VDKLabelButton(inspector,"Set xpm to project dir");
      table->AddToCell(shortname,4,0);
      shortname->Parent(this);
      SignalConnect(shortname,"clicked",&CLASS::OnSetShortName);
      shortname->Enabled = false;
    }
  bframe->Add(table,l_justify,false,false,false);
  return bframe; 
}
//////////////////////////////////////////////////////
// These response methods actually change both 
// properties on widget and gui widget properties
//////////////////////////////////////////////////////
/*
 */
bool
CLASS::OnSetCaptionWrap(VDKObject*)
{
  SetPropValue(CAPTIONWRAP, wrap->Checked ? CHECK_TRUE : CHECK_FALSE);
  CaptionWrap = wrap->Checked ? true : false;
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetRelief(VDKObject*)
{
  int sel = relief->Selected;
  sprintf(buff,"%d", sel >= 0 ? sel : 0);
  int relief = atoi(buff);
  SetPropValue(RELIEF,buff);
  Relief = (GtkReliefStyle) relief;
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetCaption(VDKObject*)
{
  if(strlen(caption->Text)>0)
    {
      sprintf(buff,"%s",(char*) caption->Text);
      SetPropValue(CAPTION,buff);
      Caption = caption->Text;
      inspector->FormNeedToBeChanged();
    }
  return true;
}

/*
 */
bool
CLASS::OnSetGlyph(VDKObject*)
{
  FileStringArray selections;
  VDKXpmBrowser *child = new VDKXpmBrowser(Owner(),&selections,
					   file_dialog_prompts[0]);
  child->ShowModal();
  if(selections.size() > 0)
    {
      VDKPixmap* pixmap = Pixmap;
      pixmap->SetPixmap((char*) selections[0]);
      pixfile->Text = (char*) selections[0];
      SetPropValue(GLYPH,(char*) selections[0]);
      inspector->FormNeedToBeChanged();
      shortname->Enabled = true;
    }
  return true;
}
/*
 */
bool
CLASS::OnSetShortName(VDKObject*)
{
  VDKString s = GetProp(GLYPH);
  VDKString path;
  VDKBProject* project;
  VDKBProjectManager* prjman;
  if(!inspector)
    return true;
  prjman =  dynamic_cast<VDKBProjectManager*>(inspector->Owner());
  if(!prjman)
    return true;
  project = prjman->Project();
  if(!project)
    return true;
  path = project->Path;
  sprintf(buff,"cp %s %s/",(char*) s, (char*) path);
  system(buff);
  char* p = get_shortfilename((char*) s);
  if(p)
    {
      VDKString short_name = p;
      pixfile->Text = (char*) short_name;
      SetPropValue(GLYPH,(char*) short_name);
      shortname->Enabled = false;
      inspector->FormNeedToBeChanged();
    }
  return true;
}





