/* GNU Chess 5.0 - eval.h - evaluation symbolic definitions
   Copyright (c) 1999 Free Software Foundation, Inc.

   GNU Chess is based on the two research programs 
   Cobalt by Chua Kong-Sian and Gazebo by Stuart Cracraft.

   GNU Chess is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU Chess is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Chess; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     bug-gnu-chess@gnu.org
     cracraft@ai.mit.edu, cracraft@stanfordalumni.org, cracraft@earthlink.net
*/
/****************************************************************************
 *
 *  The various evaluations constants.
 *
 ****************************************************************************/

#define OPENING	     (phase <= 2)
#define ENDING       (phase >= 6)
#define TRADEPIECE   4
#define TRADEPAWNS   8
#define HUNGPENALTY  -24
#define ROOKMOVED    -20
#define KINGMOVED    -40
#define NOTCASTLED   -24
#define PFACTOR      550
#define BAD_TRADE    -100 /* -90 */
#define EARLYMINORREPEAT -40

/***********/
/*  Pawns  */
/***********/
#define EARLYWINGPAWNMOVE -24
#define BACKWARDPAWN   -(8+phase)
#define	ISOLATEDPAWN   -(8+phase)
#define DOUBLEDPAWN    -(8+phase)
#define PAWNBASEATAK   -18
#define BLOCKDEPAWN    -12
#define CONNECTEDPP	650
#define PAWNNEARKING    40
#define ATAKWEAKPAWN    6
#define PAWN_CENTER_BONUS 5
#define PAWN_ATTACK_BONUS 1
#define PAWN_MOBILITY_BONUS 1
#define FIANCHETTO_TARGET -40


/*************/
/*  Knights  */
/*************/
#define KNIGHTONRIM	-40
#define	OUTPOSTKNIGHT    10
#define PINNEDKNIGHT    -12
#define KNIGHTTRAPPED   -250
#define KNIGHT_CENTER_BONUS 5
#define KNIGHT_ATTACK_BONUS 3
#define KNIGHT_MOBILITY_BONUS 5


/*************/
/*  Bishops  */
/*************/
#define	OUTPOSTBISHOP    8
#define FIANCHETTO	 8
#define GOODENDINGBISHOP 24
#define BISHOPTRAPPED   -250
#define PINNEDBISHOP	-8
#define BISHOP_CENTER_BONUS 3
#define BISHOP_ATTACK_BONUS 3
#define BISHOP_MOBILITY_BONUS 5

/***********/
/*  Rooks  */
/***********/
#define	ROOK7RANK      30
#define ROOKS7RANK     60
#define ROOKHALFFILE   8
#define ROOKOPENFILE   12
#define ROOKBEHINDPP   12
#define ROOKINFRONTPP -20
#define PINNEDROOK    -12
#define ROOK_CENTER_BONUS 1
#define ROOK_ATTACK_BONUS 3
#define ROOK_MOBILITY_BONUS 3

/***********/
/*  Queen  */
/***********/
#define EARLYQUEENMOVE  -60
#define QUEENNEARKING   12
#define PINNEDQUEEN    -16
#define QUEEN_CENTER_BONUS 1
#define QUEEN_ATTACK_BONUS 5
#define QUEEN_MOBILITY_BONUS 5

/**********/
/*  King  */
/**********/
#define KINGOPENFILE  -18
#define KINGOPENFILE1 -12
#define ATAKKING       10
#define DEFENDKING     6
#define HOPEN	      -300 
#define GOPEN	      -30
#define KING_CENTER_BONUS 1
#define KING_ATTACK_BONUS 1
#define KING_MOBILITY_BONUS 1
#define RUPTURE -60
