/*
 * File: gtk_play.h
 * Author: Brent Hendricks
 * Project: NetSpades
 * Date: 1/23/99
 *
 * This fils contains function declarations for creating and handling menus  
 *
 * Copyright (C) 1998 Brent Hendricks.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include<gtk/gtk.h>

typedef struct playArea_t {
  
  GtkWidget* window;
  GtkWidget* field;
  GtkWidget* hand;
  GdkPixmap* handBuf;
  GdkPixmap* cards;
  GtkWidget* bidButton;
  GtkWidget* names[4];
  GtkWidget* table;
  GdkPixmap* tableBuf;
  GtkWidget* tallys[4];
  GtkWidget* bids[2];
  GtkWidget* scores[2];
  GtkWidget* teams[2];
  GtkItemFactory* menu;
  
} playArea_t;


void CreatePlayArea( void );
static gint exposeHand( GtkWidget*, GdkEventExpose*, gpointer  );
static gint configHand( GtkWidget*, GdkEventConfigure*, gpointer );
static gint exposeTable( GtkWidget*, GdkEventExpose*, gpointer  );
static gint configTable( GtkWidget*, GdkEventConfigure*, gpointer );
static gint ReadCard( GtkWidget*, GdkEventButton* );
static void ReadBid( GtkWidget* );
static gint SpinInput( GtkSpinButton*, gfloat* );
static gint SpinOutput( GtkSpinButton* );
