/*
 * File: sl_io.h
 * Author: Brent Hendricks
 * Project: NetSpades
 * Date: 1/17/99
 *
 * This file contains declarations and #defines for the slang specific 
 * display functions
 *
 * Copyright (C) 1998 Brent Hendricks.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include<slang.h>

#define CARDWIDTH    5
#define CARDHEIGHT   3
#define CARDTOP     13

#define TALLYWIDTH  25
#define TALLYHEIGHT CARDTOP-1
#define TALLYTOP     0
#define TALLYLEFT    0

#define TABLEWIDTH  31
#define TABLEHEIGHT 11
#define TABLETOP     0
#define TABLELEFT   25

#define SCOREWIDTH  24
#define SCOREHEIGHT CARDTOP-1
#define SCORETOP     0
#define SCORELEFT   56

#define STATTOP      CARDTOP+CARDHEIGHT+3
#define STATHEIGHT   SLtt_Screen_Rows-(STATTOP)-2

#define REDCARD   1
#define BLACKCARD 2
#define STDCOL    3
#define TAUNTCOL  4


/**
  * Returns an integer bid. -1 for kneels
  */
int InputBid( void );


/**
  * Returns an integer card 
  */
int InputCard( void );


/**
  * Returns a quit flag
  */
int InputQuery( void );


/**
  * Checks for presence of taunt
  */
int CheckForTaunt( void );


/**
  * Returns a taunt string.
  */
char* InputTaunt( void );


void Connect( void );
void PlayOffline( void );
