## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus.oberhumer@jk.uni-linz.ac.at>
## http://wildsau.idv.uni-linz.ac.at/mfx/pysol.html
##
##---------------------------------------------------------------------------##


# imports
import os, sys, string, time

# PySol imports
from mfxutil import SubclassResponsibility, Struct, destruct        #bundle#


# /***********************************************************************
# // FIXME - this a quick hack and needs a rewrite
# ************************************************************************/

class PysolStatsWriter:
    def __init__(self, app):
        self.app = app

    #
    #
    #

    class StringWriter:
        def __init__(self):
            self.text = ""

        def p(self, s):
            self.text = self.text + s
            return 1

        def pline(self, x, y, gameid, text):
            s = "%-30s %7s %7s %7s %7s\n" % text
            return self.p(s)

        def eline(self):
            return self.p("\n")


    class FileWriter(StringWriter):
        def __init__(self, file):
            self.file = file

        def p(self, s):
            self.file.write(s)
            return 1

    #
    #
    #

    # needs: writer.pline, writer.eline
    def writeStats(self, writer, player, header):
        app = self.app
        x, y = 1, 0
        y = y + writer.pline(x, y, 0, (header, "Played", "Won", "Lost", r"% won"))
        y = y + writer.eline()
        twon, tlost, tgames = 0, 0, 0
        g = app.getGamesIdSortedByName()
        for id in g:
            name = app.getGameMenuitemName(id)
            won, lost = app.stats.getStats(player, id)
            twon, tlost = twon + won, tlost + lost
            if won + lost > 0: perc = "%.1f" % (100.0 * won / (won + lost))
            else: perc = "0.0"
            if won > 0 or lost > 0 or id == app.game.id:
                y = y + writer.pline(x, y, id, (name, won+lost, won, lost, perc))
                tgames = tgames + 1
        y = y + writer.eline()
        won, lost = twon, tlost
        if won + lost > 0: perc = "%.1f" % (100.0 * won / (won + lost))
        else: perc = "0.0"
        ##y = y + writer.pline(x, y, 0, ("Totals for %d game%s" % (tgames, ("s", "")[tgames == 1]), won+lost, won, lost, perc))
        ##y = y + writer.pline(x, y, 0, ("Totals for %d from %d games" % (tgames, len(g)), won+lost, won, lost, perc))
        y = y + writer.pline(x, y, 0, ("Totals (%d out of %d games)" % (tgames, len(g)), won+lost, won, lost, perc))
        return tgames


    # needs: writer.p, writer.pline, writer.eline
    def writeFullStats(self, writer, player, header, title):
        p = writer.p
        date = time.ctime(time.time())
        date = time.strftime("%Y-%m-%d  %H:%M", time.localtime(time.time()))
        p("%-44s %17s\n" % (title, date))
        p("-" * 62 + "\n")
        writer.eline()
        self.writeStats(writer, player, header)
        writer.eline()
        writer.eline()
        self.writeLog(writer, player)


    # needs: writer.p, writer.pline, writer.eline
    def writeLog(self, writer, player):
        p = writer.p
        date = time.ctime(time.time())
        date = time.strftime("%Y-%m-%d  %H:%M", time.localtime(time.time()))
        if not player:
            return
        prev_games = self.app.stats.prev_games.get(player)
        if not prev_games:
            return 0
        title = "Log for " + player
        p("%-53s %17s\n" % (title, date))
        p("-" * 71 + "\n")
        writer.eline()
        p("Game                      Game number              Started at    Status\n")
        writer.eline()
        twon, tlost = 0, 0
        for pg in prev_games:
            name = self.app.getGameTitleName(pg[0])
            if not name:
                name = "** UNKNOWN **"
            f = pg[1]
            if len(f) == 16:
                ##fullid = "%s-%s-%s-%s" % (f[0:4], f[4:8], f[8:12], f[12:16])
                fullid = "%s-%s-%s" % (f[4:8], f[8:12], f[12:16])
            elif len(f) <= 20:
                fullid = f
            else:
                fullid = "** ERROR **"
            date = time.strftime("%Y-%m-%d  %H:%M", time.localtime(pg[3]))
            won = pg[2] > 0
            twon, tlost = twon + won, tlost + (1 - won)
            status = ("Lost", "Won")[won]
            p("%-25s %-20s  %17s  %s\n" % (name, fullid, date, status))
        writer.eline()
        writer.eline()
        return 1

