## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus.oberhumer@jk.uni-linz.ac.at>
## http://wildsau.idv.uni-linz.ac.at/mfx/pysol.html
##
##---------------------------------------------------------------------------##


# imports
import os, sys, types
import Tkinter, Canvas

# imports
from tkutil import unbind_destroy                                   #bundle#


# /***********************************************************************
# // canvas items
# ************************************************************************/

class _CanvasItem:
    def moveTo(self, x, y):
        c = self.coords()
        self.move(x-int(c[0]), y-int(c[1]))

    # fix a bug in unbind as distributed in all Python versions
    def unbind(self, sequence, funcid=None):
        self.canvas.tag_unbind(self.id, sequence, funcid)
        # Also should get rid of the self.canvas._tagcommands (which
        # were only in Python 1.5.2) or else our bindings will
        # grow forever...
        # For PySol this is handled in MfxCanvas::deleteItems()

class MfxCanvasGroup(_CanvasItem, Canvas.Group):
    def __init__(self, canvas, tag=None):
        Canvas.Group.__init__(self, canvas=canvas, tag=tag)
        # register ourself so that we can unbind from the canvas
        assert not self.canvas.items.has_key(self.id)
        self.canvas.items[self.id] = self
    def addtag(self, tag, option="withtag"):
        self.canvas.addtag(tag, option, self.id)
    def delete(self):
        del self.canvas.items[self.id]
        Canvas.Group.delete(self)
    def gettags(self):
        return self.canvas.tk.splitlist(self._do("gettags"))

class MfxCanvasImage(_CanvasItem, Canvas.ImageItem):
    pass

class MfxCanvasLine(_CanvasItem, Canvas.Line):
    pass

class MfxCanvasRectangle(_CanvasItem, Canvas.Rectangle):
    pass

class MfxCanvasText(_CanvasItem, Canvas.CanvasText):
    def __init__(self, canvas, x, y, **kw):
        if not kw.has_key("fill"):
            kw["fill"] = canvas._text_color
        apply(Canvas.CanvasText.__init__, (self, canvas, x, y), kw)
        self.text_format = None
        canvas._text_items.append(self)


# /***********************************************************************
# // canvas
# ************************************************************************/

class MfxCanvas(Tkinter.Canvas):
    def __init__(self, *args, **kw):
        apply(Tkinter.Canvas.__init__, (self,) + args, kw)
        # this is also used by lib-tk/Canvas.py
        self.items = {}
        # private
        self.__tileimage = None
        self.__tiles = []
        # friend MfxCanvasText
        self._text_color = "#000000"
        self._text_items = []

    # delete all CanvasItems but keep the background tiles
    def deleteItems(self):
        self._text_items = []
        for id in self.items.keys():
            assert not id in self.__tiles   # because the tile is created by id
            unbind_destroy(self.items[id])
            self.items[id].delete()
        assert self.items == {}
        assert len(self.__tiles) == len(self.find("all"))
        # finally get rid of the useless Python 1.5.2 _tagcommands
        self._tagcommands = {}

    def findCard(self, stack, event):
        if isinstance(stack.cards[0].item, Canvas.Group):
            current = self.gettags("current")           # get tags
            for i in range(len(stack.cards)):
                if stack.cards[i].item.tag in current:
                    return i
        else:
            current = self.find("withtag", "current")   # get item ids
            for i in range(len(stack.cards)):
                if stack.cards[i].item.id in current:
                    return i
        return -1

    def setTextColor(self, color):
        if self._text_color != color:
            self._text_color = color
            for item in self._text_items:
                item.config(fill=self._text_color)

    def setTile(self, image):
        try:
            if image and type(image) == types.StringType:
                image = Tkinter.PhotoImage(file=image)
        except Tkinter.TclError:
            return 0
        for id in self.__tiles:
            self.delete(id)
        self.__tiles = []
        # must keep a reference to the image, otherwise Python will
        # garbage collect it...
        self.__tileimage = image
        if image is None:
            return 1
        iw, ih = image.width(), image.height()
        sw, sh = self.winfo_screenwidth(), self.winfo_screenheight()
        for x in range(0, sw - 1, iw):
            for y in range(0, sh - 1, ih):
                id = self.create_image(x, y, image=image, anchor="nw")
                self.lower(id)
                self.__tiles.append(id)
        return 1

    #
    # debug
    #

    def update(self):
        ##import mfxutil; print mfxutil.callername()                #bundle#
        Tkinter.Canvas.update(self)

    def update_idletasks(self):
        ##import mfxutil; print mfxutil.callername()                #bundle#
        Tkinter.Canvas.update_idletasks(self)

