/*
                             Automatic Interval

	Functions:

	int AIntvTuneHandleAdjust()

	---

 */

#include "xsw.h"


/*
 *	Handles adjusting of the network interval.
 *
 *	Calls to this function must be timmed correctly.
 */
int AIntvTuneHandleAdjust()
{
	static long total_bytes;


	/* Make sure we are connected and logged in. */
        if((net_parms.player_obj_ptr == NULL) ||
           (net_parms.connection_state != CON_STATE_CONNECTED)
	)
	{
	    /* Not connected or not logged in. */
            /* Reset sx and rx byte counters. */
            loadstat.sx_ilast = loadstat.sx_interval;
	    loadstat.rx_ilast = loadstat.rx_interval;
            loadstat.sx_interval = 0;
            loadstat.rx_interval = 0;
	    return(-2);
	}


        /* Is auto interval tunning on? */
        if(!auto_interval_tune.state)
        {
            loadstat.sx_ilast = loadstat.sx_interval;
            loadstat.rx_ilast = loadstat.rx_interval;
            loadstat.sx_interval = 0;
            loadstat.rx_interval = 0;
         
            return(0);
        }


	/* Get total bytes. */
	total_bytes = loadstat.rx_interval + loadstat.sx_interval;

	/*   Convert total_bytes from per 1000 ms interval to per
	 *   auto_interval_tune.interval ms interval.
	 */
	if(auto_interval_tune.interval > 0)
	    total_bytes = total_bytes * 1000 / auto_interval_tune.interval;


	/* Check if load is greater or less than net_load_max. */
	if(total_bytes > loadstat.net_load_max)
	{
	    /* Over-flowing, must increase interval. */
            net_parms.net_int += 50;
	}
	else
	{
	    /* Bandwidth available, decrease interval. */
            net_parms.net_int -= 50;
	}


	/* Sanitize interval. */
        if(net_parms.net_int > MAX_SERVER_UPDATE_INT) 
            net_parms.net_int = MAX_SERVER_UPDATE_INT;
        if(net_parms.net_int < MIN_SERVER_UPDATE_INT)  
            net_parms.net_int = MIN_SERVER_UPDATE_INT;

	/*   If in energy saver mode, interval must be SERVER_DEF_INT
         *   or greater.
	 */
	if(option.energy_saver_mode)
	{
	    if(net_parms.net_int < SERVER_DEF_INT)
		net_parms.net_int = SERVER_DEF_INT;
	}


	/* Send interval update to server. */
        NetSendSetInterval();


	/* Reset sx and rx byte counters. */
        loadstat.sx_ilast = loadstat.sx_interval;
        loadstat.rx_ilast = loadstat.rx_interval;

	loadstat.sx_interval = 0;
	loadstat.rx_interval = 0;


	return(0);
}
