/*
 * XSOLDIER, a video-oriented game
 * Copyright (C) 1997, Yuusuke HASHIMOTO
 *                     s945750@educ.info.kanagawa-u.ac.jp
 *
 * ܥץˤ copyleft ŬѤƤޤCONDITION ե򻲾Ȥ
 * Ƥ
 */

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <pwd.h>
#include <sys/types.h>

#include "image.h"
#include "xsoldier.h"
#include "manage.h"
#include "common.h"
#include "callback.h"
#include "score.h"
#include "extern.h"

CharManage *NewManage(int playerMax, int enemyMax)
{
    CharManage *New;
    int i;

    New = (CharManage *)malloc(sizeof(CharManage));

    New->player = (CharObj **)malloc(sizeof(CharObj *) * playerMax);
    New->enemy = (CharObj **)malloc(sizeof(CharObj *) * enemyMax);

    New->PlayerMax = playerMax;
    New->PlayerNum = 0;
    New->EnemyMax = enemyMax;
    New->EnemyNum = 0;

    New->Level = 0;
    New->Stage = 1;
    New->Loop = 1;
    New->Appear = 0;

    New->StageEnemy = 0;
    New->StageShotDown = 0;
    New->ZakoApp = True;
    New->BossApp = False;
    New->BossKill = False;

    for (i=0; i<New->PlayerMax; i++)
    {
	New->player[i] = (CharObj *)malloc(sizeof(CharObj));
	New->player[i]->Data.used = False;
	New->player[i]->Action    = NullAct;
	New->player[i]->Realize   = NullReal;
	New->player[i]->Hit       = NullHit;
    }

    for (i=0; i<New->EnemyMax; i++)
    {
	New->enemy[i] = (CharObj *)malloc(sizeof(CharObj));
	New->enemy[i]->Data.used = False;
	New->enemy[i]->Action    = NullAct;
	New->enemy[i]->Realize   = NullReal;
	New->enemy[i]->Hit       = NullHit;
    }

    /*** 褯Ȥ륪֥Ȥ򤢤餫᥻åȤƤ ***/

    /*** ŨΤ ***/
    New->EnemyShot.Data.used = True;
    New->EnemyShot.Data.kill = False;
    New->EnemyShot.Data.hitAtt = MEShot;
    New->EnemyShot.Data.hitMask = MPlayer;
    New->EnemyShot.Data.EnemyAtt = NullDel;
    New->EnemyShot.Data.Width = 8;
    New->EnemyShot.Data.Height = 8;
    New->EnemyShot.Data.HarfW = New->EnemyShot.Data.Width/2;
    New->EnemyShot.Data.HarfH = New->EnemyShot.Data.Height/2;
    New->EnemyShot.Data.image = 0;
    New->EnemyShot.Data.Cnt[4] = 0; /*** image counter ***/
    New->EnemyShot.Grp.image = EShotImage;
    New->EnemyShot.Grp.Width = New->EnemyShot.Grp.image[0]->width;
    New->EnemyShot.Grp.Height = New->EnemyShot.Grp.image[0]->height;
    New->EnemyShot.Grp.HarfW = New->EnemyShot.Grp.Width/2;
    New->EnemyShot.Grp.HarfH = New->EnemyShot.Grp.Height/2;

    /*** ä㤤ȯ ***/
    New->Bomb.Data.used = True;
    New->Bomb.Data.kill = False;
    New->Bomb.Data.hitAtt = 0;
    New->Bomb.Data.hitMask = 0;
    New->Bomb.Data.Width = 0;
    New->Bomb.Data.Height = 0;
    New->Bomb.Data.HarfW = New->Bomb.Data.Width/2;
    New->Bomb.Data.HarfH = New->Bomb.Data.Height/2;
    New->Bomb.Data.image = 0;
    New->Bomb.Data.Cnt[0] = 0;
    New->Bomb.Grp.image = BombImage;
    New->Bomb.Grp.Width = New->Bomb.Grp.image[0]->width;
    New->Bomb.Grp.Height = New->Bomb.Grp.image[0]->height;
    New->Bomb.Grp.HarfW = New->Bomb.Grp.Width/2;
    New->Bomb.Grp.HarfH = New->Bomb.Grp.Height/2;

    /*** Ǥäȯ ***/
    New->LargeBomb.Data.used = True;
    New->LargeBomb.Data.kill = False;
    New->LargeBomb.Data.hitAtt = 0;
    New->LargeBomb.Data.hitMask = 0;
    New->LargeBomb.Data.Width = 0;
    New->LargeBomb.Data.Height = 0;
    New->LargeBomb.Data.HarfW = New->LargeBomb.Data.Width/2;
    New->LargeBomb.Data.HarfH = New->LargeBomb.Data.Height/2;
    New->LargeBomb.Data.image = 0;
    New->LargeBomb.Data.Cnt[0] = 0;
    New->LargeBomb.Grp.image = LargeBombImage;
    New->LargeBomb.Grp.Width = New->LargeBomb.Grp.image[0]->width;
    New->LargeBomb.Grp.Height = New->LargeBomb.Grp.image[0]->height;
    New->LargeBomb.Grp.HarfW = New->LargeBomb.Grp.Width/2;
    New->LargeBomb.Grp.HarfH = New->LargeBomb.Grp.Height/2;

    return New;
}

void ClearManage(CharManage *manage)
{/*** manage 򥹥ơϻ˥å ***/
    int i;

    if (manage->Stage > MaxStage) /*** ǽ̥ꥢϤä ***/
	manage->Appear = - 100;
    else
	manage->Appear = - 50;

    manage->ZakoApp = True;
    manage->BossApp = False;
    manage->BossKill = False;

    manage->StageEnemy = 0;
    manage->StageShotDown = 0;

    for (i=0; i<manage->EnemyMax; i++)
    {
	if (manage->enemy[i]->Data.used == True)
	{
	    NewLargeBomb(manage->enemy[i]->Data.X,manage->enemy[i]->Data.Y);
	    DelObj(manage->enemy[i]);
	}
    }
}

void ResetManage(CharManage *manage)
{/*** manage 򥲡ॹȻ˥å ***/
    int i;

    /*** manage->Loop ˤä Level ѹ ***/
    manage->Level = manage->Loop * 10;
    if (manage->Level >= 100)
	manage->Level = 90;

    manage->Stage = 1;

    manage->Appear = - 50;
    manage->ZakoApp = True;
    manage->BossApp = False;
    manage->BossKill = False;

    manage->StageEnemy = 0;
    manage->StageShotDown = 0;

    for (i=0; i<manage->PlayerMax; i++)
    {
	if (manage->player[i]->Data.used == True)
	    DelObj(manage->player[i]);
    }

    for (i=0; i<manage->EnemyMax; i++)
    {
	if (manage->enemy[i]->Data.used == True)
	    DelObj(manage->enemy[i]);
    }

    manage->PlayerNum = 0;
    manage->EnemyNum = 0;
}

void DeleteManage(CharManage *Del)
{
    int i;

    for (i=0; i<Del->PlayerMax; i++)
	free(Del->player[i]);
    for (i=0; i<Del->EnemyMax; i++)
	free(Del->enemy[i]);

    free(Del);
#ifdef DEBUG
    fprintf(stderr,"DeleteManage: clean up\n");
#endif
}

int NewObj(int mask,
	   DelAtt (*action)(ObjData *my),
	   DelAtt (*hit)(ObjData *my, ObjData *your),
	   void (*realize)(ObjData *my, GrpData *grp))
{
    int i;

    if (mask & (MPlayer|MPShot))
    {
	if (manage->PlayerNum >= manage->PlayerMax)
	    return -1; /*** ̵ ***/
	for (i=1; i<manage->PlayerMax; i++)
	{
	    if (manage->player[i]->Data.used == False)
	    {/*** ̤ѥ֥ȯ ***/
		manage->player[i]->Data    = manage->New.Data;
		manage->player[i]->Grp     = manage->New.Grp;
		manage->player[i]->Action  = action;
		manage->player[i]->Realize = realize;
		manage->player[i]->Hit     = hit;
		/*** Ͽ ***/
		
		manage->player[i]->Data.used = True;
		manage->player[i]->Data.kill = False;
		manage->player[i]->Data.HarfW = manage->player[i]->Data.Width >>1;
		manage->player[i]->Data.HarfH = manage->player[i]->Data.Height >>1;
		
		manage->player[i]->Data.startTime = manage->Level;
		manage->player[i]->Data.shotTime = (ShotTiming + manage->Level) >>1;
		
		manage->player[i]->Data.image = 0;
		
		manage->player[i]->Grp.Width = manage->player[i]->Grp.image[0]->width;
		manage->player[i]->Grp.Height = manage->player[i]->Grp.image[0]->height;
		manage->player[i]->Grp.HarfW = manage->player[i]->Grp.Width >>1;
		manage->player[i]->Grp.HarfH = manage->player[i]->Grp.Height >>1;
		
		manage->PlayerNum++;
		return i;
	    }
	}
    }
    else /*if (mask & (MEnemy|MEShot))*/
    {
	if (manage->EnemyNum >= manage->EnemyMax)
	    return -1; /*** ̵ ***/

	if (manage->New.Data.EnemyAtt == BossDel)
	    i = 0; /*** ܥϿֹ 0 ͽ󤷤Ƥ ***/
	else
	    i = 1;
	for ( ; i<manage->EnemyMax; i++)
	{
	    if (manage->enemy[i]->Data.used == False)
	    {/*** ̤ѥ֥ȯ ***/
		manage->enemy[i]->Data    = manage->New.Data;
		manage->enemy[i]->Grp     = manage->New.Grp;
		manage->enemy[i]->Action  = action;
		manage->enemy[i]->Realize = realize;
		manage->enemy[i]->Hit     = hit;
		/*** Ͽ ***/
		
		manage->enemy[i]->Data.used = True;
		manage->enemy[i]->Data.kill = False;
		manage->enemy[i]->Data.HarfW = manage->enemy[i]->Data.Width >>1;
		manage->enemy[i]->Data.HarfH = manage->enemy[i]->Data.Height >>1;
		
		manage->enemy[i]->Data.startTime = manage->Level;
		manage->enemy[i]->Data.shotTime = (ShotTiming + manage->Level) >>1;
		
		manage->enemy[i]->Data.image = 0;
		
		manage->enemy[i]->Grp.Width = manage->enemy[i]->Grp.image[0]->width;
		manage->enemy[i]->Grp.Height = manage->enemy[i]->Grp.image[0]->height;
		manage->enemy[i]->Grp.HarfW = manage->enemy[i]->Grp.Width >>1;
		manage->enemy[i]->Grp.HarfH = manage->enemy[i]->Grp.Height >>1;
		
		manage->EnemyNum++;
		return i;
	    }
	}
    }
}

void DelObj(CharObj *del)
{
    if (del->Data.used == True)
    {
	del->Data.used = False;
	if (del->Data.hitAtt & (MPlayer|MPShot))
	    manage->PlayerNum--;
	else
	    manage->EnemyNum--;
    }
}

PlayerData *NewPlayerData(void)
{
    PlayerData *New;
    struct passwd *pw;
    char name[16];

    if ((pw=getpwuid(getuid())) == NULL)
        sprintf(name,"%d",getuid());
    else
        strcpy(name,pw->pw_name);

    New = (PlayerData *)malloc(sizeof(PlayerData));

    sprintf(New->Rec[0].name,name);
    New->Rec[0].score = 0;
    New->Rec[0].stage = 0;
    New->Rec[0].loop = 0;
    /*** ץ쥤εϿ ***/

    /*** ϥΤߤ ***/
    ReadHiscore(New);

    return New;
}
