/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _GUI_COLORMAP_H
#define _GUI_COLORMAP_H


#include <gtk--.h>
#include <gtk/gtk.h>
#include "GlobalDefs.h"


#define MAXBRIGHT 65536

/*
 *  GuiColormap: basic colormap utility class 
 */
class GuiColormap
	{
	public:
				GuiColormap (Gtk_Widget *parent, int maxcolors);
				~GuiColormap ();
		GdkColor	*getColor (int index);
		int		getColorCount ();
		bool		addColor (GdkColor *col, int r, int g, int b);
		bool		addColor (GdkColor *col);
		bool		addNamedColor (GdkColor *col, char *colname);

		GdkColor 		d_black;
		GdkColor 		d_white;
		bool			d_linear;

	protected: 
		bool		allocColor (GdkColor *col, int r, int g, int b);
		bool		allocColor (GdkColor *col);
		bool		allocNamedColor (GdkColor *col, char *colname);

		int			d_maxcolors;
		int			d_ncolors;

	private: 
		GdkColormap		*p_colormap;
		GdkColor		*p_colors;
	};


#endif // _GUI_COLORMAP_H
