// ---------------------------------------------------------------------------
// - Exception.cpp                                                           -
// - standard object library - exception class implementation                -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Exception.hpp"

namespace aleph {

  // create a exception with an id
  
  Exception::Exception (const String& eid) {
    d_eid    = eid;
    p_object = nilp;
    d_nlf    = false; 
    d_abf    = false; 
  }

  // create a exception with an id and a reason
  
  Exception::Exception (const String& eid, const String& reason) {
    d_eid    = eid;
    d_reason = reason;
    p_object = nilp;
    d_nlf    = false;
    d_abf    = false;
  }

  // create a exception with an eid, an indicator and a long reason
  
  Exception::Exception (const String& eid, const String& reason,
			const String& name) {
    d_eid    = eid;
    d_reason = reason + " " + name;
    p_object = nilp;
    d_nlf    = false;
    d_abf    = false;
  }

  // create a exception with an id and an object
  
  Exception::Exception (const String& eid, Object* object) {
    d_eid    = eid;
    p_object = Object::iref (object);
    d_nlf    = false;
    d_abf    = false;
  }

  // create a exception with a short type, a reason and an object
  
  Exception::Exception (const String& eid, const String& reason,
			Object* object) {
    d_eid    = eid;
    d_reason = reason;
    p_object = Object::iref (object);
    d_nlf    = false;
    d_abf    = false;
  }

  // copy constructor for this exception
  
  Exception::Exception (const Exception& that) {
    d_eid    = that.d_eid;
    d_reason = that.d_reason;
    p_object = Object::iref (that.p_object);
    d_nlf    = that.d_nlf;
    d_abf    = that.d_abf;
  }

  // return the class name

  String Exception::repr (void) const {
    return "Exception";
  }

  // set the new line flag

  void Exception::setnlf (const bool flag) {
    d_nlf = flag;
  }

  // set the abort flag

  void Exception::setabf (const bool flag) {
    d_abf = flag;
  }

  // evaluate an exception member name

  Object* Exception::eval (Interp* interp, Nameset* nset, const String& name) {
    if (name == "eid")    return new String (d_eid);
    if (name == "reason") return new String (d_reason);
    if (name == "object") return p_object;
    
    // evaluate in the object
    return Object::eval (interp, nset, name);
  }
}
