/*
 * Unicode Conversion Library (UCS2 to Shift_JIS)
 * 1999 by yoshidam
 *
 */

#ifdef USE_SJIS

#include <string.h>
#include "uconv.h"
#include "u2s.h"
#include "ustring.h"


int
u2s_conv2(const unsigned char* u, int len, UString* s,
	  unknown_unicode unknown_u_conv)
{
  int i;
  unsigned char* ebuf;

  allocUString(s);

  for (i = 0; i < len; i+=2) {
    unsigned short schar = u2s_tbl[u[i] | (u[i+1] << 8)];
    if (schar == 0) { /* Unknown char */
      if (unknown_u_conv != NULL) {
	unsigned char* us = unknown_u_conv(u[i] | (u[i+1] << 8));
	int len = strlen(us);
	addUString(s, us, len);
	free(us);
      }
      else {
	addUChar(s, '?');
      }
    }
    else if (schar < 128) { /* ASCII */
      addUChar(s, schar);
    }
    else if (schar > 0xa0 && schar <= 0xdf) { /* JIS X 0201 kana */
      addUChar(s, schar);
    }
    else if (schar > 0x8140 && schar != 0xffff) { /* JIS X 0208 */
      addUChar2(s, schar >> 8, schar & 0xff);
    }
    else {
      if (unknown_u_conv != NULL) {
	unsigned char* us = unknown_u_conv(u[i] | (u[i+1] << 8));
	int len = strlen(us);
	addUString(s, us, len);
	free(us);
      }
      else {
	addUChar(s, '?');
      }
    }
  }

  return s->len;
}

#if 0
unsigned char*
conv(unsigned short u)
{
  unsigned char* ret = malloc(3);
  strcpy(ret, "??");
  return ret;
}

int
main(void)
{
  UString s;
  u2s_conv2("\x42\x30\x44\x30\0\0", 4, &s, conv);
  dumpUString(&s);
  return 0;
}
#endif

#endif /* USE_SJIS */
