/********************************************************************************
*                                                                               *
*                       F o u r - W a y   S p l i t t e r                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 1999 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FX4Splitter.h,v 1.7 1999/11/16 08:21:48 jeroen Exp $                     *
********************************************************************************/
#ifndef FX4SPLITTER_H
#define FX4SPLITTER_H


// Splitter options
enum FX4SplitterStyle {
  FOURSPLITTER_TRACKING = 0x00008000    /// Track continuous during split
  };



// Splitter window 
class FXAPI FX4Splitter : public FXComposite {
  FXDECLARE(FX4Splitter)
private:
  FXint     splitx;         // Current x split
  FXint     splity;         // Current y split
  FXint     expanded;       // Panes which are expanded
  FXint     barsize;        // Size of the splitter bar
  FXint     fhor;           // Horizontal split fraction
  FXint     fver;           // Vertical split fraction
  FXint     offx;
  FXint     offy;
  FXuchar   mode;
protected:
  FX4Splitter();
  FXuchar getMode(FXint x,FXint y);
  void moveSplit(FXint x,FXint y);
  void drawSplit(FXint x,FXint y);
  void adjustLayout();
  virtual void layout();
private:
  FX4Splitter(const FX4Splitter&);
  FX4Splitter &operator=(const FX4Splitter&);
public:
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
  long onFocusUp(FXObject*,FXSelector,void*);
  long onFocusDown(FXObject*,FXSelector,void*);
  long onFocusLeft(FXObject*,FXSelector,void*);
  long onFocusRight(FXObject*,FXSelector,void*);
  long onCmdExpand(FXObject*,FXSelector,void*);
  long onUpdExpand(FXObject*,FXSelector,void*);
public:
  enum{
    ID_EXPAND_ALL=FXComposite::ID_LAST,
    ID_EXPAND_TOPLEFT,
    ID_EXPAND_TOPRIGHT,
    ID_EXPAND_BOTTOMLEFT,
    ID_EXPAND_BOTTOMRIGHT,
    ID_LAST
    };
public:
  FX4Splitter(FXComposite* p,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
  FXWindow *getTopLeft() const;
  FXWindow *getTopRight() const;
  FXWindow *getBottomLeft() const;
  FXWindow *getBottomRight() const;
  FXint getHSplit() const { return fhor; }
  FXint getVSplit() const { return fver; }
  void setHSplit(FXint s);
  void setVSplit(FXint s);
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  FXuint getSplitterStyle() const;
  void setSplitterStyle(FXuint style);
  void setBarSize(FXint bs);
  FXint getBarSize() const { return barsize; }
  void setExpanded(FXint ex);
  FXint getExpanded() const { return expanded; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  };


#endif
